<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");
include_once("./functions/item_type.php");
include_once("./functions/parseutils.php");
include_once("./functions/widgets.php");
include_once("./functions/utils.php");
include_once("./functions/item.php");
include_once("./functions/user.php");
include_once("./functions/status_type.php");
include_once("./functions/site_plugin.php");

function display_site_plugin_blocks($HTTP_VARS, $item_r=NULL)
{
	global $CONFIG_VARS;
	global $LANG_VARS;

	// At least one input field provided for user input.
	$input_field_provided=FALSE;
	
	$results = fetch_site_plugin_rs($HTTP_VARS['s_item_type']);
	if($results)
	{
		echo get_popup_javascript();
		
		echo("\n<table cellspacing=1 cellpadding=1 width=\"90%\">");

		// Yes we have one.
		$input_field_provided=TRUE;
			
		$count = 0;
		while($site_plugin_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			if(is_exists_site_plugin($site_plugin_r['site_type']))
			{			
				// Do not get s_item_type records if s_item_type already defined.  We would not be inside
				// unless this site_type was compatible with the specified s_item_type...
				if(strlen($HTTP_VARS['s_item_type'])==0)
				{
					$sitresults = fetch_site_item_type_rs($site_plugin_r['site_type']);
				}
				
				if($count == 0)
					echo("\n<tr>");
				
				if(strlen($HTTP_VARS['s_item_type'])>0 || $sitresults)
				{
					echo("\n<td valign=\"top\">");
					
					echo("<form action=\"item_input.php\" method=\"get\">");
					echo("<table cellspacing=3 cellpadding=0><tr><td colspan=2><table border=0><tr><td>");
					echo("\n<a href=\"javascript:popup('external.php?url=".urlencode($site_plugin_r['external_url'])."&title=".urlencode($site_plugin_r['title'])."', 800, 600);\">");
					if(strlen($site_plugin_r['image'])>0)
					{
						echo("\n<img src=\"./site/images/".$site_plugin_r['image']."\" title=\"".$site_plugin_r['title']."\" alt=\"".$site_plugin_r['title']."\" valign=absmiddle align=absmiddle border=0>");
					}
					echo("</a>");
					echo("</td><td><font class=\"fineprint\">".$site_plugin_r['description']."</font></td></tr></table>");
				
					echo("\n<input type=hidden name=\"op\" value=\"site-search\"></font>");
					echo("\n<input type=hidden name=\"site_type\" value=\"".$site_plugin_r['site_type']."\">");
				
					// Let the item_input script validate the owner_id, just pass it through for now.
					if(strlen($HTTP_VARS['owner_id'])>0)
					{
						echo("\n<input type=hidden name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">");
					}
					
					echo("\n<input type=hidden name=\"s_status_type\" value=\"".$HTTP_VARS['s_status_type']."\">");
					echo("\n<input type=hidden name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">");
					echo("\n<input type=hidden name=\"item_id\" value=\"".$HTTP_VARS['item_id']."\">");
					echo("\n<input type=hidden name=\"instance_no\" value=\"".$HTTP_VARS['instance_no']."\">");
					echo("\n<input type=hidden name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">");
					echo("\n<input type=hidden name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">");
					echo("</td></tr>");
					
					$inrow=FALSE;
					$sifresults = fetch_site_plugin_input_field_rs($site_plugin_r['site_type']);
					if($sifresults)
					{
						while($input_field_r = mysql_fetch_array($sifresults, MYSQL_ASSOC))
						{
							// Only if we are are refreshing an item.
							if(is_not_empty_array($item_r))
							{
								$value = expand_item_title_mask($item_r, $input_field_r['refresh_mask']);
							}
							else if($input_field_r['field_type'] != 'hidden')
							{
								// a kludge to support feature request #816240 - failure when adding an item should return previous search
								$mask_elements = parse_field_mask($input_field_r['refresh_mask']);
								$value = ifempty(expand_field_mask($HTTP_VARS, $input_field_r['refresh_mask'], $mask_elements),
												$input_field_r['default_value']);
							}
							else
							{
								$value = $input_field_r['default_value'];
							}
							
							// The format of the field is defined here.  Currently only 'hidden'
							// is supported, otherwise the default text field will be displayed.
							switch($input_field_r['field_type'])
							{
								case 'hidden':
									echo("\n<input type=hidden name=\"".$input_field_r['field']."\" value=\"".htmlspecialchars($value)."\">\n");
									break;
									
								default:
								
									$field = "<input type=text name=\"".$input_field_r['field']."\" value=\"".htmlspecialchars($value)."\">";
									
									// If no prompt defined, don't try to display it!
									if(strlen($input_field_r['prompt'])>0)
									{
										if($inrow)
										{
											echo("\n</td></tr>");
											$inrow = FALSE;
										}
										
										echo("\n<tr><td align=right nowrap><font class=\"colortext\">".$input_field_r['prompt'].":&nbsp;</font></td>");
										
										echo("\n<td nowrap>");
										echo($field);
										
										$inrow = TRUE;
									}	
									else
									{
										if(!$inrow)
										{
											echo("\n<tr><td>");
											$newrow = TRUE;
										}
										echo($field);
									}
							}
						}//while
						
						if($inrow)
						{
							echo("</td></tr>");
						}
						mysql_free_result($sifresults);
					}//if($sifresults)
					
					echo("\n<tr><td colspan=2 nowrap>");
					if(is_exists_item_type($HTTP_VARS['s_item_type']))
					{
						echo ("\n<input type=hidden name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">");
					}
					else
					{
						echo(single_select("s_item_type", $sitresults, "%value% - %display%", NULL, NULL));
					}
					echo("&nbsp;<input type=submit value=\"".replace_lang_var("site", $site_plugin_r['title'], $LANG_VARS['site_search'])."\">");
					echo("\n</td></tr>");
					
					echo("\n<tr><td colspan=2>&nbsp;</td></tr>");
					
					echo("</table></form>");
					echo("\n</td>\n");
				}
				
				$count++;
				if($count == 2)
				{
					echo("\n</tr>");
					$count = 0;
				}
			}
		}//while($site_plugin_r = mysql_fetch_array($results, MYSQL_ASSOC))
		mysql_free_result($results);
				
		if($count > 0)
		{	
			for($i=$count; $i<2; $i++)
				echo("\n<td>&nbsp;</td>");
			echo("\n</tr>");
		}
		echo("\n</table>");
	}//if($results)
	
	if($item_r == NULL)
	{
		$input_field_provided = TRUE;
		
		echo("<table cellspacing=1 cellpadding=1>\n<tr><td colspan=2>");
		echo("<form action=\"item_input.php\" method=\"get\">");
		echo("\n<input type=hidden name=op value=\"new\">");
	
		// Let the item_input script validate the owner_id, just pass it through for now.
		if(strlen($HTTP_VARS['owner_id'])>0)
		{
			echo("\n<input type=hidden name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">");
		}
		echo("\n<input type=hidden name=\"s_status_type\" value=\"".$HTTP_VARS['s_status_type']."\">");
		echo("\n<input type=hidden name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">");
		echo("\n<input type=hidden name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">");
		echo("\n<input type=hidden name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">");
		
		echo("<div class=\"colortext\">");
		if(file_exists("./site/images/manual.gif"))
			echo("\n<img src=\"./site/images/manual.gif\" title=\"".$LANG_VARS['manual_entry']."\" alt=\"".$LANG_VARS['manual_entry']."\" valign=absmiddle align=absmiddle border=0>");
		else
			echo(_theme_image('icon.gif', NULL, NULL, 'absmiddle'));
		echo("&nbsp;".$LANG_VARS['manual_entry']);
		echo("</div></td></tr>");
		
		echo("\n<tr><td colspan=2 nowrap>");
		if(is_exists_item_type($HTTP_VARS['s_item_type']))
		{
			echo ("\n<input type=hidden name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">");
		}
		else
		{
			$results = fetch_item_type_rs(TRUE);
			if($results)
			{
				echo(single_select("s_item_type", $results, "%value% - %display%", NULL, NULL));
			}
		}
	
		echo("&nbsp;<input type=submit value=\"".$LANG_VARS['do_it_yourself']."\">");
		
		echo("\n</td></tr>");
		echo("\n</form></table>");
	}
	
	if($input_field_provided)
		return TRUE;
	else
		return FALSE;
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if (is_opendb_valid_session())
	{
		if(is_user_allowed_to_own($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
		{
			if(is_numeric($HTTP_VARS['parent_id']) && is_numeric($HTTP_VARS['parent_instance_no']))
			{
				$parent_item_r = fetch_item_instance_r($HTTP_VARS['parent_id'], $HTTP_VARS['parent_instance_no']);
			}
			
			// At least the item_id specified, now we check if item or item_instance.
			if(is_numeric($HTTP_VARS['item_id']))
			{
				if(is_not_empty_array($parent_item_r))
					$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
				else if(is_numeric($HTTP_VARS['instance_no']))
					$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
			}
			
			// New item.
			if(!is_array($parent_item_r) && !is_array($item_r))
			{
				if(!is_numeric($HTTP_VARS['item_id']))
				{
					$show_owner_field = FALSE;
					$show_status_type_field = FALSE;
					if($HTTP_VARS['confirmed'] === 'false')
					{
						if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
						{
							$show_owner_field = TRUE;
							$show_status_type_field = TRUE;
						}
						else if(strlen($HTTP_VARS['s_status_type'])==0)
						{
							$status_type_results = fetch_newitem_status_type_rs($HTTP_VARS['owner_id']);
                            if($status_type_results && mysql_num_rows($status_type_results)>1)
                            {
								$show_status_type_field = TRUE;
							}
							else
							{
                                $status_type_r = mysql_fetch_array($status_type_results, MYSQL_ASSOC);
                                if($status_type_r)
                                {
                                    $HTTP_VARS['s_status_type'] = $status_type_r['value'];
								}
								mysql_free_result($status_type_results);
							}
						}
					}
					else
					{
						if(strlen($HTTP_VARS['owner_id'])==0 && is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
						{
							$show_owner_field = TRUE;
						}
						
						if(strlen($HTTP_VARS['s_status_type'])==0)
						{
                            $status_type_results = fetch_newitem_status_type_rs($HTTP_VARS['owner_id']);
                            if($status_type_results && mysql_num_rows($status_type_results)>1)
                            {
								$show_status_type_field = TRUE;
							}
							else
							{
                                $status_type_r = mysql_fetch_array($status_type_results, MYSQL_ASSOC);
                                if($status_type_r)
                                {
                                    $HTTP_VARS['s_status_type'] = $status_type_r['value'];
								}
								mysql_free_result($status_type_results);
							}
						}
					}
					
					//$HTTP_VARS['confirmed']==='false' indicates we have already been to the form, and that originally
					// either one or both the owner_id and s_status_type were undefined.
					if($show_owner_field || $show_status_type_field)
					{
						$page_title = $LANG_VARS['add_item'];
						echo _theme_header($page_title);

						if(is_exists_item_type($HTTP_VARS['s_item_type']))
							echo("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>");
						else
							echo("<h2>".$page_title."</h2>");
							
						echo("\n<table border=0 frameborder=0 cellspacing=1>".
							"<form action=\"$PHP_SELF\" method=\"post\">".
							get_url_fields($HTTP_VARS, array('confirmed'=>'true')));

						$HTTP_VARS['owner_id'] = ifempty($HTTP_VARS['owner_id'], $HTTP_SESSION_VARS['user_id']);
						
						if($show_owner_field)
						{
							echo(
								format_field(
									$LANG_VARS['owner'],
									NULL, // prompt_mask
									"\n<select name=\"owner_id\" onChange=\"this.form['confirmed'].value='false'; this.form.submit();\">".
									custom_select(
										'owner_id', 
										fetch_user_rs(get_owner_user_types_r()), 
										'%fullname% (%user_id%)',
										'NA',
										$HTTP_VARS['owner_id'],
										'user_id').
									"\n</select>"));
						}
						
						if($show_status_type_field)
						{
							//$lookup_results = fetch_newitem_status_type_rs($HTTP_VARS['owner_id']);
							// Only include Status type restriction, if more than once status type.
							if($status_type_results && mysql_num_rows($status_type_results)>1)
							{
								echo format_field(
									$LANG_VARS['s_status_type'],
									NULL,
									radio_grid('s_status_type',
										$status_type_results,
										'%img%', // mask
										'3', // columns
										'', // border
										NULL)); // value
							}
						}

						echo("<tr><td colspan=2 align=left><br><input type=\"submit\" value=\"".$LANG_VARS['add_item']."\"></td></tr>");
						echo("</form></table>");
					}//if($show_owner_field || $show_status_type_field)
					else
					{	
						$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
						if(is_array($status_type_r))
						{
							if($HTTP_VARS['owner_id'] != $HTTP_SESSION_VARS['user_id'])
								$page_title = replace_lang_vars(array('s_status_type_desc'=>$status_type_r['description'], 'user_id'=>$HTTP_VARS['owner_id'], 'fullname'=>fetch_user_name($HTTP_VARS['owner_id'])), $LANG_VARS['add_s_status_type_item_for_name']);
							else
								$page_title = replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']);
						}
						else 
						{
							if($HTTP_VARS['owner_id'] != $HTTP_SESSION_VARS['user_id'])
								$page_title = replace_lang_vars(array('user_id'=>$HTTP_VARS['owner_id'], 'fullname'=>fetch_user_name($HTTP_VARS['owner_id'])), $LANG_VARS['add_item_for_name']);
							else
								$page_title = $LANG_VARS['add_item'];
						}
						echo _theme_header($page_title);

						if(is_exists_item_type($HTTP_VARS['s_item_type']))
							echo("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>");
						else
							echo("<h2>".$page_title."</h2>");
						
						if( is_user_allowed_to_own($HTTP_VARS['owner_id']) && (
								$HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] || 
								is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])) )
						{	
							// If status_type for this item is closed, we must generate an error, as this is illegal.	
							if(!is_array($status_type_r) || $status_type_r['closed_ind'] != 'Y')
							{	
								if(!is_array($status_type_r) || $status_type_r['insert_ind'] == 'Y')
								{
									if(!is_array($status_type_r) || strlen($status_type_r['min_create_user_type'])==0 || in_array($status_type_r['min_create_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
									{
										// Do display choices dialog if refreshing an item!
										echo("<div class=\"colortext\">");
										echo($LANG_VARS['item_add_intro']."<br><br>");
										$plugin_display = display_site_plugin_blocks($HTTP_VARS, $item_r);
										echo("</div>");
										
										if(!$plugin_display)
											echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
									}
									else //if(in_array($status_type_r['min_create_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
									{
										echo("<div class=\"error\">".
											replace_lang_vars(array('usertype'=>get_usertype_description($HTTP_SESSION_VARS['user_type']),'s_status_type_desc'=>$status_type_r['description']),$LANG_VARS['s_status_type_create_access_disabled_for_usertype']).
											"</div>");
									}
								}
								else//if($status_type_r['insert_ind'] == 'Y')
								{
									echo("<div class=\"error\">".
											replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['operation_not_avail_s_status_type']).
											"</div>");
								}
							}
							else // if($status_type_r['closed_ind'] != 'Y')
							{
								echo("<div class=\"error\">".
									replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['s_status_type_not_supported']).
									"</div>");
							}
						}
						else
						{
							echo("<div class=\"error\">".
									$LANG_VARS['operation_not_available'].
									"</div>");
						}
					}
				}
				else //if(!is_numeric($HTTP_VARS['item_id']))
				{
					echo _theme_header($lang_var['item_not_found']);
					echo("<div class=\"error\">".$lang_var['item_not_found']."</div>");
				}
			}
			else if(is_not_empty_array($parent_item_r)) // Child item edit/add
			{
				$page_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($parent_item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['edit_title']);
				echo _theme_header($page_title);
				echo("\n<h2>".$page_title." ".get_item_image($parent_item_r['s_item_type'])."</h2>");
			
				if(is_not_empty_array($item_r)) // Child item refresh
				{
					echo("\n<h3>".replace_lang_var("title", $item_r['title'], $LANG_VARS['refresh_linked_title'])." ".get_item_image($item_r['s_item_type'], NULL, TRUE)."</h3>\n");
				}
				else // Add new child item.
				{
					// Enforce the $s_item_type in this case.
					if($CONFIG_VARS['item_input.link_same_type_only']===TRUE)
					{
						$HTTP_VARS['s_item_type'] = $parent_item_r['s_item_type'];
						echo ("<h3>".$LANG_VARS['add_linked_item']." ".get_item_image($parent_item_r['s_item_type'])."</h3>\n");
					}
					else
					{
						echo ("<h3>".$LANG_VARS['add_linked_item']."</h3>\n");
					}
				}
				
				echo("<div class=\"colortext\">");
				$plugin_display = display_site_plugin_blocks($HTTP_VARS, $item_r);
				echo("</div>");
				if(!$plugin_display)
					echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
			}
			else if(is_not_empty_array($item_r)) // Parent item refresh
			{
				$HTTP_VARS['s_item_type'] = $item_r['s_item_type'];
			
				$page_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['refresh_title']);
				echo _theme_header($page_title);
				echo("<h2>".$page_title." ".get_item_image($item_r['s_item_type'])."</h2>\n");
				
				echo("<div class=\"colortext\">");
				$plugin_display = display_site_plugin_blocks($HTTP_VARS, $item_r);
				echo("</div>");
				if(!$plugin_display)
					echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
			}
	
			// Now the links...
			if($HTTP_VARS['item_link'] === 'y' && is_exists_item_instance($HTTP_VARS['item_id'],$HTTP_VARS['instance_no']))
			{
				$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
			}
	
			if(is_array($parent_item_r))
			{
				$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['parent_id']."&instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
			}
			
			// Include a Back to Listing link.
			if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
			{
				$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
			}
		}//no guests or borrowers allowed!
		else
		{				 
			echo _theme_header($LANG_VARS['not_authorized_to_page']);
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
		}
		
		echo format_footer_links($footer_links_r);
		echo _theme_footer();
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
