<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/SitePlugin.class.inc");

class amazon extends SitePlugin
{
	var $_pageBuffer;
	
	function amazon($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		if(strlen($search_vars_r['amazonasin'])>0)
		{
			$this->_pageBuffer = $this->fetchURI("http://www.amazon.com/exec/obidos/ASIN/".$search_vars_r['amazonasin']);
			
			if(strlen($this->_pageBuffer)>0)
				$this->addListingRow(NULL, NULL, NULL, array('amazonasin'=>$search_vars_r['amazonasin']));
				
			return TRUE;
		}
		else
		{
			// Get the mapped AMAZON index type
			$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
	
			if($index_type == 'videogames') // not sure whether this will always work, but it does return data similiar to that for the other types, including most popular and the rest.
				$queryUrl = "http://www.amazon.com/exec/obidos/search-handle-url/field-keywords=".rawurlencode($search_vars_r['title'])."&index=videogames&search-type=ss&sz=$items_per_page&pg=$page_no/ref=sr_1_4_etk-vg_all";
			else
				$queryUrl = "http://www.amazon.com/exec/obidos/external-search?index=".$index_type."&keyword=".rawurlencode($search_vars_r['title'])."&sz=$items_per_page&pg=$page_no";

			$this->_pageBuffer = $this->fetchURI($queryUrl);
		}
		
		if(strlen($this->_pageBuffer)>0)
		{
			$amazonasin = FALSE;
			
			// check for an exact match, but not if this is second page of listings or more
			if(!$this->isPreviousPage())
			{
				if (preg_match("/ASIN: <font>(\w{10})<\/font>/", $this->_pageBuffer, $regs))
				{
					$amazonasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: (\w{10})/", strip_tags($this->_pageBuffer), $regs))
				{
					$amazonasin = trim($regs[1]);
				}
				else if (preg_match ("/ISBN: ([^;]+);/", strip_tags($this->_pageBuffer), $regs)) // for books, ASIN is the same as ISBN
				{
					$amazonasin = trim ($regs[1]);
				} 
			}
			
			// exact match
			if($amazonasin!==FALSE)
			{
				// single record returned
				$this->addListingRow(NULL, NULL, NULL, array('amazonasin'=>$amazonasin));
				
				return TRUE;
			}
			else
			{
				if(preg_match("/All[\s]*([0-9]+)[\s]*results for/i", $this->_pageBuffer, $regs))
				{
					// store total count here.
					$this->setTotalCount($regs[1]);
					
					$start_of_block = strpos($this->_pageBuffer, "results for", $start_of_block);
					if($start_of_block!==FALSE)
					{
						// Video game format does have to be different!
						if($index_type == 'videogames')
						{
							$title_regs_pattern = ":<b><a href=/exec/obidos/tg/detail/-/([^/]*)/[^>]*>([^<]*)</a></b>:U";
						}	
						else
						{
							$title_regs_pattern = ":<b><a href=/exec/obidos/tg/detail/-/([^/]*)/[^>]*>([^<]*)</a></b>:U";
						}

						$parseblock = substr($this->_pageBuffer, $start_of_block);
						if(preg_match_all($title_regs_pattern, $parseblock, $matches))
						{
							for ($i = 0; $i < count($matches[1]); $i++)
							{
								$thumbimg = NULL;
								
								if(preg_match("!<img src=\"(http://.*".$matches[1][$i].".*jpg\")[^<]*>!U", $parseblock, $regs))
									$thumbimg = $regs[1];
								
								$this->addListingRow($matches[2][$i].' '.trim($matches[3][$i]), $thumbimg, NULL, array('amazonasin'=>$matches[1][$i]));
							}
							
							return TRUE;
						}
					}
				}
			}
			
			//default
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	/**
	* 
	*/
	function queryItem($search_attributes_r, $s_item_type)
	{
		// assumes we have an exact match here
		if(strlen($this->_pageBuffer)==0)
		{
			$this->_pageBuffer = $this->fetchURI("http://www.amazon.com/exec/obidos/ASIN/".$search_attributes_r['amazonasin']);
		}
		
		// no sense going any further here.
		if(strlen($this->_pageBuffer)==0)
			return FALSE;
		
		// The location of the title is the same for all formats.
		if (preg_match("/<title>.*Amazon\.com: [^:]*: ([^<]*)<\/title>/s", $this->_pageBuffer, $regs))
		{
			// If extra year appended, remove it and just get the title.
			if(preg_match("/(.*)\([0-9]+\)$/", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else
				$title = $regs[1];
			
			$this->addItemAttribute('title', convert_html_numeric_codes(strip_tags(trim(str_replace("\"", "", $title)))));
		}
	
		// Image src extraction block
		// <a href="http://images.amazon.com/images/P/B0000640S2.01.LZZZZZZZ.jpg">
		if (preg_match_all("!\"(http://images.amazon.com/[^\"]+".$search_attributes_r['amazonasin']."[^\"]+)\"!", $this->_pageBuffer, $regs))
		{
			$imageurl = NULL;
			$timageurl = NULL;
			
			// try for a big image first, otherwise get the smaller one.			
			for($i = 0; $i < count($regs[1]); $i++)
			{
				if(strpos($regs[1][$i], "LZZZZZZ") !== FALSE)
				{
					$imageurl = $regs[1][$i];
					break;
				}
				
				if(strpos($regs[1][$i], "ZZZZZZZ") !== FALSE)
				{
					$timageurl = $regs[1][$i];
				}
			}
			
			if($imageurl == NULL && timageurl != NULL)
				$imageurl = $timageurl;
						
			// If still null!
			if($imageurl == NULL)
			{
				// If first image has 'THUM' in it, we have matched a thumbnail,
				// get the next one instead.
				// 'Breath Fire III' (GAME) is such a case.
				if(count($regs[1])>1 && strpos($regs[1][0],"THUM")!==FALSE)
					$imageurl = $regs[1][1];
				else
					$imageurl = $regs[1][0];
			}
			
			if(strlen($imageurl))
			{
				$this->addItemAttribute('imageurl', $imageurl);
			}
		}
	
		if(preg_match("/<span class=listprice>\\\$([^<]*)<\/span>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		else if(preg_match("/<td class=\"listprice\">\\\$([^<]*)<\/td>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		else if(preg_match("/<b>List Price:<\/b>[^\\$]+\\$([0-9\.]+)/m", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}

		// amazon price value		
		if(preg_match("/<td><b class=\"price\">\\\$([^<]*)<\/b>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('price', $regs[1]);
		}
		
		// Get the mapped AMAZON index type
		$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
				
		switch($index_type)
		{
			case 'dvd':
			case 'vhs':
				$this->parse_amazon_video_data($search_attributes_r, $s_item_type);
				break;
			
			case 'videogames':
				$this->parse_amazon_game_data($search_attributes_r);
				break;
				
			case 'books':
				$this->parse_amazon_books_data($search_attributes_r);
				break;
				
			case 'music':
				$this->parse_amazon_music_data($search_attributes_r);
				break;
			
			default://Not much here, but what else can we do?
				break;
		}
	
		return TRUE;
	}
	
	/**
		Will return an array of the following structure.
			array(
				"gamepblshr"=>game publisher,
				"gamesystem"=>game platform,
				"gamerating"=>esrb rating
				"features"=>features listing for game,
			);
	*/
	function parse_amazon_game_data($search_attributes_r)
	{
		// Publisher extraction block
		if (preg_match("/Other products by <a.*>(.*)<\/a><br>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('gamepblshr', $regs[1]);
		}
	
		// Platform extraction block
		if (preg_match("/<b>Platform:[\s]*<\/b>(.+?)<br>/si", $this->_pageBuffer, $regs))
		{
			if(preg_match(":&nbsp;[\s](.*):", $regs[1], $regs2))
			{
				// Different combo's of windows, lets treat them all as windows.
				if(strpos($regs2[1], "Windows")!==FALSE)
					$platform = "Windows";
				else
					$platform = trim($regs2[1]);
					
				$this->addItemAttribute('gamesystem', $platform);
			}			
			else
			{
				$this->addItemAttribute('gamesystem', $regs[1]);
			}
		}
	
		// Rating extraction block
		if (preg_match("/<b>ESRB Rating:[\s]*<\/b>(.+?)<br>/si", $this->_pageBuffer, $regs))
		{
			if(preg_match(":videogames/ratings/esrb-(.*).gif:", $regs[1], $regs2))
				$this->addItemAttribute('gamerating', $regs2[1]);
			else
				$this->addItemAttribute('gamerating', strtoupper($regs[1]));
		}
	
		// Features extraction block
		if(preg_match("/<b>Features:<\/b>[\s]<ul>(.+?)<\/ul>/si", $this->_pageBuffer, $featureblock))
		{
			if(preg_match_all("/<li.*?>(.*?)<\/li>/si", $featureblock[1], $matches))
			{
				$features = "";
				// generate a list of features
				for($i = 0; $i < count($matches[1]); $i++)
				{
					$features .= strip_tags($matches[1][$i])."\n";
				}
				
				if(strlen($features)>0)
				{
					$this->addItemAttribute('features', $features);
				}
			}
		}
	}
	
	/*
	* 	Parse Amazon.com CD item
	* 
	* 	Will return
	* 	Array(
	* 		'artist'=>'',
	* 		'release_dt'=>'',
	* 		'year'=>'',
	* 		'musiclabel'=>'',
	* 		'no_discs'=>'',
	* 		'cdtrack'=>Array(...)
	* 	);
	*/
	function parse_amazon_music_data($search_attributes_r)
	{
		//<meta name="description" content="Dangerous [Remastered], Michael Jackson">
		//<meta name="keywords" content="Dangerous [Remastered], Music, Michael Jackson">
		
		//<meta name="description" content="Up!, Shania Twain">
		//<meta name="keywords" content="Up!, Music, Shania Twain, Country, Pop">
		
		//<meta name="description" content="Essential Mozart: 32 Of His Greatest Masterpieces, Wolfgang Amadeus Mozart, Neville Marriner, Uri Segal, Gyorgy Fischer, Stephen Cleobury, David Hill, Christopher Hogwood, Georg Solti, Willi Boskovsky, Herbert von Karajan, Christoph von Dohnanyi, Myung-Whun Chung, Jack Brymer, Peter Maag, George Guest, Radu Lupu, Cecilia Bartoli, Fritz Dolezal, Werner Hink, Hubert Kroisamer, Peter Schmidl, James Vivian, Emma Kirkby, Lisa Beznosiuk, Frances Kelly, Renee Fleming, Barry Tuckwell, Bryn Terfel, Vladimir Ashkenazy, Andras Schiff, Sumi Jo, Franklin Cohen, Hermann Prey, Kiri Te Kanawa, Joshua Bell, Margaret Marshall, Leontyne Price">
		//<meta name="keywords" content="Essential Mozart: 32 Of His Greatest Masterpieces, Music, Wolfgang Amadeus Mozart, Neville Marriner, Uri Segal, Gyorgy Fischer, Stephen Cleobury, David Hill, Christopher Hogwood, Georg Solti, Willi Boskovsky, Herbert von Karajan, Christoph von Dohnanyi, Myung-Whun Chung, Jack Brymer, Peter Maag, George Guest, Radu Lupu, Cecilia Bartoli, Fritz Dolezal, Werner Hink, Hubert Kroisamer, Peter Schmidl, James Vivian, Emma Kirkby, Lisa Beznosiuk, Frances Kelly, Renee Fleming, Barry Tuckwell, Bryn Terfel, Vladimir Ashkenazy, Andras Schiff, Sumi Jo, Franklin Cohen, Hermann Prey, Kiri Te Kanawa, Joshua Bell, Margaret Marshall, Leontyne Price">
		
		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $this->_pageBuffer, $regs))
		{
			$contents = explode(",", $regs[1]);
			if(is_not_empty_array($contents))
			{
				// the artist is the last entry in the description.
				$this->addItemAttribute('artist', trim($contents[count($contents)-1]));
			}
		}
		
		if( ($sqidx = strpos($this->getItemAttribute('title'), "["))!==FALSE)
		{
			$this->addItemAttribute('comments', str_replaces(array('[',']'), array("\n",''), substr($this->getItemAttribute('title'),$sqidx)));
			$this->replaceItemAttribute('title', substr($this->getItemAttribute('title'),0,$sqidx));
		}
		
		if(preg_match("!<b>Audio CD</b>.*\(([^\)]+)\)<br>!sU", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('release_dt', $regs[1]);
			if(preg_match("!([0-9]+)$!", $this->getItemAttribute('release_dt'), $regs2))
			{
				$this->addItemAttribute('year', $regs2[1]);
			}
		}
		
		if(preg_match("!<b>Label:</b>([^<]+)<li>!", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('musiclabel', $regs[1]);
		}
		
		if(preg_match("!<b>Number of Discs: </b>([0-9]+)!", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('no_discs', $regs[1]);
		}
		
		function parse_music_tracks($pageBuffer, $title, $disc_no)
		{
			$tracks = NULL;
			
			//<b class="h1">Listen to Samples</b><br />
			if(preg_match("!<b class=\"h1\">".preg_quote($title, "!")."</b>(.*)<hr noshade size=1>!Usi", $pageBuffer, $regs))
			{
				// Only parse for the disc number if disc_no specified
				if(!is_numeric($disc_no) || preg_match("!<b>Disc: $disc_no</b>(.*)</table>!Usi", $regs[1], $regs2))
				{
					if(preg_match_all("!<span class=tiny>[\s]*[0-9]+\.[\s]+(.*)</span>!Usi", is_numeric($disc_no)?$regs2[1]:$regs[1], $matches))
					{
						for ($i = 0; $i < count($matches[1]); $i++)
						{
							if(preg_match("!<a href=[^>]*>([^<]*)<img!i", $matches[1][$i], $regs3)) 
								$track = $regs3[1];
							else
								$track = $matches[1][$i];
	
							if(strlen($track)>0)
							{						
								$track = convert_html_numeric_codes(strip_tags($track));
								$track = trim(strtr($track, array_flip(get_html_translation_table(HTML_ENTITIES, ENT_QUOTES))));
								
								$tracks[] = $track;
							}
						}
					}
				}
			}
			return $tracks;
		}//function parse_music_tracks($pageBuffer, $title, $disc_no)
	
		if(is_numeric($this->getItemAttribute('no_discs')) && $this->getItemAttribute('no_discs') > 1)
		{
			for($i=0; $i<$this->getItemAttribute('no_discs'); $i++)
			{
				$cdtracks[$i] = parse_music_tracks($this->_pageBuffer, "Track Listings", $i+1);
				if($cdtracks[$i] == NULL)
					$cdtracks[$i] = parse_music_tracks($this->_pageBuffer, "Listen to Samples", $i+1);
			}
			
			// Now coalesce into single cdtracks array
			if(is_not_empty_array($cdtracks))
			{
				for($i=0; $i<count($cdtracks); $i++)
				{
					if(is_not_empty_array($cdtracks[$i]))
					{
						for($j=0; $j<count($cdtracks[$i]); $j++)
						{
							$this->addItemAttribute('cdtrack', $cdtracks[$i][$j]);
						}
					}
				}
			}
		}
		else
		{ 
			// one disc
			$this->addItemAttribute('cdtrack', parse_music_tracks($this->_pageBuffer, "Track Listings", NULL));
			if($this->getItemAttribute('cdtrack') === FALSE)
				$this->addItemAttribute('cdtrack', parse_music_tracks($this->_pageBuffer, "Listen to Samples", NULL));
		}			
	}
	
	/**
		Will return an array of the following structure.
			array(
				"author"=>author,
				"publisher"=>publisher,
				"pub_date"=>date published,
				"isbn"=>ISBN number,
				"listprice"=>Regular price,
			);
	
		If nothing parsed correctly, then this function will returned
		unitialised array.
	*/
	function parse_amazon_books_data($search_attributes_r)
	{
		// Author extraction
		//<meta name="description" content="Amazon.com: Books: Managing and Using MySQL (2nd Edition) by George Reese,Randy Jay Yarger,Tim King" />
		// Author extraction
		if (preg_match('!<meta name="description" content="Amazon.com: Books: .* by ([^"]*)"!siU', $this->_pageBuffer, $regs))
		{
			$authors = explode(",", trim($regs[1]));
			if(is_array($authors) && count($authors)>0)
			{
				$author = '';
				for($i=0; $i<count($authors); $i++)
				{
					if(strlen($author)>0)
						$author .= ', ';
					
					$author .= $authors[$i];
				}
				
				$this->addItemAttribute('author', initcap($author));
			}
			else
			{
				$this->addItemAttribute('author', initcap($regs[1]));
			}
		}
	
		//<b>Publisher:</b> Overlook Press; Reissue edition (November 1997)
		$startIndex = strpos($this->_pageBuffer, '<b class="h1">Product Details</b><br />');
		if($startIndex !== FALSE)
		{
			$startIndex += strlen('<b class="h1">Product Details</b><br />');
			
			$endIndex = strpos($this->_pageBuffer, '</ul>', $startIndex);
			if($endIndex !== FALSE)
			{
				$productDetails = unhtmlentities(trim(substr($this->_pageBuffer, $startIndex, $endIndex-$startIndex)));
				if(preg_match("!<li><b>ISBN:</b>([^<]*)</li>!mU", $productDetails, $regs2))
				{
					$this->addItemAttribute('isbn', $regs2[1]);
				}
				
				if(preg_match("/([0-9]+) pages/", $productDetails, $regs2))
				{
					$this->addItemAttribute('nb_pages', $regs2[1]);
				}
 				
				if(preg_match("!<li><b>Publisher:</b>[\s]*([^<]*)</li>!m", $productDetails, $regs2))
				{
					if(preg_match("/([^\(]+)\(([^\)]+)\)/", $regs2[1], $regs2))
					{
						// All we want is the year here.
						if (preg_match("/([0-9]+)$/", $regs2[2], $regs3))
						{
							$this->addItemAttribute('pub_date', $regs3[1]);
						}
						
						if(preg_match("/([^;]+);([^$]+)$/", $regs2[1], $regs3))
						{
							$this->addItemAttribute('publisher', $regs3[1]);
							$this->addItemAttribute('edition', $regs3[2]);
						}
						else
						{
							$this->addItemAttribute('publisher', $regs2[1]);
						}
					}
					else
					{
						$this->addItemAttribute('publisher', $regs2[1]);
					}
				}
			}
		}
		
		// Editorial reviews
		if(preg_match("!<a href=\"http://www.amazon.com/gp/product/product-description/".$search_attributes_r['amazonasin']."/!", $this->_pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI("http://www.amazon.com/gp/product/product-description/".$search_attributes_r['amazonasin']."/");
			if(strlen($reviewPage)>0)
			{
				$start = strpos($reviewPage, "<b class=\"h1\">Editorial Reviews</b>");
				if($start !== FALSE)
				{
					$start = strpos($reviewPage, "<div class=\"content\">", $start);
					if($start !== FALSE)
					{
						$end = strpos($reviewPage, "</div>", $start);
						if($end !== FALSE)
							$reviewPage = substr($reviewPage,$start,$end-$start);
						else
							$reviewPage = substr($reviewPage,$start);
							
						// If still something to parse.
						if(strlen($reviewPage)>0)
						{
							//<b>The Times of London</b><br />
							if(preg_match_all("!<b>(.*?)</b><br />(.*?)<br />!um", $reviewPage, $matches))
							{
								for($i=0; $i<count($matches[0]); $i++)
								{
									// The author, is the first match, the actual review the second one.
									$author = trim(unhtmlentities(strip_tags($matches[1][$i])));
									
									if($author != 'About the Author') // a hack!
									{
										// trim copyright notice.
										if(($copyidx = strpos($matches[2][$i], "-- <I>Copyright"))!==FALSE)
										{
											$matches[2][$i] = trim(substr($matches[2][$i],0,$copyidx));
										}
									
										$review = $matches[2][$i];
										
										// some specific fucked up review formatting to deal with!!!
										$review = preg_replace("/<p>/i", "\n\n", $review);
										$review = preg_replace("/<br>/i", "\n", $review);
										$review = str_replace("&#149;", "*", $review);
										$review = str_replace("&ndash;", "-", $review);
										
										$review = trim(unhtmlentities(convert_html_numeric_codes(strip_tags($review))));
										
										// some extra processing to try and remove as many duplicate reviews as possible
										$review = str_replace("\"", "", $review);
										$review = preg_replace("/[ \t]+/i", " ", $review);
										$review = str_replace("\n ", "\n", $review);
											
										if(strlen($author)>0 && 
												$author != 'Amazon.com' && 
												$author != 'Book Info' && 
												$author != 'Product Description:')
										{
											$review .= "\n-- $author";
										}
										
										$this->addItemAttribute('blurb', $review);
									}				 
								}
							}
						}
					}
				}
			}
		}
	}
	
	/**
		Will return an array of the following structure.
			array(
				"year"=>year,
				"age_rating"=>age_rating,
				"dvd_region"=>dvd_region, // not applicable for VHS,DIVX,etc
				"ratio"=>ration,
				"audio_lang"=>spoken languages,
				"subtitles"=>subtitles,
				"run_time"=>runtime,
				"director"=>director,
				"actors"=>actors,
			);
	
		If nothing parsed correctly, then this function will returned
		unitialised array.
	*/
	function parse_amazon_video_data($search_attributes_r, $s_item_type)
	{
		//Amazon.com: DVD: First Blood (Special Edition) (1982)
		// Need to escape any (, ), [, ], :, ., 
		if (preg_match("/".preg_quote($this->getItemAttribute('title'), "/")." \(([0-9]*)\)/s", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
	
		//	<li><b>Rated:</b> <img src="http://g-images.amazon.com/images/G/01/detail/pg-13.gif" width=35 height=11 width=35 height=11 alt="PG-13 \">
		// Rating extraction block
		if (preg_match("/<b>Rated:[\s]*<\/b>(.*)$/mi", $this->_pageBuffer, $regs))
		{
			if(preg_match("/<img src=.* alt=\"(.*)\">/", $regs[1], $regs2))
			{
				$age_rating = trim($regs2[1]);
	
				// A very strange problem with an age rating of 'PG-13 \"'
				$indexOfSpace = strpos($age_rating," ");
				if($indexOfSpace!==FALSE)
					$age_rating = substr($age_rating,0,$indexOfSpace);
					
				$this->addItemAttribute('age_rating', $age_rating);
			}
			else
			{
				$this->addItemAttribute('age_rating', $regs[1]);
			}
		}
	
		// Actor extraction block
		if (preg_match("/Starring<\/a>:(.*)/i", $this->_pageBuffer, $regs))
		{
			$actors = "";
			if(preg_match_all("/<a href=([^>]+)>([^<]+)<\/a>/", $regs[1], $matches))
			{
				for($i=0; $i<count($matches[1]); $i++)
				{
					if(strpos($matches[2][$i], "See more")===FALSE)
					{
						if(strlen($actors)>0)
							$actors .= ", ";
						$actors .= trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches[2][$i]))));
					}
					else
					{
						// should we get complete cast list here
						$actorPage = $this->fetchURI("http://www.amazon.com" . $matches[1][$i]);
						
						$startIndex = strpos($actorPage, "<b class=h1>Cast List</b>");
						if($startIndex!==FALSE)
						{
							$endIndex = strpos($actorPage, "<hr noshade size=1>", $startIndex);
							if($endIndex!==FALSE)
								$actorsPage = substr($actorPage, $startIndex, $endIndex-$startIndex);
							else
								$actorsPage = substr($actorPage, $startIndex);
							
							//<B><a href="/exec/obidos/search-handle-url/104-2722824-8728757?index=dvd&field-keywords= Joe Farago "> Joe Farago </a></B>
							//<i>... TV Anchorman </i>
							//<br>
							// now lets parse the actors
							if(preg_match_all("/<B><a href=\"[^\"]+\">([^<]+)<\/a><\/B>[^<]*<i>([^<]+)<\/i>/mi", $actorsPage, $matches))
							{
								// reset at this point.
								$actors = "";
								
								for($i=0; $i<count($matches[1]); $i++)
								{
									if(strlen($actors)>0)
										$actors .= ", ";
									$actors .= trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches[1][$i]))));
								}
							}						
						}
					}
				}
			}
			
			if(strlen($actors)>0)
			{
				$this->addItemAttribute('actors', $actors);
			}
		}
		
		// Director extraction block
		if (preg_match("/Director:.*<a.*>(.*)<\/a>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('director', $regs[1]);
		}
		
		if (preg_match("/<b>Studio:<\/b>(.*)/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}
		
		// Region extraction block
		if (preg_match("/Region ([0-6])/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('dvd_region', $regs[1]);
		}
		
		$startIndex = strpos($this->_pageBuffer, "<a name=\"amzn-reviews\"><b class=h1>Editorial Reviews</b><br></a>");
		if($startIndex!==FALSE)
		{
			if(preg_match("/<a name=\"[^\"]+\">.*<span class=\"serif\">(.*)<\/span>/Ui", substr($this->_pageBuffer, $startIndex+64), $regs))
			{
				$this->addItemAttribute('blurb', unhtmlentities(convert_html_numeric_codes(strip_tags($regs[1]))));
			}			
		}
		
		//<li><b>Aspect Ratio(s):</b> 1.85:1<br>
		// Ratio
		if(preg_match("!<b>Aspect Ratio\(s\):</b>(.*)!", $this->_pageBuffer, $regs))
		{
			if(preg_match_all("/([0-9]{1}\.[0-9]+):1/", $regs[1], $matches))
			{
				$this->addItemAttribute('ratio', $matches[1]);
			}
		}
				
		// Edition details block - 'dvd_extras' attribute
		if(preg_match("/<b>DVD Features:<\/b>[\s]<ul>(.+?)<\/ul>/si", $this->_pageBuffer, $regs))
		{
			// Get the anamorphic format attribute - Thanks to Andr Monz <amonz@users.sourceforge.net
			if(preg_match("/anamorphic/",$regs[1]))
			{
				$this->addItemAttribute('anamorphic', 'Y');
	    	}
			
			if(preg_match("/Number of discs: ([0-9]*)/",$regs[1], $regs2))
			{
				$this->addItemAttribute('no_discs', $regs2[1]);
	    	}
			
			if(preg_match_all("/<li>([^$]+)$/mUi",str_replace("<br>", "\n", $regs[1]), $matches))
			{
				$dvd_extras = "";
				
				while(list(,$item) = @each($matches[1]))
				{
					$item = unhtmlentities(convert_html_numeric_codes(strip_tags($item)));
					
					// We may have a hard space here, so get rid of it.
					$item = trim(strtr($item, chr(160), ' '));
					
					// Don't include the region, no_discs, anamorphic, subtitles, audio tracks, etc
					if(strpos($item, "Region")===FALSE && 
								strpos($item, "Number of discs")===FALSE && 
								strpos($item, "Widescreen anamorphic format")===FALSE &&
								strpos($item, "Available subtitles")===FALSE &&
								strpos($item, "Available Audio Tracks")===FALSE)
					{
						$dvd_extras .= $item."\n";
					}
				}
				
				if(strlen($dvd_extras)>0)
				{
					$this->addItemAttribute('dvd_extras', $dvd_extras);
				}
			}
		}
	
		// IMDB ID block
		if(preg_match(":<a href=\"http\://amazon.imdb.com/Title/ASIN=".$search_attributes_r['amazonasin']."\?([^\"]+)\">:is", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('imdb_id', $regs[1]);
		}
		
		// All Amazon.com (US) items should be NTSC!
		$this->addItemAttribute('vid_format', 'NTSC');
	
		//<span class=small><b><a href=/exec/obidos/tg/detail/-/630469654X/002-9030252-1305647?v=glance&s=dvd&vi=tech-info>Click here for more technical details about this edition...</a></b></span><br>
		// If possible, fetch additional (technical) info from the site
		if(preg_match("/<a href=([^>]+)>Click here for more technical details/i", $this->_pageBuffer, $regs))
		{
			$detailPage = $this->fetchURI("http://www.amazon.com" . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($detailPage)>0)
			{
				//Production Company: Artisan Entertainment<BR>
				if (preg_match("/Production Company:([^<]*)<br>/i", $detailPage, $regs))
				{
					$this->addItemAttribute('studio', $regs[1]);
				}
				
				//DVD Release Date: January 1, 2001
				if(preg_match("/DVD Release Date: ([^<]+)<br>/i", $detailPage, $regs))
				{
					// Get year only, for now.  In the future we may add ability to
					// convert date to local date format.
					if(preg_match("/([0-9]+)$/m", $regs[1], $regs2))
					{
						$this->addItemAttribute('dvd_rel_dt', $regs2[1]);
						
						// if year not defined, use dvd_rel_dt
						if($this->getItemAttribute('year') === FALSE)
						{
							$this->addItemAttribute('year', $regs2[1]);
						}
					}
				}
			
				// Duration extraction block
				if (preg_match("/Run Time: ([0-9]+)/i", $detailPage, $regs))
				{
					$this->addItemAttribute('run_time', $regs[1]);
				}
				
				// Ratio
				if(preg_match(":Aspect Ratio(.*)<p>:i", $detailPage, $regs))
				{
					if(preg_match_all("/([0-9]{1}\.[0-9]+):1/", $regs[1], $matches))
					{
						$this->addItemAttribute('ratio', $matches[1]);
					}
				}
				
				// Spoken languages
				if(preg_match("/Available Audio Tracks:([^<]*)<br>/i", $detailPage, $regs))
				{
					$audio_lang_r = explode(",", $regs[1]);
					
					// this is a bit of a hack I hope to make configurable some time soon.
					$amazon_video_audio_lang_map = array(
								"ENGLISH_2.0"=>array("English", "2.0"), 
								"ENGLISH_5.0"=>array("English", "5.0"), 
								"ENGLISH_5.1"=>array("English", "5.1"), 
								"ENGLISH_6.1_EX"=>array("English", "6.1", "EX"), // Dolby Digital 6.1 EX
								"ENGLISH_6.1_DTS_ES"=>array("English", "6.1", "DTS", "ES"), // English (6.1 DTS ES)
								"ENGLISH_6.1"=>array("English", "6.1"),
								"ENGLISH_DTS"=>array("English", "DTS"),
								"FRENCH"=>array("French"), 
								"SPANISH"=>array("Spanish"), 
								"GERMAN"=>array("German"));
					
					// Now we can process each separate language value.
					while(list(,$audio_lang) = @each($audio_lang_r))
					{
						reset($amazon_video_audio_lang_map);
						// We have to find all elements of the 
						while(list($key,$find_r) = each(@$amazon_video_audio_lang_map))
						{
							$found = TRUE;
							while(list(,$srch) = each($find_r))
							{
								if (strpos($audio_lang, $srch) === FALSE)
								{
									$found=FALSE;
									break;
								}	
							}
							
							// All $srch values were found - no need to continue as
							// we only want one match for each language item...
							if($found)
							{
								$this->addItemAttribute('audio_lang', strtoupper($key));
								
								break;
							}
						}
					}
				}
				
				if (preg_match("/THX Certified/i", $detailPage))
				{
					$this->addItemAttribute('audio_lang', 'ENGLISH_THX');
				}
				
				// Subtitles
				if (preg_match("/Available subtitles([^<]*)<br>/i", $detailPage, $regs))
				{
					// this is a bit of a hack I hope to make configurable some time soon.
					$amazon_video_subtitle_map = array("English", "French", "Spanish", "German");
					while(list(,$subtitle) = @each($amazon_video_subtitle_map))
					{
						if (strpos($regs[1], $subtitle)!==FALSE)
						{
							$this->addItemAttribute('subtitles', strtoupper($subtitle));
						}
					}
				}
			}
	
			// Don't need it anymore
			unset($detailPage);
		}
		
		// Attempt to include data from IMDB if available - but only for DVD, VHS, etc
		// as IMDB does not work with BOOKS or CD's.
		if(is_numeric($this->getItemAttribute('imdb_id')))
		{
			$sitePlugin =& get_site_plugin_instance('imdb');
			if($sitePlugin !== FALSE)
			{
				if($sitePlugin->queryItem(array('imdb_id'=>$this->getItemAttribute('imdb_id')), $s_item_type))
				{
					// no mapping process is performed here, as no $s_item_type was provided.
					$itemData = $sitePlugin->getItemData();
					if(is_array($itemData))
	      			{
						// merge data in here.
						while(list($key,$value) = each($itemData))
						{
							if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'director')
								$this->replaceItemAttribute('director', $value);
							else if($key == 'year')
								$this->replaceItemAttribute('year', $value);
							else if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'genre')
								$this->replaceItemAttribute('genre', $value);
							else if($key == 'plot') //have to map from imdb to amazon attribute type.
								$this->addItemAttribute('blurb', $value);
							else if($key != 'age_rating' && $key != 'run_time')
								$this->addItemAttribute($key, $value);
						}
					}
				}
			}
		}
	}
}
?>