###################################################################
# Support for Books
###################################################################
#

#
# Cleanup first.
#
DELETE FROM s_item_type WHERE s_item_type = 'BOOK';
DELETE FROM s_item_attribute_type WHERE s_item_type = 'BOOK';
DELETE FROM s_attribute_type WHERE s_attribute_type IN('AUTHOR', 'BOOKGENRE', 'PUBLISHER', 'PUB_DATE', 'ISBN', 'COVERPRICE', 'NB_PAGES');
DELETE FROM s_attribute_type_lookup WHERE s_attribute_type = 'BOOKGENRE';

#
# Item type
#
INSERT INTO s_item_type (s_item_type, description, image, order_no) VALUES ( 'BOOK', 'Book', 'book.gif', '10');

#
# New s_attribute_types required
# The COMMENTS & IMAGEURL s_attribute_type's already exists.
#
# Special input types of 'date' and 'money' will be added later, for now these will suffice.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AUTHOR', 'Book Author', 'Author', 'text(30,*)', 'list(plain, ",", list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'BOOKGENRE', 'Book Genre', 'Genre', 'checkbox_grid(%display%, 4)', 'category(%display%, list-link)', 'CATEGORY', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'PUBLISHER', 'Publisher', 'Publisher', 'text(30,*)', 'display(%value%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'PUB_DATE', 'Date Published', 'Published', 'datetime(YYYY)',  'datetime(YYYY)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'ISBN', 'Book ISBN', 'ISBN', 'filtered(13,13,0-9\\-X)',  'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'COVERPRICE', 'Cover Price', 'Price', 'filtered(6,6,0-9.)',  'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'NB_PAGES', 'Number of Pages', 'No. of Pages', 'filtered(4,4,0-9)', 'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'SYNOPSIS', 'Synopsis', 'Synopsis', 'textarea(50,5)', 'display(%value%)', NULL, NULL);


#
# s_item_attribute_type relationships
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'SYNOPSIS', '8', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'AUTHOR', '10', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'BOOKGENRE', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'ISBN', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'PUBLISHER', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'PUB_DATE', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'NB_PAGES', '55', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'COVERPRICE', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'COMMENTS', '70', 'Comment', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'S_STATCMNT', '255', NULL, NULL);

#
# s_attribute_type_lookup values
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Fantasy', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Sci-Fi', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Fiction', NULL, NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Non-Fiction', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Horror', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Reference', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Christian', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Poetry', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'History', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Mystery', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Science', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Art', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Romance', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Sports', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Biography', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Autobiography', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Jokes', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Riddles', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Thriller', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'BOOKGENRE', NULL, 'Children', NULL, NULL,NULL);
