<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once('./functions/phpthumb/phpthumb.class.php');
include_once('./functions/fileutils.php');
include_once('./functions/utils.php');

/**
* If extension provided use that instead of reparsing the filename.
*/
function is_thumbable_image_file($file, $extension = NULL)
{
	global $CONFIG_VARS;
	
	if($extension==NULL)
	{
		$file_r = parse_file($file);
		$extension = $file_r['extension'];
	}
	
	if(in_array(strtolower($extension), $CONFIG_VARS['thumbnail.supported_input_formats']))
		return TRUE;
	else
		return FALSE;
}

/*
* 
*/
function get_thumbnail_filename($file_r)
{
	global $CONFIG_VARS;
	
	if(!is_array($file_r))
	{
		$file = $file_r;
		$file_r = NULL;
		$file_r = parse_file($file);
	}
	
	return str_replace('{filename}', $file_r['name'], $CONFIG_VARS['thumbnail.item_files_thumbnail_mask']);
}

/**
* Assumes the $file has already been written
*/
function generate_thumbnail($save_dir, $file, &$errors)
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;

	if(is_dir($save_dir))
	{
		// remove last slash.
		if(substr($save_dir,-1) == '/')
			$save_dir = substr($save_dir,0,-1);
			
		if(is_file($save_dir.'/'.$file))
		{
			$file_r = parse_file($file);
					
			// only support these image types.
			if(is_thumbable_image_file(NULL, $file_r['extension']))
			{
				$thumbimgname = get_thumbnail_filename($file_r);
				
				$phpThumb = new phpThumb();
				$phpThumb->config_error_die_on_error = false;
		
				// configure the size of the thumbnail.
				if(is_array($CONFIG_VARS['thumbnail.item_image_size']))
				{
					if(is_numeric($CONFIG_VARS['thumbnail.item_image_size']['width']))
						$phpThumb->w = $CONFIG_VARS['thumbnail.item_image_size']['width'];
					else if(is_numeric($CONFIG_VARS['thumbnail.item_image_size']['height']))
						$phpThumb->h = $CONFIG_VARS['thumbnail.item_image_size']['height'];
				}
				else
				{
					$phpThumb->h = 100;
				}
				
				if(strlen($CONFIG_VARS['thumbnail.output_format'])>0)
				{
					if($CONFIG_VARS['thumbnail.output_format'] != 'jpg')
						$phpThumb->config_output_format = $CONFIG_VARS['thumbnail.output_format'];
					else
						$phpThumb->config_output_format = 'jpeg'; // 'jpg might be configured by mistake so support it.
				}
				else
				{
					// default
					$phpThumb->config_output_format = 'jpeg';
				}
				
				$phpThumb->setSourceFilename($save_dir.'/'.$file);
					
				// generate & output thumbnail
				if ($phpThumb->GenerateThumbnail() && $phpThumb->RenderToFile($save_dir.'/'.$thumbimgname)) 
				{
					opendb_log("Image thumbnail generated. (directory=".$save_dir.", file=".$file.", thumbnail=".$thumbimgname.", update_who=".$HTTP_SESSION_VARS['user_id'].")");
					
					return TRUE;
				}
				else
				{
					// do something with debug/error messages
					if(is_not_empty_array($phpThumb->debugmessages))
						$errors = $phpThumb->debugmessages;
					else if(strlen($phpThumb->debugmessages)>0) // single array element
						$errors[] = $phpThumb->debugmessages;
					
					opendb_log("Image thumbnail not generated. (directory=".$save_dir.", file=".$file.", thumbnail=".$thumbimgname.") [".implode(";",$errors)."]");
						
					return FALSE;
				}
			}
			else
			{
				opendb_log("File not supported for thumbnail generation (file=".$file.")");
				return FALSE;
			}
		}//if(is_file($save_dir.'/'.$file))
		else
		{
			opendb_log("Image not found (file=".$file.")");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Invalid item files directory specified. (directory=".$save_dir.")");
		return FALSE;
	}
}
?>