/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.parse;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.input.CommentTrimmer;
import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Location;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedElementAnnotation;
import com.thaiopensource.relaxng.parse.ParsedNameClass;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParser;
import com.thaiopensource.util.Localizer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SchemaBuilderImpl
implements SchemaBuilder {
    private final SubParser subParser;
    private final ErrorHandler eh;
    private final Map<String, SchemaDocument> schemas;
    private final DatatypeLibraryFactory dlf;
    private final boolean commentsNeedTrimming;
    private boolean hadError = false;
    private static final Localizer localizer = new Localizer(SchemaBuilderImpl.class);

    private SchemaBuilderImpl(SubParser subParser, ErrorHandler errorHandler, Map<String, SchemaDocument> map, DatatypeLibraryFactory datatypeLibraryFactory, boolean bl) {
        this.subParser = subParser;
        this.eh = errorHandler;
        this.schemas = map;
        this.dlf = datatypeLibraryFactory;
        this.commentsNeedTrimming = bl;
    }

    @Override
    public ParsedPattern makeChoice(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.makeComposite(new ChoicePattern(), parsedPatternArray, n, location, annotations);
    }

    private static ParsedPattern makeComposite(CompositePattern compositePattern, ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws BuildException {
        List<Pattern> list = compositePattern.getChildren();
        for (int i = 0; i < n; ++i) {
            list.add((Pattern)parsedPatternArray[i]);
        }
        return SchemaBuilderImpl.finishPattern(compositePattern, location, annotations);
    }

    @Override
    public ParsedPattern makeGroup(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.makeComposite(new GroupPattern(), parsedPatternArray, n, location, annotations);
    }

    @Override
    public ParsedPattern makeInterleave(ParsedPattern[] parsedPatternArray, int n, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.makeComposite(new InterleavePattern(), parsedPatternArray, n, location, annotations);
    }

    @Override
    public ParsedPattern makeOneOrMore(ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new OneOrMorePattern((Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeZeroOrMore(ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new ZeroOrMorePattern((Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeOptional(ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new OptionalPattern((Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeList(ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new ListPattern((Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeMixed(ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new MixedPattern((Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeEmpty(Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishPattern(new EmptyPattern(), location, annotations);
    }

    @Override
    public ParsedPattern makeNotAllowed(Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishPattern(new NotAllowedPattern(), location, annotations);
    }

    @Override
    public ParsedPattern makeText(Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishPattern(new TextPattern(), location, annotations);
    }

    @Override
    public ParsedPattern makeAttribute(ParsedNameClass parsedNameClass, ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new AttributePattern((NameClass)parsedNameClass, (Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeElement(ParsedNameClass parsedNameClass, ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new ElementPattern((NameClass)parsedNameClass, (Pattern)parsedPattern), location, annotations);
    }

    @Override
    public ParsedPattern makeValue(String string, String string2, String string3, Context context, String string4, Location location, Annotations annotations) throws BuildException {
        ValuePattern valuePattern = new ValuePattern(string, string2, string3);
        DatatypeLibrary datatypeLibrary = this.dlf.createDatatypeLibrary(string);
        if (datatypeLibrary != null) {
            try {
                DatatypeBuilder datatypeBuilder = datatypeLibrary.createDatatypeBuilder(string2);
                try {
                    Datatype datatype = datatypeBuilder.createDatatype();
                    try {
                        TraceValidationContext traceValidationContext;
                        TraceValidationContext traceValidationContext2 = traceValidationContext = datatype.isContextDependent() ? new TraceValidationContext(valuePattern.getPrefixMap(), context, string4) : null;
                        if (datatype.createValue(string3, traceValidationContext) == null) {
                            datatype.checkValid(string3, traceValidationContext);
                        }
                    }
                    catch (DatatypeException datatypeException) {
                        this.diagnoseDatatypeException("invalid_value_detail", "invalid_value", datatypeException, location);
                    }
                }
                catch (DatatypeException datatypeException) {
                    this.diagnoseDatatypeException("invalid_params_detail", "invalid_params", datatypeException, location);
                }
            }
            catch (DatatypeException datatypeException) {
                this.diagnoseDatatypeException("unsupported_datatype_detail", "unknown_datatype", datatypeException, location);
            }
        }
        return SchemaBuilderImpl.finishPattern(valuePattern, location, annotations);
    }

    @Override
    public ParsedPattern makeExternalRef(String string, String string2, Scope scope, Location location, Annotations annotations) throws BuildException, IllegalSchemaException {
        ExternalRefPattern externalRefPattern = new ExternalRefPattern(string);
        externalRefPattern.setNs(SchemaBuilderImpl.mapInheritNs(string2));
        SchemaBuilderImpl.finishPattern(externalRefPattern, location, annotations);
        if (this.schemas.get(string) == null) {
            this.schemas.put(string, new SchemaDocument(null));
            this.schemas.put(string, new SchemaDocument((Pattern)this.subParser.parseExternal(string, this, scope)));
        }
        return externalRefPattern;
    }

    private static ParsedPattern finishPattern(Pattern pattern, Location location, Annotations annotations) {
        SchemaBuilderImpl.finishAnnotated(pattern, location, annotations);
        return pattern;
    }

    @Override
    public ParsedNameClass makeChoice(ParsedNameClass[] parsedNameClassArray, int n, Location location, Annotations annotations) {
        ChoiceNameClass choiceNameClass = new ChoiceNameClass();
        List<NameClass> list = choiceNameClass.getChildren();
        for (int i = 0; i < n; ++i) {
            list.add((NameClass)parsedNameClassArray[i]);
        }
        return SchemaBuilderImpl.finishNameClass(choiceNameClass, location, annotations);
    }

    @Override
    public ParsedNameClass makeName(String string, String string2, String string3, Location location, Annotations annotations) {
        NameNameClass nameNameClass = new NameNameClass(SchemaBuilderImpl.mapInheritNs(string), string2);
        nameNameClass.setPrefix(string3);
        return SchemaBuilderImpl.finishNameClass(nameNameClass, location, annotations);
    }

    @Override
    public ParsedNameClass makeNsName(String string, Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishNameClass(new NsNameNameClass(SchemaBuilderImpl.mapInheritNs(string)), location, annotations);
    }

    @Override
    public ParsedNameClass makeNsName(String string, ParsedNameClass parsedNameClass, Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishNameClass(new NsNameNameClass(SchemaBuilderImpl.mapInheritNs(string), (NameClass)parsedNameClass), location, annotations);
    }

    @Override
    public ParsedNameClass makeAnyName(Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishNameClass(new AnyNameNameClass(), location, annotations);
    }

    @Override
    public ParsedNameClass makeAnyName(ParsedNameClass parsedNameClass, Location location, Annotations annotations) {
        return SchemaBuilderImpl.finishNameClass(new AnyNameNameClass((NameClass)parsedNameClass), location, annotations);
    }

    @Override
    public Grammar makeGrammar(Scope scope) {
        GrammarPattern grammarPattern = new GrammarPattern();
        return new GrammarSectionImpl(grammarPattern, grammarPattern);
    }

    private static ParsedNameClass finishNameClass(NameClass nameClass, Location location, Annotations annotations) {
        SchemaBuilderImpl.finishAnnotated(nameClass, location, annotations);
        return nameClass;
    }

    private static void finishAnnotated(Annotated annotated, Location location, Annotations annotations) {
        annotated.setSourceLocation((SourceLocation)location);
        if (annotations != null) {
            ((AnnotationsImpl)annotations).apply(annotated);
        }
    }

    @Override
    public ParsedNameClass annotate(ParsedNameClass parsedNameClass, Annotations annotations) throws BuildException {
        if (annotations != null) {
            ((AnnotationsImpl)annotations).apply((Annotated)((Object)parsedNameClass));
        }
        return parsedNameClass;
    }

    @Override
    public ParsedPattern annotate(ParsedPattern parsedPattern, Annotations annotations) throws BuildException {
        if (annotations != null) {
            ((AnnotationsImpl)annotations).apply((Annotated)((Object)parsedPattern));
        }
        return parsedPattern;
    }

    @Override
    public ParsedPattern annotateAfter(ParsedPattern parsedPattern, ParsedElementAnnotation parsedElementAnnotation) throws BuildException {
        SchemaBuilderImpl.addAfterAnnotation((Pattern)parsedPattern, parsedElementAnnotation);
        return parsedPattern;
    }

    @Override
    public ParsedNameClass annotateAfter(ParsedNameClass parsedNameClass, ParsedElementAnnotation parsedElementAnnotation) throws BuildException {
        SchemaBuilderImpl.addAfterAnnotation((NameClass)parsedNameClass, parsedElementAnnotation);
        return parsedNameClass;
    }

    private static void addAfterAnnotation(Annotated annotated, ParsedElementAnnotation parsedElementAnnotation) {
        ((ElementAnnotationBuilderImpl)parsedElementAnnotation).addTo(annotated.getFollowingElementAnnotations());
    }

    @Override
    public ParsedPattern commentAfter(ParsedPattern parsedPattern, CommentList commentList) throws BuildException {
        SchemaBuilderImpl.addAfterComment((Pattern)parsedPattern, commentList);
        return parsedPattern;
    }

    @Override
    public ParsedNameClass commentAfter(ParsedNameClass parsedNameClass, CommentList commentList) throws BuildException {
        SchemaBuilderImpl.addAfterComment((NameClass)parsedNameClass, commentList);
        return parsedNameClass;
    }

    private static void addAfterComment(Annotated annotated, CommentList commentList) {
        if (commentList != null) {
            annotated.getFollowingElementAnnotations().addAll(((CommentListImpl)commentList).list);
        }
    }

    @Override
    public Location makeLocation(String string, int n, int n2) {
        return new SourceLocation(string, n, n2);
    }

    @Override
    public CommentList makeCommentList() {
        if (this.commentsNeedTrimming) {
            return new TrimmingCommentListImpl();
        }
        return new CommentListImpl();
    }

    @Override
    public DataPatternBuilder makeDataPatternBuilder(String string, String string2, Location location) throws BuildException {
        DataPattern dataPattern = new DataPattern(string, string2);
        dataPattern.setSourceLocation((SourceLocation)location);
        return new DataPatternBuilderImpl(dataPattern);
    }

    @Override
    public ParsedPattern makeErrorPattern() {
        return null;
    }

    @Override
    public ParsedNameClass makeErrorNameClass() {
        return null;
    }

    @Override
    public Annotations makeAnnotations(CommentList commentList, Context context) {
        return new AnnotationsImpl(commentList, context);
    }

    @Override
    public ElementAnnotationBuilder makeElementAnnotationBuilder(String string, String string2, String string3, Location location, CommentList commentList, Context context) {
        ElementAnnotation elementAnnotation = new ElementAnnotation(string, string2);
        elementAnnotation.setPrefix(string3);
        elementAnnotation.setSourceLocation((SourceLocation)location);
        elementAnnotation.setContext(context.copy());
        return new ElementAnnotationBuilderImpl(commentList, elementAnnotation);
    }

    @Override
    public boolean usesComments() {
        return true;
    }

    private static Combine mapCombine(GrammarSection.Combine combine) {
        if (combine == null) {
            return null;
        }
        return combine == GrammarSection.COMBINE_CHOICE ? Combine.CHOICE : Combine.INTERLEAVE;
    }

    private static String mapInheritNs(String string) {
        return string;
    }

    private void parse(Parseable parseable, String string) throws IllegalSchemaException {
        this.schemas.put(string, new SchemaDocument((Pattern)parseable.parse(this, new ScopeImpl())));
    }

    static SchemaCollection parse(Parseable parseable, String string, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, boolean bl) throws IllegalSchemaException, IOException, SAXException {
        try {
            SchemaCollection schemaCollection = new SchemaCollection();
            SchemaBuilderImpl schemaBuilderImpl = new SchemaBuilderImpl(parseable, errorHandler, schemaCollection.getSchemaDocumentMap(), datatypeLibraryFactory, bl);
            schemaCollection.setMainUri(string);
            schemaBuilderImpl.parse(parseable, string);
            if (schemaBuilderImpl.hadError) {
                throw new IllegalSchemaException();
            }
            return schemaCollection;
        }
        catch (BuildException buildException) {
            Throwable throwable = buildException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            if (throwable instanceof Exception) {
                throw new SAXException((Exception)throwable);
            }
            throw new SAXException(throwable.getClass().getName() + " thrown");
        }
    }

    private void error(SAXParseException sAXParseException) throws BuildException {
        this.hadError = true;
        try {
            if (this.eh != null) {
                this.eh.error(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            throw new BuildException(sAXException);
        }
    }

    private void diagnoseDatatypeException(String string, String string2, DatatypeException datatypeException, Location location) throws BuildException {
        String string3 = datatypeException.getMessage();
        if (string3 != null) {
            this.error(string, string3, (SourceLocation)location);
        } else {
            this.error(string2, (SourceLocation)location);
        }
    }

    private static Locator makeLocator(final SourceLocation sourceLocation) {
        return new Locator(){

            public String getPublicId() {
                return null;
            }

            public int getColumnNumber() {
                if (sourceLocation == null) {
                    return -1;
                }
                return sourceLocation.getColumnNumber();
            }

            public String getSystemId() {
                if (sourceLocation == null) {
                    return null;
                }
                return sourceLocation.getUri();
            }

            public int getLineNumber() {
                if (sourceLocation == null) {
                    return -1;
                }
                return sourceLocation.getLineNumber();
            }
        };
    }

    private void error(String string, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private void error(String string, String string2, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string, string2), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private void error(String string, String string2, String string3, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string, string2, string3), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private void error(String string, String string2, String string3, String string4, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string, new Object[]{string2, string3, string4}), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementAnnotationBuilderImpl
    implements ElementAnnotationBuilder,
    ParsedElementAnnotation {
        private final ElementAnnotation element;
        private CommentList comments;

        ElementAnnotationBuilderImpl(CommentList commentList, ElementAnnotation elementAnnotation) {
            this.comments = commentList;
            this.element = elementAnnotation;
        }

        @Override
        public void addText(String string, Location location, CommentList commentList) throws BuildException {
            TextAnnotation textAnnotation = new TextAnnotation(string);
            textAnnotation.setSourceLocation((SourceLocation)location);
            if (commentList != null) {
                this.element.getChildren().addAll(((CommentListImpl)commentList).list);
            }
            this.element.getChildren().add(textAnnotation);
        }

        @Override
        public void addAttribute(String string, String string2, String string3, String string4, Location location) throws BuildException {
            AttributeAnnotation attributeAnnotation = new AttributeAnnotation(string, string2, string4);
            attributeAnnotation.setPrefix(string3);
            attributeAnnotation.setSourceLocation((SourceLocation)location);
            this.element.getAttributes().add(attributeAnnotation);
        }

        @Override
        public ParsedElementAnnotation makeElementAnnotation() throws BuildException {
            return this;
        }

        @Override
        public void addElement(ParsedElementAnnotation parsedElementAnnotation) throws BuildException {
            ((ElementAnnotationBuilderImpl)parsedElementAnnotation).addTo(this.element.getChildren());
        }

        @Override
        public void addComment(CommentList commentList) throws BuildException {
            if (commentList != null) {
                this.element.getChildren().addAll(((CommentListImpl)commentList).list);
            }
        }

        @Override
        public void addLeadingComment(CommentList commentList) throws BuildException {
            if (this.comments == null) {
                this.comments = commentList;
            } else if (commentList != null) {
                ((CommentListImpl)this.comments).add((CommentListImpl)commentList);
            }
        }

        void addTo(List<AnnotationChild> list) {
            if (this.comments != null) {
                list.addAll(((CommentListImpl)this.comments).list);
            }
            list.add(this.element);
        }
    }

    private static class AnnotationsImpl
    implements Annotations {
        private CommentList comments;
        private final List<AttributeAnnotation> attributes = new Vector<AttributeAnnotation>();
        private final List<AnnotationChild> elements = new Vector<AnnotationChild>();
        private final Context context;

        AnnotationsImpl(CommentList commentList, Context context) {
            this.comments = commentList;
            this.context = context;
        }

        public void addAttribute(String string, String string2, String string3, String string4, Location location) throws BuildException {
            AttributeAnnotation attributeAnnotation = new AttributeAnnotation(string, string2, string4);
            attributeAnnotation.setPrefix(string3);
            attributeAnnotation.setSourceLocation((SourceLocation)location);
            this.attributes.add(attributeAnnotation);
        }

        public void addElement(ParsedElementAnnotation parsedElementAnnotation) throws BuildException {
            ((ElementAnnotationBuilderImpl)parsedElementAnnotation).addTo(this.elements);
        }

        public void addComment(CommentList commentList) throws BuildException {
            if (commentList != null) {
                this.elements.addAll(((CommentListImpl)commentList).list);
            }
        }

        public void addLeadingComment(CommentList commentList) throws BuildException {
            if (this.comments == null) {
                this.comments = commentList;
            } else if (commentList != null) {
                ((CommentListImpl)this.comments).add((CommentListImpl)commentList);
            }
        }

        void apply(Annotated annotated) {
            annotated.setContext(this.context.copy());
            if (this.comments != null) {
                annotated.getLeadingComments().addAll(((CommentListImpl)this.comments).list);
            }
            annotated.getAttributeAnnotations().addAll(this.attributes);
            List<AnnotationChild> list = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
            list.addAll(this.elements);
        }
    }

    private class DataPatternBuilderImpl
    implements DataPatternBuilder {
        private final DataPattern p;
        private DatatypeBuilder dtb = null;

        DataPatternBuilderImpl(DataPattern dataPattern) throws BuildException {
            this.p = dataPattern;
            DatatypeLibrary datatypeLibrary = SchemaBuilderImpl.this.dlf.createDatatypeLibrary(dataPattern.getDatatypeLibrary());
            if (datatypeLibrary != null) {
                try {
                    this.dtb = datatypeLibrary.createDatatypeBuilder(dataPattern.getType());
                }
                catch (DatatypeException datatypeException) {
                    String string = dataPattern.getDatatypeLibrary();
                    String string2 = dataPattern.getType();
                    SourceLocation sourceLocation = dataPattern.getSourceLocation();
                    String string3 = datatypeException.getMessage();
                    if (string3 != null) {
                        SchemaBuilderImpl.this.error("unsupported_datatype_detail", string, string2, string3, sourceLocation);
                    }
                    SchemaBuilderImpl.this.error("unknown_datatype", string, string2, sourceLocation);
                }
            }
        }

        public void addParam(String string, String string2, Context context, String string3, Location location, Annotations annotations) throws BuildException {
            Param param = new Param(string, string2);
            param.setContext(context.copy());
            SchemaBuilderImpl.finishAnnotated(param, location, annotations);
            this.p.getParams().add(param);
            if (this.dtb != null) {
                try {
                    this.dtb.addParameter(string, string2, context);
                }
                catch (DatatypeException datatypeException) {
                    SchemaBuilderImpl.this.diagnoseDatatypeException("invalid_param_detail", "invalid_param", datatypeException, location);
                }
            }
        }

        public void annotation(ParsedElementAnnotation parsedElementAnnotation) {
            List<Param> list = this.p.getParams();
            ((ElementAnnotationBuilderImpl)parsedElementAnnotation).addTo(list.isEmpty() ? this.p.getChildElementAnnotations() : list.get(list.size() - 1).getFollowingElementAnnotations());
        }

        public ParsedPattern makePattern(Location location, Annotations annotations) throws BuildException {
            if (this.dtb != null) {
                try {
                    this.dtb.createDatatype();
                }
                catch (DatatypeException datatypeException) {
                    SchemaBuilderImpl.this.diagnoseDatatypeException("invalid_params_detail", "invalid_params", datatypeException, location);
                }
            }
            return SchemaBuilderImpl.finishPattern(this.p, location, annotations);
        }

        public ParsedPattern makePattern(ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
            this.p.setExcept((Pattern)parsedPattern);
            return SchemaBuilderImpl.finishPattern(this.p, location, annotations);
        }
    }

    static class TrimmingCommentListImpl
    extends CommentListImpl {
        TrimmingCommentListImpl() {
        }

        public void addComment(String string, Location location) throws BuildException {
            super.addComment(CommentTrimmer.trimComment(string), location);
        }
    }

    static class CommentListImpl
    implements CommentList {
        private final List<Comment> list = new Vector<Comment>();

        CommentListImpl() {
        }

        public void addComment(String string, Location location) throws BuildException {
            Comment comment = new Comment(string);
            comment.setSourceLocation((SourceLocation)location);
            this.list.add(comment);
        }

        void add(CommentListImpl commentListImpl) {
            this.list.addAll(commentListImpl.list);
        }
    }

    private class GrammarSectionImpl
    extends ScopeImpl
    implements Grammar,
    Div,
    Include,
    IncludedGrammar {
        private final Annotated subject;
        private final List<Component> components;
        Component lastComponent;

        private GrammarSectionImpl(Annotated annotated, Container container) {
            this.subject = annotated;
            this.components = container.getComponents();
        }

        public void define(String string, GrammarSection.Combine combine, ParsedPattern parsedPattern, Location location, Annotations annotations) throws BuildException {
            if (string == GrammarSection.START) {
                string = DefineComponent.START;
            }
            DefineComponent defineComponent = new DefineComponent(string, (Pattern)parsedPattern);
            if (combine != null) {
                defineComponent.setCombine(SchemaBuilderImpl.mapCombine(combine));
            }
            SchemaBuilderImpl.finishAnnotated(defineComponent, location, annotations);
            this.add(defineComponent);
        }

        public Div makeDiv() {
            DivComponent divComponent = new DivComponent();
            this.add(divComponent);
            return new GrammarSectionImpl(divComponent, divComponent);
        }

        public Include makeInclude() {
            IncludeComponent includeComponent = new IncludeComponent();
            this.add(includeComponent);
            return new GrammarSectionImpl(includeComponent, includeComponent);
        }

        public void topLevelAnnotation(ParsedElementAnnotation parsedElementAnnotation) throws BuildException {
            if (this.lastComponent == null) {
                ((ElementAnnotationBuilderImpl)parsedElementAnnotation).addTo(this.subject.getChildElementAnnotations());
            } else {
                SchemaBuilderImpl.addAfterAnnotation(this.lastComponent, parsedElementAnnotation);
            }
        }

        public void topLevelComment(CommentList commentList) throws BuildException {
            if (commentList != null) {
                if (this.lastComponent == null) {
                    this.subject.getChildElementAnnotations().addAll(((CommentListImpl)commentList).list);
                } else {
                    SchemaBuilderImpl.addAfterComment(this.lastComponent, commentList);
                }
            }
        }

        private void add(Component component) {
            this.components.add(component);
            this.lastComponent = component;
        }

        public void endDiv(Location location, Annotations annotations) throws BuildException {
            SchemaBuilderImpl.finishAnnotated(this.subject, location, annotations);
        }

        public void endInclude(String string, String string2, Location location, Annotations annotations) throws BuildException, IllegalSchemaException {
            IncludeComponent includeComponent = (IncludeComponent)this.subject;
            includeComponent.setHref(string);
            includeComponent.setNs(SchemaBuilderImpl.mapInheritNs(string2));
            SchemaBuilderImpl.finishAnnotated(includeComponent, location, annotations);
            if (SchemaBuilderImpl.this.schemas.get(string) == null) {
                SchemaBuilderImpl.this.schemas.put(string, new SchemaDocument(null));
                GrammarPattern grammarPattern = new GrammarPattern();
                try {
                    ParsedPattern parsedPattern = SchemaBuilderImpl.this.subParser.parseInclude(string, SchemaBuilderImpl.this, new GrammarSectionImpl(grammarPattern, grammarPattern));
                    SchemaBuilderImpl.this.schemas.put(string, new SchemaDocument((Pattern)parsedPattern));
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    SchemaBuilderImpl.this.schemas.remove(string);
                    SchemaBuilderImpl.this.hadError = true;
                    throw illegalSchemaException;
                }
            }
        }

        public ParsedPattern endGrammar(Location location, Annotations annotations) throws BuildException {
            SchemaBuilderImpl.finishAnnotated(this.subject, location, annotations);
            return (ParsedPattern)((Object)this.subject);
        }

        public ParsedPattern endIncludedGrammar(Location location, Annotations annotations) throws BuildException {
            SchemaBuilderImpl.finishAnnotated(this.subject, location, annotations);
            return (ParsedPattern)((Object)this.subject);
        }
    }

    private static class ScopeImpl
    implements Scope {
        private ScopeImpl() {
        }

        public ParsedPattern makeRef(String string, Location location, Annotations annotations) throws BuildException {
            return SchemaBuilderImpl.finishPattern(new RefPattern(string), location, annotations);
        }

        public ParsedPattern makeParentRef(String string, Location location, Annotations annotations) throws BuildException {
            return SchemaBuilderImpl.finishPattern(new ParentRefPattern(string), location, annotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraceValidationContext
    implements ValidationContext {
        private final Map<String, String> map;
        private final ValidationContext vc;
        private final String ns;

        TraceValidationContext(Map<String, String> map, ValidationContext validationContext, String string) {
            this.map = map;
            this.vc = validationContext;
            this.ns = string.length() == 0 ? null : string;
        }

        @Override
        public String resolveNamespacePrefix(String string) {
            String string2;
            if (string.length() == 0) {
                string2 = this.ns;
            } else {
                string2 = this.vc.resolveNamespacePrefix(string);
                if (string2 == SchemaBuilder.INHERIT_NS) {
                    return null;
                }
            }
            if (string2 != null) {
                this.map.put(string, string2);
            }
            return string2;
        }

        @Override
        public String getBaseUri() {
            return this.vc.getBaseUri();
        }

        @Override
        public boolean isUnparsedEntity(String string) {
            return this.vc.isUnparsedEntity(string);
        }

        @Override
        public boolean isNotation(String string) {
            return this.vc.isNotation(string);
        }
    }
}

