# amxd.tcl --
#
#       The main amxd server code.  Sets up the TclDP RPC server and provides
#       basic abstractions to provide access to the AMX box.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source ../../lib/tcl/dp-lib.tcl
source amx-lib.tcl
source callback-lib.tcl
# to disable spoofing, comment out the next line
source spoofamx-lib.tcl
# the following files are for specific 405 devices
source lights-lib.tcl
source matrix-lib.tcl
source camera-lib.tcl
source vcr-lib.tcl
source scanconv-lib.tcl
source onair-lib.tcl

# global variables
global g_port g_serverHandle g_daemonVersion

proc initUI {} {
    wm title . "Amx Daemon"
    wm minsize . 200 0

    frame .but
    pack .but -side top -pady 10

    # make exit button
    button .exit -text "Exit" -command "amxd_killServer"
    pack .exit -side bottom
}

proc amxd_killServer {} {
    global g_serverHandle

    dp_CloseRPC $g_serverHandle

    close-AMX-control

    # this after is needed to give time for any app remotely invoking
    # amxd_killServer to close the connection
    after 500 { exit }
}

proc processAmxMsg {} {
#    puts stdout "got an event from the AMX!"
    set amxMsg [receive-AMX-command]
    if {[llength $amxMsg] != 0} {
#	puts stdout "processAmxMsg received $amxMsg"

	set cmd [lindex $amxMsg 0]
	set cmdStr [amx_commandLookup $cmd]
	set dev [lindex $amxMsg 1]
	set devStr [amx_deviceLookup $dev]
	set chanStr [lindex $amxMsg 2]
	if {$cmd != 4 && $cmd != 5} {
	    set chanStr [amx_channelLookup $devStr $chanStr]
	}
	
	set eventInfo [list "amxResponse"]
	set eventData [list "$cmdStr" "$devStr" "$chanStr"]
	set amxMsg [list $eventInfo $eventData]

	puts stdout "processAmxMsg, doing callbacks with: $amxMsg"
	callback_doCallbacks $amxMsg
    }
}

proc amxd_getVersion {} {
    global g_daemonVersion
    
    return $g_daemonVersion
}

#
# FIXME - nothing prevents the user from calling raw_send-AMX-command...
#
# We need some kind of authentication scheme, don't worry about it...
#
# We would like to prevent users from calling raw_send-AMX-command,
#   close-AMX-control, receive-AMX-command, etc.
# Perhaps the RPC lib can support this through the checking functions that
#   can be registered
#
# FIXME -This is useful for logging commands sent to the AMX, we could
#    have amx_sendAmxCommand which is the new interface, and we could log
#    events by redirecting legacy code's send-AMX-command to use that
#
proc installWrappers {} {
    rename send-AMX-command raw_send-AMX-command
    proc send-AMX-command { cmd device {chan_str ""} } {
	# you can add any protections that the server wants to enforce here

	# sometimes this line will cause an error, if the chan_str string
	#   contains a 5 (not ascii '5'), as in the spoof library
#	puts stdout "received send-AMX-command $cmd $device $chan_str"
	raw_send-AMX-command "$cmd" "$device" "$chan_str"

	# FIXME - we should probably modify the other libraries to create their
	#   own callbacks and create new message types, instead of using the
	#   raw send-amx-command info
	# notify other processes that care of this command
	set eventInfo [list "amxCommand"]
	set cmdName [amx_commandLookup $cmd]
	set devName [amx_deviceLookup $device]
	if {$cmd != 4 && $cmd != 5} {
	    set chan_str [amx_channelLookup $devName $chan_str]
	}
	set eventData [list "$cmdName" "$devName" "$chan_str"]
	set amxMsg [list $eventInfo $eventData]
	puts stdout "send-amx-command, doing callbacks with: $amxMsg"
	callback_doCallbacks $amxMsg
    }

    # this prevents others from calling setup-AMX-control, since we've already
    #   called it ourselves, it's fine to remove the command
    rename setup-AMX-control ""
    rename amx_setCallback ""
}


#
#
# Driver engine
#
#

# this is the version of amxd
set g_daemonVersion 1.0

# 6901 is the port assumed by all other code
set g_port 6901
set g_serverHandle [dp_MakeRPCServer $g_port]

setup-AMX-control

puts stdout "amxserver running"

# set up the function to be called when the AMX box sends something to amxd
amx_setCallback "processAmxMsg"

installWrappers

# FIXME - this is just temporary to help testing
# FIXME - make this determine if we are using wish or tclsh and call if needed
#initUI

vwait forever

