# vcc3-zoom.tcl --
#
#       Code for handling Zoom notifications and responses for vcc3d.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc vcc3_processZoomNotification {pktList} {
    array set pkt $pktList

#    puts stdout "vcc3_processZoomNotification: called"
#    vcc3_printPacket $pktList

 #     set type [expr $pkt(commandID) & 0x1F]
#      if {$type == 0x18} {
#  	puts stdout "vcc3_processPanTilterNotification: remote control"
#  	set operation $pkt(parameter,0)
#  	set code $pkt(parameter,1)
#  	puts stdout "\toperation = $operation"
#  	puts stdout "\tcode = $code"
#  	vcc3_pt_handleRemoteButton $operation $code
#      }
}

proc vcc3_processZoomPositiveResponse {pktList} {
    global g_sync
    
    array set pkt $pktList

    set type [expr $pkt(commandID) & 0x1F]
    if {$type == 0x4} {
  	# status response
  	vcc3_zoom_handleStatusResponse $pktList
    }
    if {$type == 0x12} {
	# zoom response
	vcc3_zoom_handleZoomResponse $pktList
    }
    if {$type == 0x10} {
	# focus response
	vcc3_zoom_handleFocusResponse $pktList
    }
}

proc vcc3_zoom_handleStatusResponse {pktList} {
    global g_sync g_zoomSpeed g_zoomPosition
    global g_focusSpeed g_focusPosition
    global g_aeRef g_exposureSpeed g_iris g_shutterSpeed g_gain
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x1} {
  	# focus
	set g_focusSpeed $pkt(parameter,1)
	set g_focusSpeed [expr $g_focusSpeed & 0x7]
  	set focusHi $pkt(parameter,2)
  	set focusLo $pkt(parameter,3)
  	set focusHi [expr $focusHi << 8]
  	set g_focusPosition [expr $focusHi + $focusLo]
  	set g_sync(readFocusStatus) "NO_WAIT"
    }
    if {$type == 0x2} {
  	# zoom
	set g_zoomSpeed $pkt(parameter,1)
	set g_zoomSpeed [expr $g_zoomSpeed & 0x7]
  	set zoomHi $pkt(parameter,2)
  	set zoomLo $pkt(parameter,3)
  	set zoomHi [expr $zoomHi << 8]
  	set g_zoomPosition [expr $zoomHi + $zoomLo]
  	set g_sync(readZoomStatus) "NO_WAIT"
    }
    if {$type == 0x3} {
  	# exposure
	set g_exposureSpeed $pkt(parameter,1)
	set g_aeRef $pkt(parameter,2)
	set g_iris $pkt(parameter,3)
	set g_shutterSpeed $pkt(parameter,4)
	set g_gain $pkt(parameter,5)
  	set g_sync(readExposureStatus) "NO_WAIT"
    }
}

proc vcc3_zoom_handleFocusResponse {pktList} {
    global g_sync
    global g_zoomSpeed g_zoomPosition g_maxZoom g_focusSpeed
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x5} {
 	# focus speed
  	if {$pkt(parameter,1) == 0x1} {
  	    # speed read
	    set g_focusSpeed $pkt(parameter,2)
  	    set g_sync(readFocusSpeed) "NO_WAIT"
  	}
    }
}

proc vcc3_zoom_handleZoomResponse {pktList} {
    global g_sync
    global g_zoomSpeed g_zoomPosition g_maxZoom
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x2} {
 	# zoom position
  	if {$pkt(parameter,1) == 0x3} {
  	    # scope read
	    set zoomHi $pkt(parameter,2)
	    set zoomLo $pkt(parameter,3)
	    set zoomHi [expr $zoomHi << 8]
	    set g_maxZoom [expr $zoomHi + $zoomLo]
  	    set g_sync(readMaxZoom) "NO_WAIT"
  	}
	if {$pkt(parameter,1) == 0x2} {
	    # zoom move
	    set g_sync(zoomMove) "NO_WAIT"
	}
    }

#      if {$type == 0x3} {
#  	# pan/tilt speed
#  	if {$pkt(parameter,1) == 0x1} {
#  	    # read
#  	    set g_panSpeed $pkt(parameter,2)
#  	    set g_tiltSpeed $pkt(parameter,3)
#  	    set g_sync(readPanTiltSpeed) "NO_WAIT"
#  	}
#      }
    
#      if {$type == 0x4} {
#  	# relative pan/tilt position
#  	if {$pkt(parameter,1) == 0x2} {
#  	    set g_sync(relativeMove) "NO_WAIT"
#  	}
#  	if {$pkt(parameter,1) == 0x1} {
#  	    # read
#  	    set panHi $pkt(parameter,2)
#  	    set panLo $pkt(parameter,3)
#  	    set tiltHi $pkt(parameter,4)
#  	    set tiltLo $pkt(parameter,5)

#  	    set panHi [expr $panHi << 8]
#  	    set tiltHi [expr $tiltHi << 8]
#  	    set g_panPosition [expr $panHi + $panLo]
#  	    set g_tiltPosition [expr $tiltHi + $tiltLo]
#  	    set g_panPosition [expr 0x8000 - $g_panPosition]
#  	    set g_tiltPosition [expr $g_tiltPosition - 0x8000]
	    
#  	    puts stdout "relative: panHi=$panHi, panLo=$panLo"
#  	    puts stdout "relative: tiltHi=$tiltHi, tiltLo=$tiltLo"
#  	    puts stdout "relative: g_panPos=$g_panPosition, g_tiltPosition=$g_tiltPosition"
#  	    set g_sync(readPanTiltPosition) "NO_WAIT"
#  	}
#      }
#      if {$type == 0x5} {
#  	# absolute pan/tilt position
#  	if {$pkt(parameter,1) == 0x2} {
#  	    set g_sync(absoluteMove) "NO_WAIT"
#  	}
#  	if {$pkt(parameter,1) == 0x1} {
#  	    # read
#  	    set panHi $pkt(parameter,2)
#  	    set panLo $pkt(parameter,3)
#  	    set tiltHi $pkt(parameter,4)
#  	    set tiltLo $pkt(parameter,5)

#  	    set panHi [expr $panHi << 8]
#  	    set tiltHi [expr $tiltHi << 8]
#  	    set g_panPosition [expr $panHi + $panLo]
#  	    set g_tiltPosition [expr $tiltHi + $tiltLo]
#  	    set g_panPosition [expr 0x8000 - $g_panPosition]
#  	    set g_tiltPosition [expr $g_tiltPosition - 0x8000]

#  	    set g_sync(readPanTiltPosition) "NO_WAIT"
#  	}
#      }
}
