/*
 * transmogrify.h --
 *
 *      RTP Edit header file
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_TRANSMOGRIFY
#define MASH_TRANSMOGRIFY


#include <tclcl.h>
#include "archive/archive-file.h"
#include "archive/rtp-archive.h"
#include "net/pktbuf.h"


class EditRTP : public TclObject {
public:
	EditRTP();
	~EditRTP() {}
	int datafile(int argc, const char * const *argv);
	int indexfile(int argc, const char * const *argv);
	int outdata(int argc, const char * const *argv);
	int outindex(int argc, const char * const *argv);
	int go(int argc, const char * const *argv);
	int find_cut(int argc, const char * const *argv);
protected:
	DataFile *DataFile_ () { return dataFile_; }
	IndexFile *IndexFile_() { return indexFile_;}
	DataFile *OutDataFile_() { return outdataFile_; }
	IndexFile *OutIndexFile_() { return outindexFile_;}

	void DataFile_ (DataFile  *file) { dataFile_ = file; }
	void IndexFile_(IndexFile *file) { indexFile_= file; }
	void OutDataFile_ (DataFile  *file) { outdataFile_ = file; }
	void OutIndexFile_(IndexFile *file) { outindexFile_= file; }

	int diff(timeval sent, timeval recv, int margin);

	DataFile* dataFile_;
	IndexFile* indexFile_;
	DataFile* outdataFile_;
	IndexFile* outindexFile_;

	u_int32_t scale_;
	u_int32_t ref_rtp_;
	u_int32_t ref_tv_sec_;
	u_int32_t ref_tv_usec_;
	double ref_rec_;

	int adjust_;
	BufferPool* bufpool_;


	int times[100];
};




#endif
