/*
 * decoder.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef mash_decoder_h
#define mash_decoder_h

#include "tclcl.h"
#include "source.h"
#include "controller.h"

/*FIXME*/
#define PLAYO_FILTER 5
#define VAR_FILTER 5
#define VAR_MULT 2

class AudioDecoder : public PacketHandler {
    protected:
	AudioDecoder();
    public:
	virtual ~AudioDecoder();

	/* statistics */
	void info(char* wrk) const;
	virtual void stats(char* wrk);
	virtual int command(int argc, const char*const* argv);
    protected:
	void consume_samples(const rtphdr* rh, const u_int8_t* p, int cc);
	void count(int statno);
	void setstat(int statno, u_int v);
	int adapt(const rtphdr*, u_int32_t sclock);
	int active() const;
	inline u_int32_t playout() const { return (playout_ >> PLAYO_FILTER); }
/*FIXME*/
#define MAXSTAT 16
	struct statcntr {
		const char* name;
		u_int cnt;
	} stat_[MAXSTAT];
	int nstat_;

	Controller* controller_;

	/*
	 * Playback point estimation state.
	 */
	int32_t var_;		// variance in this host's interarrival time
	u_int32_t hostoffset_;	// timestamp offset this host's clock
	u_int32_t predicted_drop_;	// ts of last drop + blocksize
	u_int32_t playout_;	// playout delay (in media units)
	u_int32_t lastrecv_;	// local time (in media time) of last recv
	int lecture_mode_;	/*FIXME*/
	int framesize_;		/*FIXME*/
	int block_size_;
	int maxdel_;
};

class PCM_Decoder : public AudioDecoder {
    public:
	virtual void recv(pktbuf*);
};

inline int AudioDecoder::active() const
{
	return (controller_ && controller_->active());
}

/*
 * Decode steps:
 *	1. decode (to get blocksize)
 *	2. adapt (now that we have blocksize)
 *	3. mix (now that we have adapted)
 */
inline void AudioDecoder::consume_samples(const rtphdr* rh, const u_int8_t* p,
			             int cc)
{
	block_size_ = cc;
	int plout = adapt(rh, controller_->media_ts());
	if (plout >= 0)
		controller_->mix_from_net(plout, p, cc);
}

inline void AudioDecoder::count(int statno)
{
	++stat_[statno].cnt;
}

inline void AudioDecoder::setstat(int statno, u_int v)
{
	stat_[statno].cnt = v;
}

#endif
