/*
 * encoder-jpeg.h --
 *
 *      Motion Jpeg video encoder header file
 *
 * Copyright (c) 1994-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "Tcl.h"
#include "module.h"

#ifdef INT_64
#define NBIT 64
#define BB_INT INT_64
#else
#define NBIT 32
#define BB_INT u_int
#endif


class JpegEncoder : public EncoderModule {
	public:
		JpegEncoder();
		void setq(int q);
		void size(int w, int h);
		void recv(Buffer*);

		struct huffentry {
			u_short val;
			u_short nb;
		};

	protected:
		int command(int argc, const char*const* argv);

		virtual int flush(pktbuf* pb, int nbit, pktbuf* npb);
		virtual int encode(const VideoFrame*);
		void encode_blk(const short* blk, short* dcpred,
				struct JpegEncoder::huffentry* dcht,
				struct JpegEncoder::huffentry* acht);
		void encode_mcu(u_int mcu, const u_char* frm);
		void fdct(const u_char* in, int stride, short* out, const float* qt);

		/* bit buffer */
		BB_INT bb_;
		u_int nbb_;

		u_char* bs_;
		u_char* bc_;

		u_char quant_;
		float lqt_[64];
		float cqt_[64];

		short lpred_;	// dc predictors
		short crpred_;
		short cbpred_;

		u_int nmcu_;
		u_char w_;			/* divided by 8 */
		u_char h_;
};

