/*
 * runtool.c --
 *
 *      Code for generating toolname.exe (in win32) which calls:
 *          mash.exe -name argv[0] -- args
 *      since we get the toolname from argv[0], we can reuse this code for all
 *      tools.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static char *rcsid = "$Header: /usr/mash/src/repository/mash/mash-1/compat/runtool.c,v 1.9 2002/02/03 03:14:22 lim Exp $";
#endif

#ifndef WIN32
#error "this program is meant for win32 only"
#endif

#ifndef RUNTOOL_C
#define RUNTOOL_C
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <windows.h>
#include <errno.h>

#ifdef IS_SETUP
#define MASH_EXE_SUBDIR "bin\\"
#define SCRIPT_SUBDIR "lib\\"
#endif

int main(int argc, char** argv)
{
	const char*szMASHEXE="mash.exe";
	char mashpath[_MAX_FNAME];
	char mashpathQuoted[_MAX_FNAME];
	char **newargv=(char**)malloc(sizeof(char*)*(argc+5));
	char toolname[_MAX_FNAME];
	char toolpath[_MAX_FNAME];
	char tooldir[_MAX_DIR];
	char tooldrive[_MAX_DRIVE];
	char *name;
	int i, retcode, errnum;
	char *cmdLine;
	/* get basename */
	_splitpath(argv[0], NULL, toolpath, toolname, NULL);

	/* NOTE: we have to assume we use only one case for the toolname
	 *       since in win95 argv[0] becomes all UPPERCASE. For backward
	 *       compatibility, we use all lower case
	 */
	for (i=0; toolname[i]!='\0'; i++)
		toolname[i] = tolower(toolname[i]);

	/* FIXME: quick hack to make mega<toolname> work, basically
	   if the name of the executable is mega<name> then the "name"
	   of the program is <name> but the scriptname is still mega<name> */
	if (strncmp(toolname, "mega", 4)==0) {
		name=&toolname[4];
	} else {
		name=toolname;
	}

	/* get everything but the first argument */
	cmdLine = GetCommandLine();
	if (cmdLine) {
		/* if quoted go for the end of the quote, then go for
		 * the first space */
		if (cmdLine[0] == '\"') {
			cmdLine = strchr(cmdLine+1, '\"');
		}
		cmdLine = strchr(cmdLine, ' ');
	}
	if (cmdLine == NULL) {
		cmdLine = "";
	}

	/* We assume that mash.exe and the script are in the same directory
	 * as <toolname>.exe,
	 * (unless MASH_EXE_DIR or SCRIPT_SUBDIR is defined)
	 * so set current directory to that of
	 * <toolname>.exe so that mash.exe can find the script. */
	if (0==GetModuleFileName(NULL, toolpath, _MAX_FNAME)) {
		perror("GetModuleFileName failed!");
	}
	_splitpath(toolpath, tooldrive, tooldir, NULL, NULL);
	strcpy(toolpath, "\"");
	strcat(toolpath, tooldrive);
	strcat(toolpath, tooldir);
#ifdef SCRIPT_SUBDIR
	strcat(toolpath, SCRIPT_SUBDIR);
#endif
	strcat(toolpath, toolname);
	strcat(toolpath, "\"");

	strcpy(mashpath, tooldrive);
	strcat(mashpath, tooldir);
#ifdef MASH_EXE_SUBDIR
	strcat(mashpath, MASH_EXE_SUBDIR);
#endif
	strcat(mashpath, szMASHEXE);

	strcpy(mashpathQuoted, "\"");
	strcat(mashpathQuoted, mashpath);
	strcat(mashpathQuoted, "\"");

#if !defined(NDEBUG)
	printf("executing: %s {%s %s -name %s -- %s}\n", mashpath,
	       mashpathQuoted, toolpath, name, cmdLine);
#endif
	retcode=_execl(mashpath, mashpathQuoted, toolpath, "-name", name,
		       "--", cmdLine, NULL);
	/* should not arrive here */
	if (retcode==-1) {
		errnum = errno;
		if (errnum==ENOENT) {
			fprintf(stderr, "error: cannot find %s\n", mashpath);
		} else {
			fprintf(stderr, "error: %s\n", strerror(errnum));
		}
	}
	return retcode;
}

#endif /* #ifdef RUNTOOL_C */
