/*
 * mash-tkinit.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mash-tkinit.cc,v 1.29 2002/02/07 03:17:39 wesley Exp $
 */


#include <tclcl.h>
#include <tk.h>
#include "mash-init.h"


extern "C" {
/* override the platform init routine in the tk library */
int
#if (TK_MAJOR_VERSION < 8)
TkPlatformInit(Tcl_Interp *interp)
#else
TkpInit(Tcl_Interp *interp)
#endif
{
	Tcl_SetVar(interp, "tk_library", ".", TCL_GLOBAL_ONLY);

#ifdef WIN32
	extern void TkWinXInit(HINSTANCE hInstance);
	TkWinXInit(GetModuleHandle(NULL));
#else
	extern void TkCreateXEventSource(void);
	TkCreateXEventSource();
#endif
	return (TCL_OK);
}

#if (TK_MAJOR_VERSION == 8)
void
TkpGetAppName(Tcl_Interp* interp, Tcl_DString* namePtr)
{
    char *p, *name;

    name = Tcl_GetVar(interp, "argv0", TCL_GLOBAL_ONLY);
#ifdef WIN32
    int argc; char** argv;
    if (name != NULL) {
	Tcl_SplitPath(name, &argc, &argv);
	if (argc > 0) {
	    name = argv[argc-1];
	    p = strrchr(name, '.');
	    if (p != NULL) {
		*p = '\0';
	    }
	} else {
	    name = NULL;
	}
    }
#endif

    if ((name == NULL) || (*name == 0)) {
	name = "tk";
    }
#ifndef WIN32
    else {
	p = strrchr(name, '/');
	if (p != NULL) {
	    name = p+1;
	}
    }
#endif

    Tcl_DStringAppend(namePtr, name, -1);

#ifdef WIN32
    if (argv != NULL) {
	ckfree((char *)argv);
    }
#endif

}
void
TkpDisplayWarning(char* msg, char* title)
{
#ifdef WIN32
    MessageBox(NULL, msg, title, MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL
	    | MB_SETFOREGROUND | MB_TOPMOST);
#else
    Tcl_Channel errChannel = Tcl_GetStdChannel(TCL_STDERR);
    if (errChannel) {
	Tcl_Write(errChannel, title, -1);
	Tcl_Write(errChannel, ": ", 2);
	Tcl_Write(errChannel, msg, -1);
	Tcl_Write(errChannel, "\n", 1);
    }
#endif
}
#endif
}


extern int Tk_BargraphCmd();

#ifdef _MSC_VER
#   pragma warning (disable: 4305 4309)
#endif

#include "bitmaps/speaker.xbm"
#include "bitmaps/headphone.xbm"
#include "bitmaps/lineout.xbm"
#include "bitmaps/lineout2.xbm"
#include "bitmaps/lineout3.xbm"
#include "bitmaps/mic.xbm"
#include "bitmaps/linein.xbm"
#include "bitmaps/linein2.xbm"
#include "bitmaps/linein3.xbm"
#include "bitmaps/square.xbm"
#include "tcl/mb/bitmaps/MB-bitmaps.h"
#include "tcl/cues/bitmaps/cues-bitmaps.h"

#ifdef _MSC_VER
#   pragma warning (default: 4305 4309)
#endif

void
Mash_LoadBitmaps(Tcl_Interp* tcl)
{
	Tk_DefineBitmap(tcl, Tk_GetUid("speaker"),
			speaker_bits, speaker_width, speaker_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("headphone"),
			headphone_bits, headphone_width, headphone_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("lineout"),
			lineout_bits, lineout_width, lineout_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("lineout2"),
			lineout2_bits, lineout2_width, lineout2_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("lineout3"),
			lineout3_bits, lineout3_width, lineout3_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("mike"),
			mic_bits, mic_width, mic_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("linein"),
			linein_bits, linein_width, linein_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("linein2"),
			linein2_bits, linein2_width, linein2_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("linein3"),
			linein3_bits, linein3_width, linein3_height);
	Tk_DefineBitmap(tcl, Tk_GetUid("square"),
			square_bits, square_width, square_height);
        MB_LoadBitmaps(tcl);
	Cues_LoadBitmaps(tcl);
}


/*FIXME*/
extern "C" int Tk_StripchartCmd(ClientData, Tcl_Interp*, int ac, char** av);

int TkCanvPSHeaderCmd(ClientData, Tcl_Interp*, int ac, char** av);
int PostscriptPrologCmd(ClientData, Tcl_Interp*, int ac, char** av);

#include "mplug/otcl-mplug.h"


int
MPlug_Init(Tcl_Interp *interp)
{
	return MPlugClient::Init(interp);
}


int
Mash_TkInit(Tcl_Interp* interp)
{
	Tcl_SetVar2(interp, "mash", "environ", "mash", TCL_GLOBAL_ONLY);
	Tcl::instance().tkmain(Tk_MainWindow(interp));
	extern EmbeddedTcl et_tk;
	et_tk.load();
	Tcl::instance().CreateCommand("stripchart", Tk_StripchartCmd,
				      (ClientData)Tcl::instance().tkmain());

        Tcl::instance().CreateCommand("TkCanvPsHeader", TkCanvPSHeaderCmd);
        Tcl::instance().CreateCommand("postscript_prolog",PostscriptPrologCmd);

	Mash_LoadBitmaps(interp);

	if (MPlug_Init(interp)==TCL_ERROR) return TCL_ERROR;

	if (Mash_TkPlatformInit(interp)==TCL_ERROR) return TCL_ERROR;

	/*
	 * Initialize the miscellaneous Tk calls. This lets Tcl/Tk call
	 * C functions without having to instantiate the C classes as
	 * objects.
	 */
	init_tkmisc();

	/*
	 * Specify a user-specific startup file to invoke if the application
	 * is run interactively.  Typically the startup file is "~/.apprc"
	 * where "app" is the name of the application.  If this line is deleted
	 * then no user-specific startup file will be run under any conditions.
	 */

	Tcl_SetVar(interp, "tcl_rcFileName", "~/.mash-startup",
		   TCL_GLOBAL_ONLY);
	return TCL_OK;
}


int
Mash_Init(Tcl_Interp *interp)
{
	if (Otcl_Init(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Otcl_Init failed!");
		return TCL_ERROR;
	}

	if (Mash_TclInit(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Mash_TclInit failed!");
		return TCL_ERROR;
	}

	if (Mash_TkInit(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Mash_TkInit failed!");
		return TCL_ERROR;
	}

	return TCL_OK;
}


int
Mash_AppInit(Tcl_Interp *interp)
{
#if 0
	if (Tcl_Init(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Tcl_Init failed!");
		return TCL_ERROR;
	}
#endif
	Tcl_SetVar(interp, "tcl_library", "./lib/tcl8.3", TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "tk_library", "./lib/tk8.3", TCL_GLOBAL_ONLY);
	if (Tk_Init(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Tk_Init failed!");
		return TCL_ERROR;
	}

	if (Mash_Init(interp) == TCL_ERROR) {
		return TCL_ERROR;
	}

	return TCL_OK;
}

