/*
 * error.h --
 *
 *      Mechanisms for reporting errors etc.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /usr/mash/src/repository/mash/mash-1/mb/error.h,v 1.14 2002/02/03 03:16:30 lim Exp $
 */

#ifndef ERROR_H
#define ERROR_H

#include <tclcl.h>
#include <stdarg.h>

#ifndef MASH_ASSERT_H
#define MASH_ASSERT_H
#include <assert.h>
#endif

extern char szErrorMsg[];

#define ALL 0
#define NORM 1
#define VERBOSE 2
#define VERYVERBOSE 3
#define EXCESSIVE 4

#ifndef MB_DEBUG
#define TR_LEVEL 0
#else // #ifndef MB_DEBUG
#define TR_LEVEL VERBOSE    // all traces less than this will get printed
#endif  // #ifndef MB_DEBUG

/*
 *--------------------------------------------------------
 */

void disperr(const char* fmt, ...);
int dispTclErr(const char* msg);

#ifdef MB_DEBUG

#define perr(args)                                  \
     do {                                           \
         disperr("[%s:%d] ", __FILE__, __LINE__);   \
         disperr args;                              \
         disperr("\n");                             \
     } while (FALSE)

#define Trace(level,args)                            \
     do {                                            \
        if (level<=TR_LEVEL) {                       \
            disperr("[%s:%d] ", __FILE__, __LINE__); \
            disperr args;                            \
            disperr("\n");                           \
        }                                            \
     } while (FALSE)

// print out to stderr
#define Disp(args) \
        disperr args;

#define ED_EXIT 0
#define ED_CONT 1

#define SignalError(args) \
      perr(args)

/*--------------------------------------------------------*/
#else // !MB_DEBUG

#define Trace(level,str)

#define SignalError(args) \
        disperr args

#define perr(args) \
      disperr args;

#endif // !MB_DEBUG
/*--------------------------------------------------------*/

#endif /* #ifdef ERROR_H */
