/*
 * mb-page.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
q * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-page.h,v 1.18 2002/02/03 03:16:30 lim Exp $
 */

#ifndef __MB_PAGE_H__
#define __MB_PAGE_H__

#include "mb/mb-obj.h"
#include "mb/mb-canv.h"

class MBReceiver;
class MBManager;
class MBBaseCanvas;


////////////////////////
//
// The (Application) Page class
//
//   Note: we use seqno to id page items, but to have a globally unique
//         id, we have to use the source id to differentiate the seqno's.
//         the way we do it is to have each receiver manage a different
//         page object for the same page.
//         ==> the page has no notion of multiple receivers
//             it just manage the items on behalf of the source
//
//////////////////////////

class Page : public MBPageObject
{
public:
	Page(MBManager *pMgr, PageId id, const char *szCanvas);
	virtual ~Page();

	inline MBBaseCanvas* getCanvas() const { return pCanv_ ; }

	// remember the creation of a new id on the canvas
	void addCanvItem(MBCmd* pCmd, ulong itemId, const CanvItemId& canvId);
	// remove a mapping of itemid to canvas id
	void removeCanvItem(n_long itemId);

	// Trashcan Management
	MBCanvItem* removeItemFromTrash(const CanvItemId& canvId);
	Bool saveItemInTrash(n_long itemId, MBCanvItem* pItem);
	Bool emptyTrash();

	// map between the canv id of and item ids (i.e. cmd seq no's)
	inline CanvItemId itemId2canvId(n_long itemId);
	inline ulong canvId2itemId(CanvItemId cid);

	// returns an canvId that is the most recent among those between
	// mostRecent and timestamp and update mostRecent;
	// if cannot find a more recent one, return zero
	CanvItemId FindMostRecent(n_long& mostRecent, n_long timestamp);

	// raises tgtId to just before canvId
	void RaiseAfter(CanvItemId cid, n_long tgtId);

	// raises tgtId to the front
	void RaiseToFront(n_long tgtId);

	// tells the canvas that this is local
	void SetLocal() { isLocal_ = TRUE; }
	Bool isLocal() {  return isLocal_; }

	// update the request state and schedule the next request if neccessary
	void Update(MBReceiver *pRcvr, ulong startSn, ulong endSn);

	void ChangeStatus(const SrcId &srcId, Bool isVisible) {
		isVisible_ = isVisible;
		if (isVisible) {
			SchedRequest(srcId);
		} else {
			CancelRequest(getRequest());
		}
	}

	Bool isVisible() { return isVisible_; }
	void setIsVisible(Bool isVisible) { isVisible_ = isVisible; }
	int warpTime(MBReceiver* pRcvr, const MBTime& toTime);
	int timeRange(const PageId &pgId, MBTime& start, MBTime& end);

	ulong lastExeSn() { return lastExeSn_; }
	void lastExeSn(ulong sn) { lastExeSn_ = sn; }

#ifdef MB_DEBUG
	void Dump(int dumptype, Tcl_Obj* pObj) {
		if(dumptype==2)
			DumpCanvas(pObj);
		else MBPageObject::Dump(dumptype, pObj);
	}
	void DumpCanvas(Tcl_Obj* pObj);
#endif // MB_DEBUG

private:
	int reverseWarp(MBReceiver* pRcvr, const MBTime& t);

	// canvas when this page is to be drawn
	MBBaseCanvas* pCanv_ ;
	Bool isVisible_;

	/* this hash tables states should really belong to a "view"
	 * class, because we want multiple canvases on a page! */

	// use this table to store mapping of items to their ids on the canvas
	Tcl_HashTable *phtCanvId_;

	// use this table to store deleted items that are saved
	Tcl_HashTable *phtTrashCan_;

	// points to the seqno of the last executed command
	// (used for warping time)
	ulong lastExeSn_;

	/* FIXME: it is a bit wasteful to have a target time value for each page
	 * since it is a per page id property and not a per (rcvr, pgid)
         * property */

	Bool isLocal_;
};

// recall the canv id of an item
inline CanvItemId Page::itemId2canvId(n_long itemId) {
	/* FIXME: it appears that the same value is used for lookups
	 * back to back quite often, should consider caching the last
	 * value */
	Tcl_HashEntry *pEntry = Tcl_FindHashEntry(phtCanvId_, (char*)itemId);
	if (pEntry)
		return (CanvItemId) Tcl_GetHashValue(pEntry);
	else
		return (CanvItemId) 0; // signify cannot find item on canvas
}

// map canvas id to itemid
inline n_long Page::canvId2itemId(CanvItemId canvId) {
	MBBaseCanvas* pCanv = getCanvas();
	if (!pCanv)
		return 0;
	else
		return pCanv->canvId2itemId(canvId);
}


#endif /* #ifndef __MB_PAGE_H__ */
