/*
 * vu.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/vu.h,v 1.9 2002/02/03 04:11:42 lim Exp $
 */

#ifndef mash_vu_h
#define mash_vu_h

#include "tkwidget.h"
#include "transducer.h"

// ErikM
// no longer inherits from Transducer, but let another class inherit from
// transducer and contain a VUMeter (see comments below)
//class VUMeter : public TkWidget, public Transducer{

// abstract base class
class VUMeter : public TkWidget {
    public:
	VUMeter(const char* path,
		double scale, double lpfgain = .75, int width = 10);
	virtual void set(double);
	virtual int command(int argc, const char*const* argv);
    protected:
	virtual void draw();
	virtual void update();
	virtual void resize();
	virtual double warp(double value) const = 0;

	double value_;		/* current (mean) level */
	double alpha_;		/* low-pass filter time constant */
    private:
	inline void rect(Display* dpy, Drawable win, GC gc,
			 int x0, int y0, int w, int h) const;

	double scale_;

	int barht_;
	int gap_;

	int nlevel_;		/* number of discrete levels (i.e., blocks) */
	int hot_level_;		/* blk number we display in VatVU.hot color */
	int topblk_;		/* index of topmost block displayed */
	int ntop_;
	int peak_;		/* top block for peak indicator */
	int peakcnt_;		/* hysteresis for peak indicator */
	int setpeak_;

	static GC bg_;
	static GC fg_;
	static GC gray_;
	static GC hot_;
};

class DBMeter : public VUMeter {
    public:
	DBMeter(const char* path,
		double scale, double lpfgain = .75, int width = 10);
    protected:
	virtual double warp(double value) const;
};

class LinearMeter : public VUMeter {
    public:
	LinearMeter(const char* path,
		    double scale, double lpfgain = .75, int width = 10);
    protected:
	virtual double warp(double value) const;
};

/*
  ErikM

  In order to have a generic transducer which can be attached to the audio
  controller, transducer must inherit from TclObject.  Since TkWidget also
  inherits from TclObject, the compiler gets confused (not a compiler bug,
  it's just that we are asking for the TclObject pointer and then assigning
  that to a Transducer pointer in audio/controller.cc, which doesn't make
  sense.  The compiler doesn't know that the object also inherited from other
  stuff, so when it tries to do dynamic binding, it doesn't work).

  To fix this, I created the LinearMeterTransducer class which derives from
  class Transducer (which now inherits from TclObject) and CONTAINS a VUMeter
  object.  Tcl commands are passed through to the VUMeter (or derived class)
  and the transducer set() function calls the set() function of the VUMeter
  (note that the VUMeter::set() is no longer an overrided Transducer::set()
  call but something totally unrelated).
*/

class VUMeterTransducer : public Transducer {
public:
  VUMeterTransducer(const char* path, double scale, double lpfgain,
		    int width);
  virtual void set(double d);
  virtual int command(int argc, const char* const* argv);
protected:
  VUMeter* ptr;
};

class LinearMeterTransducer : public VUMeterTransducer {
public:
  LinearMeterTransducer(const char* path, double scale, double lpfgain,
			int width);
};

#endif

