/*
 * compat.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/win32/compat.cc,v 1.10 2002/02/03 04:13:10 lim Exp $";
#endif


#include "../mplug-compat.h"
#include <stdio.h>
#include "../rpi.h"


// a simple function to join a directory with a suffix
// this is platform-specific because UNIX and Windows have different
// separators for directory names ('/' and '\' respectively)

// if suffix contains any '/', replace them with '\' in the final result
char *
MPlug_JoinFilename(const char *dir, const char *suffix)
{
	if (dir==NULL) dir = "C:\\";
	int dirlen = strlen(dir);
	while (dirlen > 0 && dir[dirlen-1]=='\\') {
		// strip trailing slashes
		dirlen--;
	}

	char *filename = new char [dirlen + strlen(suffix) + 2];
	strncpy(filename, dir, dirlen);
	sprintf(filename + dirlen, "\\%s", suffix);

	// go through and change forward-slashes to backward-slashes in suffix
	for (char *ptr=filename + dirlen; *ptr!='\0'; ptr++) {
		if (*ptr=='/') *ptr = '\\';
	}

	return filename;
}


// platform-specific version of gettimeofday
void
MPlug_GetCurrentTime(struct timeval *tp)
{
    if (tp) {
            struct _timeb t;
            _ftime(&t);
            tp->tv_sec = t.time;
            tp->tv_usec = (long)t. millitm * 1000;
    }
}


void
MPlug_Output(const char *format, ...)
{
	static char buffer[1024];
	va_list ap;
	va_start(ap, format);
	vsprintf(buffer, format, ap);
	va_end(ap);

	MessageBox(NULL, buffer, "MPlug report", MB_OK);
}


void
MPlug_Log(const char *format, ...)
{
	static FILE *fp=NULL;
	if (fp==NULL) {
		fp = fopen("C:\\temp\\mplug.log", "w");
		if (fp==NULL) fp = fopen("mplug.log", "w");
	}
	va_list ap;
	va_start(ap, format);
	vfprintf(fp, format, ap);
	fflush(fp);
	va_end(ap);
}


NPBool
RPI::Fork(RPI::ArgArray *args, const char * /*stdoutFilename*/,
	  const char * /*stderrFilename*/)
{
	char *cmdline;
	STARTUPINFO startInfo;
	PROCESS_INFORMATION procInfo;

	args->CreateCmdline(cmdline);

	ZeroMemory(&startInfo, sizeof(startInfo));
	startInfo.cb = sizeof(startInfo);
	BOOL retval = CreateProcess(NULL, cmdline, NULL, NULL, TRUE,
				    DETACHED_PROCESS, NULL, NULL,
				    &startInfo, &procInfo);
	delete [] cmdline;
	return (retval ? TRUE : FALSE);
}
