/*
 * rep-decoder-h2612uncompressed.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "inet.h"
#include "rtp.h"
#include "rep-decoder.h"
#include "renderer.h"
#include "p64/p64.h"
#include "pktbuf.h"
#include "vidreps.h"

class H261ToUncompressedDecoder : public RepDecoder {
public:
  H261ToUncompressedDecoder();
  virtual ~H261ToUncompressedDecoder();
  virtual int command(int argc, const char*const* argv);
  virtual void post_delay_recv(pktbuf *pb);
  virtual void set_frame_buffer(VidRep *fb) {
    output_ = (Uncompressed *) fb;
  };
  virtual void resize(int inw, int inh);

protected:
  int decimation_;

  void decode(const u_char* vh, const u_char* bp, int cc);
  P64Decoder* codec_;
  int h261_rtp_bug_;

  Uncompressed *output_;
};

static class H261ToUncompressedDecoderClass : public TclClass {
public:
  H261ToUncompressedDecoderClass() :
    TclClass("Module/VideoDecoder/H261ToUncompressed") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new H261ToUncompressedDecoder);
  };
} dm_h261ToUncompressed_;

H261ToUncompressedDecoder::H261ToUncompressedDecoder() :
  RepDecoder(4), codec_(0), h261_rtp_bug_(0), output_(0)
{
  inw_ = 352;
  inh_ = 288;
  decimation_ = 411;

  resize(inw_, inh_);
}

H261ToUncompressedDecoder::~H261ToUncompressedDecoder()
{
  delete codec_;
}

void H261ToUncompressedDecoder::post_delay_recv(pktbuf* pb)
{
  int force_resize = 0;
  rtphdr* rh = (rtphdr*)pb->dp;
  u_int8_t* vh = (u_int8_t*)(rh + 1);
  if (codec_ == 0) {
    if ((vh[0] & 2) != 0)
      codec_ = new IntraP64Decoder();
    else
      codec_ = new FullP64Decoder();
    force_resize = 1;
  }

  /*FIXME*/
  u_int v = ntohl(*(u_int32_t*)vh);
  int sbit = v >> 29;
  int ebit = (v >> 26) & 7;
  int quant = (v >> 10) & 0x1f;
  int mvdh = (v >> 5) & 0x1f;
  int mvdv = v & 0x1f;
  int mba, gob;
  /*
   * vic-2.7 swapped the GOB and MBA fields in the RTP packet header
   * with respect to the spec.  To maintain backward compat, whenever
   * we see an out of range gob, we change our assumption about the
   * stream and continue.
   */
  if (!h261_rtp_bug_) {
    mba = (v >> 15) & 0x1f;
    gob = (v >> 20) & 0xf;
    if (gob > 12) {
      h261_rtp_bug_ = 1;
      mba = (v >> 19) & 0x1f;
      gob = (v >> 15) & 0xf;
    }
  } else {
    mba = (v >> 19) & 0x1f;
    gob = (v >> 15) & 0xf;
    if (gob > 12) {
      h261_rtp_bug_ = 0;
      mba = (v >> 15) & 0x1f;
      gob = (v >> 20) & 0xf;
    }
  }

  if (gob > 12) {
    pb->release();
    return;
  }
  int cc = pb->len - (sizeof(*rh) + 4);
  (void)codec_->decode(vh + 4, cc, sbit, ebit,
		       mba, gob, quant, mvdh, mvdv);

  /*
   * If the stream changes format, issue a resize.
   */
  if ((codec_->width() != inw_) || force_resize) {
    resize(codec_->width(), codec_->height());
  }

  /*FIXME*/
  if (ntohs(rh->rh_flags) & RTP_M) {
    codec_->sync();
    codec_->resetndblk();

    if (output_ != 0) {
      output_->ts_ = ntohl(rh->rh_ts);
      output_->ssrc_ = ntohl(rh->rh_ssrc);
      if (target_ != 0)
	target_->sched_exec(output_);
      if (callback_ != 0) {
	Tcl& tcl = Tcl::instance();
	tcl.eval(callback_);
      }
    }
  }
  pb->release();
}

void H261ToUncompressedDecoder::resize(int inw, int inh)
{
  if (output_ != 0) {
    output_->resized_ = 1;
    if (codec_ != 0) {
      u_char *frm = codec_->frame();
      int off = inw * inh;

      if (decimation_ == 411) {
	output_->init(inw, inh, 2, 2, inw, inh, 0, 0, frm,
		      frm + off, frm + off + (off >> 2));
      } else {
	output_->init(inw, inh, 2, 1, inw, inh, 0, 0, frm,
		      frm + off, frm + off + (off >> 1));
      }
    }
  }
  RepDecoder::resize(inw, inh);
}

int
H261ToUncompressedDecoder::command(int argc, const char*const* argv)
{
  return (RepDecoder::command(argc,argv));
}
