/*
 * server_mgr.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "tclcl.h"
#include "config.h"
#include "misc/all-types.h"
#include "rtsp/server_mgr.h"
#include "pktbuf.h"
#include "rtp/inet.h"



DEFINE_OTCL_CLASS(RTSPServerManager,"TCPServerManager/RTSP") {
	INSTPROC(attach);
	INSTPROC(serverhandler);
	INSTPROC(test_receiver);
	INSTPROC(reply);
	INSTPROC(reset);

}



RTSPServerManager::RTSPServerManager()
{
	pool_ = new BufferPool;
	temp_=0;

}

int
RTSPServerManager::attach(int argc, const char * const *argv)
{
	TclObject* server;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(server);
	END_PARSE_ARGS;

	server_ = (RTSPServer *)server;

	return TCL_OK;

}

int
RTSPServerManager::serverhandler(int argc, const char * const *argv)
{
	TclObject* handler;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(handler);
	END_PARSE_ARGS;

	handler_ = (TCPServerHandler *)handler;
	handler_->manager(this);

	return TCL_OK;

}

// Used for testing when I'm not connected to the network
int
RTSPServerManager::test_receiver(int argc, const char * const *argv)
{

	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	recv(0);
	return TCL_OK;
}

void
RTSPServerManager::recv(TCPServerHandler* sh)
{
	u_int32_t from;
	u_int16_t port;
	int len = PKTBUF_SIZE;

	pktbuf* pb = pool_->alloc();
	char newpb [PKTBUF_SIZE];

	int cc = sh->recv(pb->data, len, from, port);

	//sprintf((char *)pb, "SETUP rtsp://rose.cs.berkeley.edu/test/09151322-video1-2 RTSP/1.0\nTransport: RTP/AVP;multicast;destination=224.8.8.2;port=8000;ttl=16\n\nSETUP rtsp://rose.cs.berkeley.edu/test/09151322-video1-1 RTSP/1.0\nTransport: RTP/AVP;multicast;destination=224.8.8.4;port=8000;ttl=16\n\nPLAY rtsp://rose.cs.berkeley.edu/test.ctg RTSP/1.0\nSession: 1\n\n");

	if (cc>0) {
		sprintf(newpb, "%.*s", cc, pb->data);
		printf("from = %x port=%u pb = %s DONE\n", from, port, newpb);

		TCPServerChannel* channel = sh->chan();

		//static char addrbuf[sizeof(".xxx.xxx.xxx.xxx")];
		const char *addrbuf;
		addrbuf = intoa(from);
		//printf("from= %x %u fromaddr=%x %u\n", from, from, fromaddr, fromaddr);
		printf("%u %s\n", from, addrbuf);
		Tcl& tcl = Tcl::instance();
		tcl.evalf("%s recv-tcp %s %s {%s}", name(),  channel->name(), addrbuf, (char *)newpb);
	}
	else {
		printf("0 len message\n");
		temp_++;
	}
	if (temp_>5) {
		temp_=0;
		//sh->chan()->reset();
		sh->reset();

	}
	// Need to release pb at some point!

}

int
RTSPServerManager::reset(int argc, const char * const *argv)
{
	TclObject *chan;
	TCPServerChannel* channel;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(chan);
	END_PARSE_ARGS;

	channel = (TCPServerChannel *)chan;
	channel->reset();

	return TCL_OK;

}



	int
RTSPServerManager::reply(int argc, const char * const *argv)
{
	TclObject *chann;
	TCPServerChannel* channel;
	const char* buffer;

	BEGIN_PARSE_ARGS(argc, argv);
	//ARG(channel_num);
	ARG(chann);
	ARG(buffer);
	END_PARSE_ARGS;

	channel = (TCPServerChannel *)chann;


	channel->send((unsigned char *)buffer, strlen(buffer));
	return TCL_OK;
}

