# agent-hmsim.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/sim/hm/agent-hmsim.tcl,v 1.6 2002/02/03 04:16:36 lim Exp $

Class HMSimAgent -superclass { Process HMAgent }

set uniqpid 0
set numhm 1
set hosthm(0) 1

HMSimAgent instproc spawn {} {
	$self instvar al_ hmhosts_ app_ host_

	# build hmhosts_ - hmlist
       	set hmlist [$al_(hm) hmaddrs]

	set tlist $hmhosts_
	# remove any local entries we may have
	set i [lsearch -exact $tlist $host_]
	set tlist [lreplace $tlist $i $i]

	foreach h $hmlist {
		set i [lsearch -exact $tlist $h]
		set tlist [lreplace $tlist $i $i]
	}
#$self log "hmlist=$hmlist"
#$self log "hmhosts=$hmhosts_"
#$self log "tlist=$tlist"
	set n [llength $tlist]
	if { $n == 0 } {
		# no hosts to spawn to
		return 0
	}
	set r [expr [random] % $n]
	set shost [lindex $tlist $r]

	after [expr [random]%1000] "$self dospawn $shost"
	return 1
}

HMSimAgent instproc doexit {} {
	$self instvar al_ tid_ host_ pid_ alive_
#puts "exit $pid_@$host_"
	if { $alive_ == 0 } {
		puts "$self exiting when dead!
		return
	}

	$al_(hm) announce_death
	set alive_ 0

	foreach m { audio video mb sdp hm} {
		$al_($m) stop
		[$al_($m) set sess_] leave $al_($m)
	}
	set tids [array names tid_]
	foreach tid $tids {
		after cancel $tid
	}
	$self cancel
global hosthm numhm hmrec ns
incr numhm -1
incr hosthm($host_) -1
lappend hmrec "[$ns now] $numhm"
$self log "$hosthm($host_) $host_"
#$self log $numhm
	if { $numhm == 0 } {
		$self log "HM NUM = 0"
		exit 0
	}
}

HMSimAgent instproc dospawn { host } {
	$self instvar app_ logfd_
	set n [new HMSimAgent $host $app_ $logfd_]
	$n set alive_ 1

global numhm hosthm hmrec ns
incr numhm
if ![info exists hosthm($host)] {
	set hosthm($host) 0
}
lappend hmrec "[$ns now] $numhm"
incr hosthm($host)
$self log "$hosthm($host) $host"
#$self log "$numhm $host"
#$self log "$numhm"
}

HMSimAgent instproc pid {} {
	$self instvar pid_
	return $pid_
}

HMSimAgent instproc log msg {
	$self instvar logfd_ host_
	global ns
	if { $msg == "" } {
		puts $logfd_ ""
	} else {
#		puts $logfd_ "\[[$ns now]\]\[$host_\] $msg"
		puts $logfd_ "[$ns now] $msg"
	}
	flush $logfd_
}

HMSimAgent instproc read_hmhosts {} {
	$self instvar app_ hmhosts_ low_ high_
	set num [expr [$app_ get_option hostNum] - 1]
	# 0 is bootstrap
	while { $num > 0 } {
		lappend hmhosts_ $num
		incr num -1
	}
#$self log hmhosts=$hmhosts_
}

#
# This is HMSim specific!
#
proc localaddr {} {
	upvar self caller
	set agent [$caller set agent_]
	return [$agent set host_]
}

proc pid {} {
	upvar self caller
	set agent [$caller set agent_]
	return [$agent set pid_]
}

