/*
 * appmgr-srm.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*      $Id: appmgr-srm.h,v 1.14 2002/02/03 04:16:51 lim Exp $    */

#ifndef appmgr_srm_h
#define appmgr_srm_h

#include "pktbuf.h"
#include <sys/types.h>
#ifndef WIN32
#   include <sys/uio.h>
#   include <unistd.h>
#endif
#include "session-srm.h"
#include "source-srm.h"
#include "srm.h"

class SRM_Session;
class SRM_Packet;
class SRM_PacketHandler;

class SRM_AppMgr : public TclObject {
public:
    SRM_AppMgr(SRM_Packet *pkt);
    virtual ~SRM_AppMgr() { } ;
    virtual int next_ADU(u_char *db, int len, srm_src &id, int &pkt_type,
			 int &next);
    virtual SRM_PacketHandler *new_source(const srm_src &sid, int islocal);
    // "islocal" is non-zero for a local source obj

    // Application fills in the "last sequence number" that it has
    // sent out so far.
    virtual int periodic_update(u_char *buf);

    virtual void handle_request(const srm_src &/*sid*/, u_char *pb, int len) {
	handle_request(pb, len);
    }
    virtual void handle_reply(const srm_src &/*sid*/, u_char *pb, int len) {
	handle_reply(pb, len);
    }
    virtual void handle_SA(const srm_src &/*sid*/, u_char *pb, int len) {
	handle_SA(pb, len);
    }

    /*
     * we really ought to be using only the above definitions
     * the ones below are provided just for compatibility with the existing
     * version of mb
     */
    virtual void handle_request(u_char *pb, int len);
    virtual void handle_reply(u_char *pb, int len);
    virtual void handle_SA(u_char *pb, int len);

    SRM_Session* session() const { return ss_; }

    int command(int argc, const char*const* argv);

protected:
    int app_seqno_;
    u_char *t_dat_;
    SRM_Session *ss_;
    SRM_Packet *sp_;
};



class SRM_Packet : public TclObject{
public:
    SRM_Packet(const char *);
    ~SRM_Packet() { } ;
    int command(int argc, const char*const* argv);

    pktbuf *data(){
	return t_dat_;
    };

    int length() {
	return t_dat_->len;
    };

protected:
    pktbuf *t_dat_;
};


#endif
