/*
 * source-srm.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* 	$Id: source-srm.h,v 1.6 2002/02/03 04:16:51 lim Exp $	 */

#ifndef srm_source_h
#define srm_source_h

#include <string.h>
#include "sys-time.h"
#include "config.h"
#include "timer.h"
#include "inet.h"
#include "tclcl.h"
#include "srm.h"
#include "linkedlist.h"
#include "mtrace.h"


class SRM_SourceManager;
class SRM_AppMgr;
class pktbuf;

#define SOURCE_HASH 1024
#define SRMCP_SDES_MAX 7


// we need SRM_PacketHandler objects only for those sources which are
// actively sending data
class SRM_PacketHandler : public TclObject {
public:
    inline SRM_PacketHandler(int hdrlen=0) : hdrlen_(hdrlen), delvar_(0) { }
    virtual ~SRM_PacketHandler();
    virtual void recv(u_char *buf, int len) = 0;
private:
    int hdrlen_;
    int delvar_;
protected:
    inline int hdrlen() const { return (hdrlen_); }
    inline u_int32_t delvar() const { return (delvar_); }
    inline void delvar(u_int32_t v) { delvar_ = v; }
};



class SRM_Source : public TclObject {
public:
    SRM_Source(const srm_src &sid);
    virtual ~SRM_Source();

    virtual int command(int argc, const char*const* argv);
    inline SRM_PacketHandler* handler() const { return (handler_); }
    inline void handler(SRM_PacketHandler *handler) { handler_ = handler; }

    void lts_done(const timeval& now) { lts_done_ = now; }
    inline const timeval& lts_done() const { return (lts_done_); }
    /*inline u_int32_t addr() const {
	return (addr_);
    }
    inline void addr(u_int32_t a) { addr_ = a; }
    inline u_int32_t uid() const { return (uid_); }
    inline void uid(u_int32_t s) { uid_ = s; }*/
    inline const srm_src &id() const { return id_; }
    inline void id(const srm_src &id) { id_ = id; }
    inline double delay() {
	MTrace(trcSRM, ("Delay = %f", delay_));
	return (delay_);
    }
    inline void delay(double delay) { delay_ = delay; }
    inline double lts() { return (lts_);}
    inline void lts(double lts) {
	lts_ = lts;
    }

    void cname(const char *str);
    char *cname() {
	return cname_;
    }

private:
    SRM_Source* hlink_;		/* link for SRM_SourceManager hash table */

    SRM_PacketHandler* handler_;
    srm_src id_;                /* store in net order */
    timeval lts_done_;		/* local unix time for bye packet */
    double delay_;
    double lts_;		/* Time at which last message/ctrl packet
				 * was sent from this source */

    char *cname_;		/* Pointer to the variable length source name*/


    friend class SRM_SourceManager; /* to allow the source manager access to
				     * the hlink_ data member of the SRM_Source
				     */
};

class SRM_SourceManager : public TclObject {
public:
    SRM_SourceManager();
    virtual int command(int argc, const char*const* argv);

    SRM_Source* create_local(const srm_src &sid);
    SRM_Source* create_source(const srm_src &sid, int islocal);

    SRM_Source* consult(const srm_src &sid);
    // consult: try to find a source in internal tables

    //SRM_Source* lookup(const srm_src &sid);
    // lookup: consult, and if none found, create a new source

    SRM_Source* demux(const srm_src &sid, u_int16_t seq);

    inline int nsources() const { return (nsources_); }
    inline SRM_Source* first_local_source() const {
      return (local_sources_.PeekAtHead());
    }
    inline int is_local_source(SRM_Source *src) const {
      ListIndex idx;
      for (idx = local_sources_.getFirst();
	   local_sources_.IsDone(idx)==FALSE;
	   idx = local_sources_.getNext(idx)) {
	if (local_sources_.getData(idx)==src) return 1;
      }
      return 0;
    }
    inline List<SRM_Source> *local_sources() { return &local_sources_; }
    u_int32_t clock() const { return (clock_); }
    void remove(SRM_Source*);

protected:
    static int compare(const void*, const void*);
    SRM_Source* enter(SRM_Source* s);
    void remove_from_hashtable(SRM_Source* s);

    //SRM_Source* lookup_duplicate(const srm_src &sid);

    int              nsources_;
    u_int32_t        clock_;
    int              keep_sites_;
    u_int            site_drop_time_;
    SRM_Source       *generator_; // FIXME: (Yatin) What is this?
    SRM_Source       *hashtab_[SOURCE_HASH];
    List<SRM_Source> local_sources_;
    SRM_AppMgr       *appmgr_;
};


#endif

