# ui-ctrlmenu.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-ctrlmenu.tcl,v 1.10 2002/02/03 04:21:46 lim Exp $


import ControlMenu AudioControlMenu UIBook TopLevelWindow


Class ControlMenu/Video -superclass ControlMenu
Class ControlMenu/Audio -superclass AudioControlMenu
Class ControlMenu/Mb
Class ControlMenu/Mbv2
Class MultiControlMenu -superclass TopLevelWindow


ControlMenu/Video public init {mcm agent vpipe vframe observer} {
	$self set mcm_ $mcm
	$self next $observer $agent $vpipe $vframe $observer ""
}


ControlMenu/Video public build { w } {
	$self instvar path_
	set path_ $w
	frame $w -class VideoControlMenu

	frame $w.cb
	$self build.xmit $w.cb
	if { [$self yesno useScuba] && \
			[$self get_option megaVideoSession] != ""} {
		frame $w.scuba
		$self build.scuba $w.scuba
	}
	frame $w.encoder
	$self build.encoder $w.encoder
	frame $w.decoder
	$self build.decoder $w.decoder

	pack $w.cb -padx 6 -fill x -expand 1
	if { [$self yesno useScuba] && \
			[$self get_option megaVideoSession] != "" } {
		pack $w.scuba -padx 6 -fill x -expand 1
	}
	pack $w.encoder $w.decoder -padx 6 -fill x -expand 1

	if [$self have_transmit_permission] {
		$self selectInitialDevice
	}
}


ControlMenu/Video private build.tile w {
}


ControlMenu/Video public new_hostspec {} {
	$self instvar videoAgent_ namespec_ mcm_
	$mcm_ update_session_info video [$mcm_ get_rtp_info $videoAgent_]

	# use this to enable the transmit button if there is a device
	# to select
	if [$self have_transmit_permission] {
		$self selectInitialDevice
	}
}


ControlMenu/Audio instproc init { mcm agent ui panel } {
	$self set mcm_ $mcm
	$self next $agent $ui $panel
}


ControlMenu/Audio instproc build w {
	frame $w -class AudioControlMenu

	bind $w <Enter> "focus $w"
	frame $w.tp
	frame $w.tp.tests
	frame $w.tp.pri
	frame $w.omode
	#FIXMEframe $w.agc
	frame $w.net

	$self mk.tests $w.tp.tests
	$self mk.pri $w.tp.pri
	$self mk.omode $w.omode
	#FIXME NOT YET mk.agc $w.agc
	$self mk.net $w.net
	frame $w.pad -borderwidth 0 -height 6

	pack $w.tp.tests -side left -expand 1 -fill both -padx 2
	pack $w.tp.pri -side left -expand 1 -fill x -padx 2
	#FIXME pack $w.tp $w.omode $w.agc $w.net -expand 1 -fill x
	pack $w.tp $w.omode $w.net -expand 1 -fill x
	pack $w.tp -padx 4
	pack $w.omode -padx 6
}



#
ControlMenu/Audio private mk.net { w } {
	label $w.label -text "Network" -font [$self get_option ctrlTitleFont]
	frame $w.frame -borderwidth 0
	$self mk.me $w.frame

	pack $w.label $w.frame -expand 1 -fill x
	pack $w.frame -padx 6
}


ControlMenu/Audio public new_hostspec {} {
	$self instvar agent_ mcm_
	$mcm_ update_session_info audio [$mcm_ get_rtp_info $agent_]
}


ControlMenu/Mb public init {mcm ui} {
	$self set mcm_ $mcm
	$self set ui_  $ui
	$self next
}


ControlMenu/Mb public new_hostspec { } {
	$self instvar ui_ mcm_

	set agent [$ui_ get_local_option mbAgent]
	if { $agent == {} } {
		set dst none
		set port none
		set ttl none
		set srcid none
	} else {
		#set dst [[$session data-net] addr]
		#set port [[$session data-net] sport]
		#set ttl [[$session data-net] ttl]
		set dst  [$agent session-addr]
		set port [$agent session-port]
		set ttl  [$agent session-ttl]

		if { [$agent network] != "none" } {
			set sid [[$ui_ get_local_option mbMgr] local_srcid]
			set sid [split $sid _]
			# convert the address to x.x.x.x format
			set addr [expr 0x[lindex $sid 0]]
			set addr [binary format I $addr]
			binary scan $addr cccc a1 a2 a3 a4
			foreach a {a1 a2 a3 a4} {
				# convert from signed to unsigned
				set val [set $a]
				set val [expr ($val + 0x100) % 0x100]
				set $a $val
			}
			set srcid "[expr 0x[lindex $sid 1]]@$a4.$a3.$a2.$a1"
		} else { set srcid none }
	}

	$mcm_ update_session_info mb \
			"Destination: $dst\nPort: $port\nTTL: $ttl\nID: $srcid"
}


ControlMenu/Mbv2 public init {mcm ui} {
	$self set mcm_ $mcm
	$self set ui_  $ui
	$self next
}


ControlMenu/Mbv2 public new_hostspec { } {
	$self instvar ui_ mcm_

	set session [$ui_ get_local_option mbv2Session]
	if { $session == {} } {
		set dst none
		set port none
		set ttl none
		set srcid none
	} else {
		set ab [new AddressBlock [$session spec]]
		set dst [$ab addr]
		set port  [$ab sport]
		set rport [$ab rport]
		if { $port != $rport } { append port :$rport }
		set ttl [$ab ttl]
		if { $ttl == {} } { set ttl 15 }
		delete $ab

		set srcid [[$session sender] source_id]
	}

	$mcm_ update_session_info mbv2 \
			"Destination: $dst\nPort: $port\nTTL: $ttl\nID: $srcid"
}


MultiControlMenu public init { path ui } {
	$self next $path
	$self instvar ui_ path_
	set ui_ $ui
	set path_ $path
	$self create-window $path "Collaborator Control Menu"
	$self build_widget $path.book

	pack $path.book -fill both -expand 1 -padx 5 -pady 5
	button $path.dismiss -text "Dismiss" -bd 1 -command "$self toggle"
	pack $path.dismiss -anchor se -padx 5 -pady 1
}


MultiControlMenu private build_widget { path } {
	$self instvar ui_ book_
	UIBook $path -geometry 300x400 -usepack 1
	set book_ $path
	$self add_general_page
	#if [$ui_ get_local_option have_video] {
	#	$self add_video_page $path
	#}
	#if [$ui_ get_local_option have_audio] {
	#	$self add_audio_page $path
	#}
	#if [$ui_ get_local_option have_mb] {
	#	$self add_mb_page $path
	#}
}


MultiControlMenu private add_general_page { } {
	$self instvar book_
	ScrolledWindow $book_.general -scrollbar both
	$self build.general [$book_.general subwidget window]
	$book_ add $book_.general text {-text General}
	$book_ configure -toppage $book_.general
}


MultiControlMenu private build.session_line { w label } {
	frame $w
	label $w.label -text $label
	pack $w.label -side left -anchor nw
	frame $w.info
	label $w.info.info -text "" -anchor w -justify left -font \
			[WidgetClass widget_default -font] \
			-wraplength 250
	pack $w.info.info -fill both -expand 1 -anchor w -side bottom
	pack $w.info -side left -fill both -expand 1 -anchor w
	pack $w -fill x

	return $w.info
}


MultiControlMenu public get_rtp_info { agent } {
	set dst [$agent session-addr]
	set sport [$agent session-sport]
	set rport [$agent session-rport]
	if { $sport != $rport } { set port $sport:$rport } \
			else { set port $sport }
	set ttl [$agent session-ttl]
	set srcid [$agent get_local_srcid]

	return "Destination: $dst\nPort: $port\nTTL: $ttl\nID: $srcid"
}


MultiControlMenu public update_session_info { media info } {
	$self instvar book_
	[$book_.general subwidget window].sessions.$media.info.info \
			configure -text $info
}


# use this to notify the control menu of the original spec
# in case we are using MeGa
MultiControlMenu public original_session_spec { media spec } {
	$self instvar book_
	set orig [$book_.general subwidget window].sessions.$media.info.orig
	if ![winfo exists $orig] {
		label $orig -text "" -anchor w -justify left -font \
				[WidgetClass widget_default -font]
		pack $orig -fill x -anchor w -side top
	}

	$orig configure -text "Original spec: $spec"
}


MultiControlMenu private crypt_clear { } {
	$self instvar ui_
	foreach option {videoAgent audioAgent mbAgent} {
		set a [$ui_ get_local_option $option]
		if { $a != {} } { $a crypt_clear }
	}
}


MultiControlMenu private install-key { key } {
	$self instvar ui_
	foreach option {videoAgent audioAgent mbAgent} {
		set a [$ui_ get_local_option $option]
		if { $a != {} } { $a install-key $key }
	}
}


MultiControlMenu private build.general { w } {
	$self instvar ui_
	set f [$self get_option smallfont]

	label $w.slabel -text Sessions -anchor w
	pack $w.slabel -fill x

	frame $w.sessions -relief sunken -borderwidth 1
	pack $w.sessions -fill x

	if [$ui_ get_local_option have_rover] {
		$self set addrspec_(rover) [$self build.session_line \
				$w.sessions.mars Mars:]
	}
	set sdp [$ui_ get_local_option sdp]
	if { $sdp != {} } {
		$self set addrspec_(sdp) [$self build.session_line \
				$w.sessions.sdp Info:]
		array set asdp $sdp
		$self update_session_info sdp \
				"$asdp(session_name)\
				\n$asdp(session_info)\n\
				\nCreator: $asdp(creator)\
				\nURL: $asdp(url)"
	}
	if [$ui_ get_local_option have_video] {
		$self set addrspec_(video) [$self build.session_line \
				$w.sessions.video Video:]
	}
	if [$ui_ get_local_option have_audio] {
		$self set addrspec_(audio) [$self build.session_line \
				$w.sessions.audio Audio:]
	}
	if [$ui_ get_local_option have_mb] {
		$self set addrspec_(mb) [$self build.session_line \
				$w.sessions.mb MediaBoard:]
	}
	if [$ui_ get_local_option have_mbv2] {
		$self set addrspec_(mbv2) [$self build.session_line \
				$w.sessions.mbv2 "MediaBoard v2:"]
	}

	label $w.nlabel -text "" -anchor w
	pack $w.nlabel -fill x

	frame $w.stuff -relief sunken -borderwidth 1
	pack $w.stuff -fill x
	set name [$self get_option rtpName]
	frame $w.stuff.name
	label $w.stuff.name.label -text "Name: " -font $f -anchor e -width 6

	new TextEntry "$self update_name" $w.stuff.name.entry $name

	pack $w.stuff.name.label -side left
	pack $w.stuff.name.entry -side left -expand 1 -fill x -pady 2
	$self set namespec_ $w.stuff.name

	frame $w.stuff.msg
	label $w.stuff.msg.label -text "Note: " -font $f -anchor e -width 6
	new TextEntry "$self update_note" $w.stuff.msg.entry ""
	pack $w.stuff.msg.label -side left
	pack $w.stuff.msg.entry -side left -expand 1 -fill x -pady 2

	#
	# Create the entry widget for editing the session's
	# encryption key.  The audio agent exports methods
	# (invoked by the KeyEditor) to enable/disable encryption.
	#
	new KeyEditor $w.stuff $self

	pack $w.stuff.name $w.stuff.msg $w.stuff.key \
			-fill x -padx 2 -expand 1
}


MultiControlMenu public add_video_page { } {
	$self instvar ui_ book_
	set o [$ui_ get_local_option observer,video]
	set agent [$ui_ get_local_option videoAgent]
	set vpipe [$ui_ get_local_option videoPipe]
	set vframe [$ui_ get_local_option visualFrame]
	set cm [new ControlMenu/Video $self $agent $vpipe $vframe $o]
	$ui_ set_local_option controlmenu,video $cm

	ScrolledWindow $book_.video -scrollbar both
	set w [$book_.video subwidget window].ctrlmenu
	$cm build $w
	pack $w -fill both -expand 1
	$book_ add $book_.video text {-text Video}
	$cm new_hostspec
	return $cm
}


MultiControlMenu public add_audio_page { } {
	$self instvar ui_ book_

	set agent [$ui_ get_local_option audioAgent]
	set panel [$ui_ get_local_option audioPanel]
	set cm [new ControlMenu/Audio $self $agent $ui_ $panel]
	$ui_ set_local_option controlmenu,audio $cm

	ScrolledWindow $book_.audio -scrollbar both
	set w [$book_.audio subwidget window].ctrlmenu
	$cm build $w
	pack $w -fill both -expand 1
	$book_ add $book_.audio text {-text Audio}
	$cm new_hostspec
	return $cm
}


MultiControlMenu private add_mb_page { } {
	$self instvar ui_
	set cm [new ControlMenu/Mb $self $ui_]
	$ui_ set_local_option controlmenu,mb $cm
}


MultiControlMenu private add_mbv2_page { } {
	$self instvar ui_
	set cm [new ControlMenu/Mbv2 $self $ui_]
	$ui_ set_local_option controlmenu,mbv2 $cm
}


MultiControlMenu private update_name { name } {
	$self instvar ui_
	if { $name != ""} {
		foreach option {videoAgent audioAgent} {
			set a [$ui_ get_local_option $option]
			if { $a != {} } { $a set_local_sdes name $name }
		}

		set mbMgr  [$self get_local_option mbMgr]
		if { $mbMgr != {} } { $mbMgr update_name $name }
		return 0
	}
	return -1
}


MultiControlMenu private update_note { note } {
	$self instvar ui_
	foreach option {videoAgent audioAgent} {
		set a [$ui_ get_local_option $option]
		if { $a != {} } { $a set_local_sdes note $note }
	}
	return 0
}
