# application-lhm.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/lhm/application-lhm.tcl,v 1.4 2002/02/03 04:21:53 lim Exp $


import LocalHostManager Application

# app wrapper for LocalHostManager that does options processing
#
Class LocalHostManagerApplication -superclass Application


#
LocalHostManagerApplication public init {{argv ""}} {
    $self next localhostmanager
    set o [$self options]
    $o register_option -rendez rendez
    $o register_list_option -vscope vscope
    $o register_option -srvfile srvfile
    $o add_default srvfile \
	    ~/.mash/localsrvs/[string tolower [info hostname]]
    $o register_option -proxysrvfile proxysrvfile
    $o add_default proxysrvfile \
	    ~/.mash/proxysrvs/[string tolower [info hostname]]
    $o register_option -ctrl ctrlport
    $o register_option -execpath execpath
    # FIXME
    #$o add_default execpath "/h/mash/bin"
    $o add_default execpath "[pwd]/bin"
    $o register_option -tmppath tmppath
    $o add_default tmppath "/var/tmp"

    set argv [$o parse_args $argv]

    if {[llength $argv] != 0} {
	$o usage
	exit
    }

    set lm [new LocalHostManager]
}
