# powersw-srv.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/powerswitch-server/powersw-srv.tcl,v 1.9 2002/02/03 04:22:21 lim Exp $


import SerialChannel/Powerswitch-Microgreen-Duet UDPServer Rendezvous Trace

#Trace on
#Trace add PowerSwitchServer


# PowerSwitch RPC-style interface
#
Class UDPServer/PowerSw -superclass UDPServer

#
UDPServer/PowerSw public init {addrspec parent {mtu 1500}} {
    $self instvar parent_ pending_announce_ getting_own_msgs_
    set parent_ $parent
    set pending_announce_ -1
    set getting_own_msgs_ 0

    eval [list $self] next $addrspec $mtu
}

#
UDPServer/PowerSw private recv {addr port data size} {
    puts "Msg: $addr/$port \[$size\]: $data"

    $self instvar parent_ pending_announce_ getting_own_msgs_

    set theMethod [lindex $data 0]
    switch $theMethod {
	0 {
	    if {!$getting_own_msgs_} {
		puts "hearing own updates: need to disable mcast loopback"
		set getting_own_msgs_ 1
	    }
	    ## don't need to schedule another update -- this msg from self
	    return
	}
	set_power { $parent_ set_power "$data" }
	default { puts "bad msg: no action, but send state update" }
    }

    if {$pending_announce_ != -1} {
	after cancel $pending_announce_
    }
    set pending_announce_ [after 500 $self announce_reply]
}

#
UDPServer/PowerSw private announce_reply {} {
    $self instvar parent_ pending_announce_

    set p [$parent_ set powerswitch_]
    set state [$p array get plugState_]
    puts "$state"

    $self announce "$state"
    after 10 $self announce [list $state]
    after 40 $self announce [list $state]
    set pending_announce_ -1
}


#
# a UI-less server that accepts RPC-like commands and
# returns results for controlling a powerswitch
#
Class PowerSwitchServer

#
PowerSwitchServer public init {addrspec} {
    Trc $class "--> ${class}::$proc"

    $self instvar powerswitch_ al_

    set powerswitch_ [new SerialChannel/Powerswitch-Microgreen-Duet 1024]
    set dv [$self get_option serialdevicename]
    if {$dv != ""} {
	$powerswitch_ close
	$powerswitch_ device $dv
	$powerswitch_ open
    }

    set al_ [new UDPServer/PowerSw $addrspec $self]

    set raddr [$self get_option rendez]
    if {$raddr != ""} {
	$self start_rendez $raddr $addrspec
    }

}

#
PowerSwitchServer public start_rendez {raddr ctrladdr} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_
    set rv_ [new Rendezvous $raddr]
    set m "will-provide: mash-object=[$self info class] ctrlspec=$ctrladdr"
    set uid [$self get_option uniqid]
    if {$uid != ""} {set m "$m uniqid=$uid"}
    puts "starting rv msgs on $raddr"
    $rv_ start $m
}

#
PowerSwitchServer public destroy {} {
    $self instvar al_ powerswitch_

    delete $al_
    delete $avswitch_

    eval [list $self] next
}

#
PowerSwitchServer private set_power {data} {
    Trc $class "--> ${class}::$proc"
    $self instvar powerswitch_

    # 'set_power number onOff'
    if {[llength $data] != 3} {
	puts "bad params to set_power: $data"
	return
    }

    set num [lindex $data 1]
    set onOff [lindex $data 2]

    Trc $class "set_power"
    $powerswitch_ set_power $num $onOff
    Trc $class "done power"
    $powerswitch_ set plugState_($num) $onOff
    Trc $class "<-- ${class}::$proc"
}
