# recorder-api.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import DpClient

# this class provides remote control of the DC using the TclDP RPC mechanism;
#   it affects the DC by simulating GUI events

namespace eval RecorderApi {
    variable self
}

Class RecorderApi

RecorderApi instproc init {appRecorder port} {
    set RecorderApi::self $self

    $self instvar app_ server_
    set app_ $appRecorder

    # create a TclDP RPC server
    if {[catch {set server_ [new DpServer $port]} result]} {
	puts stderr "Warning: Recorder could not create API RPC Server: $result"
    }
}

RecorderApi instproc record {} {
    $self instvar app_

    set input_ui_ [$app_ set input_ui_]
    $input_ui_ config -result record
}

RecorderApi instproc stop {} {
    $self instvar app_

    # we have to get the status_ui_ now because it is not ready when
    #  RecorderApi is inited
    set status_ui_ [$app_ set status_ui_]
    $status_ui_ stop_all
}

#
# Recorder external API
#

proc recorder_record {} {
    $RecorderApi::self record
}

proc recorder_stop {} {
    # need the after so the calling app will not hang (though any further
    #   calls to the DpServer will fail of course
    after 1 "$RecorderApi::self stop"
}
