# al-platform.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/as/al-platform.tcl,v 1.5 2002/02/03 04:25:20 lim Exp $


import AnnounceListenManager/AS Timer/Adaptive/ConstBW

# Modifications to hm so that AS1 platforms can communicate on a global
# multicast channel and be aware of the presence of other AS1 platforms.
# Useful for wide-area services like distributed recording.
Class AnnounceListenManager/AS/Platform -superclass AnnounceListenManager/AS

AnnounceListenManager/AS/Platform instproc init { agent spec bw helper} {
	$self next $spec $bw platform
	$self set agent_ $agent

	set t [new Timer/Adaptive/ConstBW/2step $bw 30000]
	$t randomize
	set h [$helper get_timer]
	#puts "helper timer = $h"
	$t local_helper $h
	$self timer $t
	$t threshold 10000
}

# Platform keeps track of the number of hosts in it's local platform,
# plus the number of platforms world wide
AnnounceListenManager/AS/Platform instproc recv_announcement { addr port data size } {
	$self instvar lastann_ sdp_ agentbytype_ agenttab_ atype_ agent_
        set t [$self get_timer]
	$t sample_size $size
#puts ""
#puts "$self ($class): recv {$data}"
#puts ""
	#puts "^^^ [AnnounceListenManager/AS info body version]"
	#puts "^^^heritage is [$class info heritage]"
	#puts "version is [$class version]"
	set o [split $data \n]
	if { [lindex $o 0] != "ASCP v[AnnounceListenManager/AS version]" } {
		# FIXME
		set msg "$self ($class): received non-ASCP v[AnnounceListenManager/AS version] announcement from $addr."
		if { $atype_ == "hm" } {
			$self instvar agent_
			$agent_ log $msg
		} else {
			puts stderr $msg
		}

 		return
	}
	set atype [lindex $o 1]
	set aspec [lindex $o 2]
	set srv_name [lindex $o 3]
	set srv_loc [lindex $o 4]
	set srv_inst [lindex $o 5]
	set ssg_port [lindex $o 6]
	set ad [join [lrange $o 7 end] \n]

	# Special case death packet.
	if { $srv_name == "DEATH" } {
		set msg "Received death packet from $aspec at $addr - exiting."
		if { $srv_loc == $atype_ } {
			if { $atype_ == "hm" } {
				$self instvar agent_
				$agent_ log $msg
			} else {
				puts stderr $msg
			}
			$self announce_death
			exit 0
		}
		$self recv_msg $atype $aspec $addr DEATH $srv_loc \
			$srv_inst $ssg_port "$ad"
		return
	}
	# Synchronous bye
	if { $srv_name == "bye" } {
		$self delete_agent $aspec
		return
	}

	#if ![info exists agenttab_($aspec)] {

	set pid [lindex [split $aspec @] 0]
	#puts "pid=$pid"
	set platformid [lindex [split $aspec @] 1]
	#puts "platformid=$platformid"
	set aspec $platformid
	if ![info exists agenttab_($platformid)] {
		# new platform
		$self instvar avgdelta_
		$self register $atype $aspec $addr $srv_name $srv_inst "$ad"
		$t incr_nsrcs
		set timeout [$self get_option startupWait]
		set avgdelta_($aspec) [expr $timeout / 8]
		lappend agentbytype_($atype) $aspec


	} else {
		set now [gettimeofday]
		set delta [expr $now - $lastann_($aspec,abs)]
		$self instvar avgdelta_
		set avgdelta_($platformid) \
				[expr 0.875*$avgdelta_($aspec)+0.125*$delta]

	}
	set agenttab_($aspec) "$addr {$ad} $atype $srv_name $srv_inst"
	set lastann_($aspec,abs) [gettimeofday]
	set lastann_($aspec,ascii) [gettimeofday ascii]
	$self recv_msg $atype $aspec $addr $srv_name $srv_loc $srv_inst \
			$ssg_port "$ad"
}


AnnounceListenManager/AS/Platform instproc recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar agent_

	# For now, this is the only type of message we should be
	# recving on the global channel
	switch $atype {
		platform {

		}
		default {
			puts "Error: atype=$atype"
			exit
		}
	}

}

#
# We build a simple message since we only use this to announce
# our presence.
AnnounceListenManager/AS/Platform instproc send_announcement {} {
	$self instvar id1_ id2_

	set o "ASCP v[AnnounceListenManager/AS version]"
	set n platform
	set o $o\n$n
	set n [$self agent_instance]
	set o $o\n$n
	set n -
	set o $o\n$n
	set n -
	set o $o\n$n
	set n -
	set o $o\n$n
	set n -
	set o $o\n$n

	$self announce $o
}

# When you hear from another platform, there's only one message type, update
# Is there anything we have to do here?
# Everything else taken care of in recv_announcement?
AnnounceListenManager/AS/Platform instproc handle_platform_msg { aspec msg addr srv_name srv_inst } {
	$self instvar agent_

	switch $srv_name {

	}


}

# Instead of sending our instance, send platform id
AnnounceListenManager/AS/Platform public agent_instance {} {
	$self instvar agent_
	return "[pid]@[$agent_ get_option megaCtrl]"
}

# For now, do nothing, but agent should be notified, keep list of platforms/attributes
AnnounceListenManager/AS/Platform instproc register { atype aspec addr srv_name srv_inst msg } {
	$self instvar agent_

}

AnnounceListenManager/AS/Platform instproc unregister { atype aspec addr srv_name srv_inst ad } {
	$self instvar agent_

}


#
#
#

# Timer divided among 2 variables, global (num platforms) and local (num hosts)
Class Timer/Adaptive/ConstBW/2step -superclass Timer/Adaptive/ConstBW





# Set the helper timer which is to be contacted to determine how many local
# sources are sharing the announcement responsibility
Timer/Adaptive/ConstBW/2step public local_helper { local } {
	$self instvar local_
	set local_ $local
}



# This method recomputes the new timeout interval
Timer/Adaptive/ConstBW/2step private adapt {interval} {
	$self instvar avgsize_ bw_ nsrcs_ local_ thresh_

	set t [expr 1000 * ($nsrcs_ * $avgsize_ * 8) / $bw_]
	set l [expr [$local_ nsrcs 0] + 1]
	set t [expr $t / $l]
	if { $t < $thresh_ } {
		return $thresh_
	} else {
		return $t
	}
}
