# nam-ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#   @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/atobj/nam-ui.tcl,v 1.6 2002/02/03 04:25:26 lim Exp $


Class NamUI

NamUI instproc init {} {
        $self instvar refreshTime_ granularity_ updateInt_
        # refreshTime_ =def= physical time for 1 frame
        set refreshTime_ 100
        # granularity_ =def= animation time for 1 frame
        set granularity_ 2e-3
        # updateInt_ =def= rate to refresh control messages
        set updateInt_ [expr $granularity_*5]
}

NamUI instproc attach_view {anmView} {

        $self instvar timeL_ runB_ smoothB_ frameL_ roughtB_ granL_ quitB_
        $self instvar refreshTime_ view_ pathname_ granT_ timeT_

        $self set view_ $anmView
        set vpath [$anmView path]
        set pathname_ [frame $vpath.bf]

        # REVIEW: allow individual buttons to be slapped on independently?
        set timeT_ [button $pathname_.tt -text " Time:" -relief flat \
                        -activebackground [lindex \
                        [$pathname_ configure -background] 4] \
                        -command "new StackTrace {}"]
        set timeL_ [label $pathname_.time -text 0.00 -relief ridge]
        set granT_ [label $pathname_.gt -text " step:"]
        set granL_ [label $pathname_.gran \
                        -text [concat "step:" [format %.2f \
                        [$self set granularity_]] ms] \
                        -relief ridge]
        set smoothB_ [button $pathname_.smooth -text "-" -width 1 \
                        -command "$self smoother +10"]
        set frameL_ [label $pathname_.ft -relief ridge \
                        -text "[format %1.1f [expr 1000./$refreshTime_]] fps"]
        set roughtB_ [button $pathname_.rough -text "+" -font fixed \
                        -command "$self smoother -10"]
        set quitB_ [button $pathname_.quit -text Quit -command exit]

        set runB_ [checkbutton $pathname_.run -text " Run " \
                        -indicatoron false -selectcolor gray10 \
                        -command "$self toggleRun"]


        $runB_ deselect
        pack $pathname_ -side bottom -fill x -anchor c
        $self setup_tSlider

        pack $timeT_ $timeL_ $granT_ $granL_ $smoothB_ \
                        $frameL_ $roughtB_  -side left -fill x
        pack $quitB_ $runB_ -side right

        bind $vpath <q> exit
        bind $vpath <Control-c> exit
        bind $vpath <space> "$self toggleRun"
}

NamUI instproc attach_datasrc {datasrc} {
        $self instvar datasrc_ timeL_ mintime_ maxtime_ range_
        set datasrc_ $datasrc
        $self attach_hooks [$self set view_]
        $timeL_ configure -text [format %.4f [$datasrc now]]
        set mintime_ [$datasrc mintime]
        set maxtime_ [$datasrc maxtime]
        set range_ [expr $maxtime_ - $mintime_]
        $self set granularity_ [format %.2f [expr $range_ /2000]]
        $self setup_sSlider
}

NamUI instproc setup_tSlider {} {
        $self instvar tSlider_ pathname_ tsPressed_

        set tsPressed_ 0
        set tSlider_ [scale $pathname_.ts -orient horizontal \
			-from 0 -to 10000 -relief groove -borderwidth 1 \
                        -showvalue false \
                        -command "$self updateTime"]

        #
	# We want slightly different semantics.  Instead of tracking
	# the time slider continuously, we just update it when the
	# button is released. (but we use updateTime to give feedback to the
        # user
	# E.g., it takes too long to do a fast-forward each time.
	#
        bind $tSlider_ <Button-1> "$self wait"
        bind $tSlider_ <Button-2> "$self wait"

	bind $tSlider_ <ButtonRelease-1> "$self move2time"
	bind $tSlider_ <ButtonRelease-2> "$self move2time"

        pack $tSlider_ -side top -fill x
}

NamUI instproc updateTime {x} {
        $self instvar timeL_ mintime_ maxtime_ tsPressed_

        # update the disply only if slider is pressed
        if !$tsPressed_ return

#        DbgOut $mintime_ $maxtime_
        set newtime [expr $mintime_ + ($x/10000.0)*($maxtime_ - $mintime_)]
#        DbgOut $newtime
        $timeL_ configure -text [format %.4f $newtime]
}

# suspends the datasrc, so that hook_updateTime won't interfere
NamUI instproc wait {} {
        $self instvar tsPressed_ shouldResume_ datasrc_
        set tsPressed_ 1
        set shouldResume_ [$datasrc_ isRunning]
        if $shouldResume_ {
                $datasrc_ setRunning 0
        }
}

NamUI instproc move2time {} {
        $self instvar tSlider_ mintime_ range_ datasrc_ maxtime_ tsPressed_
        $self instvar shouldResume_
        DbgOut end [$tSlider_ get]

        set x [$tSlider_ get]
        set newtime [expr $mintime_ + ($x/10000.0)*$range_]
        $datasrc_ reset
        $datasrc_ setTime $newtime
        $datasrc_ render_next $newtime
        if $shouldResume_ {
                $datasrc_ setRunning 1 $maxtime_
        }
        set tsPressed_ 0
}

NamUI instproc display_time {t} {
        $self instvar timeL_ tSlider_ mintime_ range_ tsPressed_
        # don't update time if the time slider is pressed (and still held down)
        if $tsPressed_ return
        $timeL_ configure -text [format %.4f $t]
        $tSlider_ set [expr int(10000. * ($t - $mintime_)/$range_)]
}

NamUI instproc setup_sSlider {} {
        $self instvar sSlider_ view_
        set fpath [$view_ fpath]
        set wpath [$view_ wpath]
        # REVIEW: put this in xresources
        set min 50
        set max 6000
        set sSlider_ [scale $fpath.ss -orient vertical \
			-from $min -to $max -relief groove -borderwidth 1 \
                        -showvalue false \
                        -command "$self updateGran"]
        $sSlider_ set [expr int(($min + $max)/2)]
    	bind $sSlider_ <ButtonRelease-1> "$self changeGran"
	bind $sSlider_ <ButtonRelease-2> "$self changeGran"
        pack $wpath -side left -fill both -expand 1
        pack $sSlider_ -side right -fill y
}

NamUI instproc changeGran {} {
        $self instvar granularity_ sSlider_ range_ granL_ datasrc_
        # divide the range by 100 to 1000 intervals
        set x [$sSlider_ get]
        set granularity_ [format %.4f [expr $range_/($x)]]
        DbgOut new gran $granularity_
        $datasrc_ setGran $granularity_
        $granL_ configure -text "[format %4g [expr $granularity_*1000]] ms"
}

# update only don't change datasrc's granularity as yet
NamUI instproc updateGran {x} {
        DbgOut gran: $x
        $self instvar granL_ range_
        set granularity_ [format %.4f [expr $range_/($x)]]
        DbgOut new gran: $granularity_
        $granL_ configure -text "[format %4g [expr $granularity_*1000]] ms"
}

NamUI instproc attach_hooks {anmView} {
        # note the different quotes:
        # $... is NamUI variables,
        # \$... refers datasrc variables
        $self instvar timeL_ datasrc_ runB_
        $datasrc_ proc hook_updateTime {t} \
                        "$self display_time \$t; \
                        \$self next \$t"
        $datasrc_ proc hook_stop {t} \
                        "$datasrc_ req_sent_ctrl \{s \$t\}; \
                        $runB_ deselect"
}

NamUI instproc toggleRun {} {
        $self instvar datasrc_ updateInt_ maxtime_
        if [$datasrc_ isRunning] {
                $datasrc_ setRunning 0
        } else {
                $datasrc_ setRunning 1 $maxtime_
        }
}

NamUI instproc smoother {dir} {
        $self instvar refreshTime_ frameL_ datasrc_
        if {$refreshTime_ > 11} {
                set refreshTime_ [expr $refreshTime_ + $dir]
                $datasrc_ setRefresh $refreshTime_
        }
        $frameL_ configure -text "[format %1.1f [expr 1000./$refreshTime_]] fps"
}
