# smash-compat.tcl --
#
#       Provide a Tk-compatible "option" command for tcl/smash
#       applications.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/common/smash-compat.tcl,v 1.5 2002/02/07 00:22:36 weitsang Exp $

proc option args {
	global _db
	if { [lindex $args 0] == "add" } {
		set o [split [lindex $args 1] .]
		set cls [lindex $o 0]
		set resource [lindex $o 1]
		set value [lindex $args 2]
		set pri [lindex $args 3]
		if { $pri == "" } {
			set pri 80
		}
		if [info exists _db($cls,$resource,pri)] {
			set oldpri $_db($cls,$resource,pri)
		} else {
			set oldpri -1
		}
		if { $oldpri > $pri } {
			return
		}
		set _db($cls,$resource,val) $value
		set _db($cls,$resource,pri) $pri
	} elseif { [lindex $args 0] == "get" } {
		set resource [lindex $args 2]
		set cls [lindex $args 3]
		if [info exists _db($cls,$resource,val)] {
			return $_db($cls,$resource,val)
		} else {
			return ""
		}
	} elseif { [lindex $args 0] == "clear" } {
		unset _db
	}
}
