# application-scanconv.tcl --
#
#      Contains a ScanConvInterface to provide control of the scan converter
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application ScanConvInterface

Class ScanConvApplication -superclass Application

ScanConvApplication instproc init { argv } {
    $self instvar scInterface_

    # for amxd 
    set options [$self options]
    $options register_option -ah optAmxHost
    $options register_option -ap optAmxPort
    $options add_default optAmxHost htsr2.bmrc.berkeley.edu
    $options add_default optAmxPort 6901

    set argv [$options parse_args $argv]
    set amxHost [$self get_option optAmxHost]
    set amxPort [$self get_option optAmxPort]

    $self next "Scan Converter Adjustment"
    $self InitUI
    set scInterface_ [new ScanConvInterface $amxHost $amxPort ".main_frame"]
}

ScanConvApplication instproc InitUI {} {
    global g_mode
    $self instvar 405_

    wm title . "Scan Converter Adjustment"
    wm minsize . 150 0

    # frame the scan converter interface will reside in
    frame .main_frame
    pack .main_frame -side top

    # make exit button
    button .exit -text "Exit" -command "$self ExitApp"
    pack .exit -side bottom
}

ScanConvApplication instproc ExitApp {} {
    $self instvar scInterface_

    delete $scInterface_
    exit
}

