# fca-rreq.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

###
FCARepairRequest superclass FCA_Packet
FCARepairReply   superclass FCA_Packet
Class FCARepairRequest/Tcl -superclass {FCARepairRequest}
FCARepairRequest/Tcl instproc init {} {
    $self next
    $self set maxBackoffs_ 10
    $self set numBackoffs_ 0
    $self set list ""
    $self set numRequests 0
}



###### participant repair request

Class FCARepairRequest/Tcl/Participant -superclass FCARepairRequest


FCARepairRequest/Tcl/Participant instproc init {} {
    $self next
    $self set pktType "PKT_PARTICIPANT_RREQ"
    $self set list ""
    $self set numRequests 0
    DbgOut "NEW FCARepairRequest/Tcl/Participant"
}

# return 1 if list modified due to the reply
FCARepairRequest/Tcl/Participant instproc gotReply { important seq } {
    $self instvar list numRequests
    DbgOut "RReq list(start): $list :::::::: $important $seq"
    if { $list == "" } {
	DbgOut "FCARepairRequest/Tcl/Participant::getReply, RepairRequest_ \
		has an empty list"
	DbgOut "RReq list(end): $list :::::::: $important $seq"
	return 0
    }

    set index 0
    foreach item $list {
	if {[lindex $item 0] == $important} {
	    set sseq [lindex $item 1]
	    set eseq [lindex $item 2]
	    if {($sseq <= $seq) && ($seq <= $eseq)} {
		if {$sseq == $seq} {
		    set sseq [expr $sseq + 1]
		    if { $sseq > $eseq } {
			set list [lreplace $list $index $index]
			incr numRequests -1
			if {[llength list] == 0 } {
			    $self cancel
			}
			DbgOut "RReq list(end): $list :::::::: $important $seq"
			return 1
		    }
		    set list [lreplace $list $index $index \
			    "$important $sseq $eseq"]
		    DbgOut "RReq list(end): $list :::::::: $important $seq"
		    return 1
		}

		if {$eseq == $seq}  {
		    set eseq [expr $eseq - 1]
		    set list [lreplace $list $index $index \
			    "$important $sseq $eseq"]
		    DbgOut "RReq list(end): $list :::::::: $important $seq"
		    return 1
		}

		linsert list [expr $index + 1] \
			[list "$important [expr $seq + 1] $eseq"]
		set list [lreplace $list $index $index \
			[list "$important $sseq [expr $seq - 1]"]]
		incr numRequests 1
		DbgOut "RReq list(end): $list :::::::: $important $seq"
		return 1
	    }
	}
	incr index 1
    }
    DbgOut "RReq list(end): $list :::::::: $important $seq"
    return 0
}


#
# newItem: is a triple of "isImportant start_seq end_seq"
#
FCARepairRequest/Tcl/Participant instproc insert {newItem} {
    $self instvar list numRequests
    if {$newItem == ""} {
	DbgOut "FCARepairRequest/Tcl/Participant::insert, newItem empty"
    }
    set isImportant [lindex $newItem 0]
    set newsseq [lindex $newItem 1]
    set neweseq [lindex $newItem 2]

    DbgOut "FCARepairRequest/Tcl/Participant::insert, newItem = $newItem\
	    list before inserting newItem = $list"

    set index 0
    foreach item $list {
	if {[lindex $item 0] == $isImportant} {
	    set sseq [lindex $item 1]
	    set eseq [lindex $item 2]
	    if {($newsseq <= $eseq) && ($neweseq >= $sseq)} {
		# if overlap
		if { ($newsseq >= $sseq) && ($eseq >= $neweseq) } {
		    # this old request encompasses the new request
		    return
		}
		if { ($newsseq < $sseq) && ($eseq < $neweseq) } {
		    # new emcompasses the old
		    set newItem "$isImportant $newsseq $neweseq"
		    set list [lreplace $list $index $index $newItem]
		    return
		}
		# old       ---------
		# new  --------
		if {$neweseq < $eseq } {
		    set newItem "$isImportant $newsseq $eseq"
		    set list [lreplace $list $index $index $newItem]
		    return
		}
		# old ---------
		# new      ---------
		if {$newsseq > $sseq} {
		    set newsseq [expr $eseq + 1]
		}
	    }
	}
	incr index 1
    }

    lappend list $newItem
    incr numRequests 1
    DbgOut "FCARepairRequest/Tcl/Participant::insert, list ($list):"
}


FCARepairRequest/Tcl/Participant instproc overlap { rqPkt } {
    $self instvar list

    set rqList [$rqPkt set list]
    foreach rqItem $rqList {
	foreach myItem $list {
	    if {[lindex $rqItem 0] == [lindex $myItem 0] } {
		set rqSseq [lindex $rqItem 1]
		set rqEseq [lindex $rqItem 2]
		set mySseq [lindex $myItem 1]
		set myEseq [lindex $myItem 2]
		if {($rqSseq <= $myEseq) && ($rqEseq >= $mySseq) } {
		    return 1
		}
	    }
	}
    }
    return 0
}



# return 1 if backoffed, 0 otherwise
#FCARepairRequest/Tcl/Participant instproc backoff_ { fcaPkt } {
#    $self instvar sseq_ eseq_ numBackoffs_ maxBackoffs_ rcvr_
#    set newsseq [$fcaPkt set sseq]
#    set neweseq [$fcaPkt set eseq]
#    if {($newsseq <= $eseq_) && ($neweseq >= $sseq)} {
#	# conservative approach, backoff if overlap
#	$self backoff
#	incr numBackoffs_ 1
#	if {$numBackoffs >= $maxBackoffs_} {
#	    $rcvr_ rmPartRepairRequest $self
#	    $self cancel
#	    delete $self
#	}
#	return 1
#    }
#    return 0
#}



###### moderator repair request

Class FCARepairRequest/Tcl/Moderator -superclass FCARepairRequest/Tcl


FCARepairRequest/Tcl/Moderator instproc init { moderatorState } {
    $self next
    $self set pktType "PKT_MODERATOR_RREQ"
    $self set moderatorState $moderatorState
    DbgOut "NEW FCARepairRequest/Tcl/Moderator"
}

FCARepairRequest/Tcl/Moderator instproc moderator_state {} {
    return [$self set moderatorState]
}


FCARepairRequest/Tcl/Moderator instproc set_moderator_state {state} {
    $self set moderatorState $state
}


# return 1 if backoffed, 0 otherwise
#FCARepairRequest/Tcl/Moderator instproc backoff_ { fcaPkt } {
#    $self instvar curState_ numBackoffs_ maxBackoffs_ rcvr_
#    set curState [$fcaPkt set curState]
#    if {$curState_ <= curState} {
#	# if my state is older, backoff
#	$self backoff
#	incr numBackoffs_ 1
#	if {$numBackoffs >= $maxBackoffs_} {
#	    # remove from the fcd repairRequests_
#	    $rcvr_ rmModRepairRequest $self
#	    $self cancel
#	    delete $self
#	}
#	return 1
#    }
#    return 0
#}


######
Class FCARepairReply/Tcl -superclass FCARepairReply
FCARepairReply/Tcl instproc init {} {
    $self next
}



###
Class FCARepairReply/Tcl/Participant -superclass FCARepairReply/Tcl
FCARepairReply/Tcl/Participant instproc init {} {
    $self next
    $self set pktType "PKT_PARTICIPANT_RREPLY"
    $self set numReplies 0
    $self set pktReplies ""
}


# return 1 if exist, otherwise 0
FCARepairReply/Tcl/Participant instproc FOOBAR { isImportant newReply } {
    $self instvar numReplies pktReplies
    foreach reply $pktReplies {
	set replyPktType [$reply set pktType]
	switch $replyPktType {
	    PKT_FLOOR_REQUEST {
		if {!$isImportant} {
		    set requestId [$reply set requestId]
		    if { $requestId == [$newReply requestId] } {
			return 1
		    }
		}
	    }
	    PKT_FLOOR_CANCEL {
		if {$important} {
		    set type [lindex $newReply 0]
		    if {$type == "cancel"} {
			set seq [lindex $newReply 2]
			if {[$reply set seqno] == $seq } {
			    return 1
			}
		    }
		}
	    }
	    PKT_FLOOR_RELEASE {
		if {$important} {
		    if {$type == "release"} {
			set seq [lindex $newReply 2]
			if {[$reply set seqno] == $seq} {
			    return 1
			}
		    }
		}
	    }
	}
    }
    return 0
}


FCARepairReply/Tcl/Participant instproc reply_exists { fcaPkt } {
    $self instvar pktReplies
    foreach reply $pktReplies {
	if { [$reply set pktType] != [$fcaPkt set pktType] } continue

	switch [$reply set pktType] {
	    PKT_FLOOR_REQUEST {
		if { [$reply set requestId]==[$fcaPkt set requestId] } {
		    return 1
		}
	    }
	    PKT_FLOOR_CANCEL {
		set seqno [$fcaPkt set seqno]
		if { $seqno==[$reply set seqno] } {
		    if { $seqno!=0 } {
			return 1
		    } elseif { [$fcaPkt set requestId] \
			    == [$reply set requestId] } {
			return 1
		    }
		}
	    }
	    PKT_FLOOR_RELEASE {
		not_implemented yet
	    }
	    PKT_OBSOLETE {
		if { [$fcaPkt set seqno]==[$reply set seqno] } {
		    return 1
		}
	    }
	}
    }

    return 0
}


FCARepairReply/Tcl/Participant instproc insertReply { fcaPkt } {
    $self instvar numReplies pktReplies

    DbgOut "FCARepairReply/Tcl/Participant::insertReply $fcaPkt"

    if {[$self reply_exists $fcaPkt]} {
	DbgOut "reply already exist, don't need to insert to the reply"
	delete $fcaPkt
	return
    }

    incr numReplies 1
    lappend pktReplies $fcaPkt

    DbgOut "FCARepairReply/Tcl/Participant::insertReply: self=$self, \
	    numReplies=$numReplies"
    foreach reply $pktReplies {
	DbgOut "        pktType = [$reply set pktType]"
    }
}



FCARepairReply/Tcl/Participant instproc ANOTHER_FOOBAR { pktType reply } {
    $self instvar numReplies pktReplies

    DbgOut "FCARepairReply/Tcl/Participant::insertReply $reply"

    if {[$self reply_exist $isImportant $reply]} {
	DbgOut "reply already exist, don't need to insert to the reply"
	return
    }

    incr numReplies 1
    set fcaPkt [new FCA_Packet]
    $fcaPkt set pktType $pktType

    switch $pktType {
	PKT_FLOOR_CANCEL {
	    $fcaPkt set seqno $seqno
	    $fcaPkt set requestId $requestId
	}

    }


    if { $isImportant } {
	# the reply is:
	#     {<type>  <id>}   <seqno>
	#    (cancel/release)
	set type  [lindex [lindex $reply 0] 0]
	set id    [lindex [lindex $reply 0] 1]
	set seqno [lindex $reply 1]
	switch $type {
	    cancel {
		$fcaPkt set pktType "PKT_FLOOR_CANCEL"
		$fcaPkt set seqno $seqno
		$fcaPkt set requestId $requestId
	    }

	    release {
		DbgOut "FCARepairReply/Tcl/Participant::insertReply, \
			Release is not being handled right now"
		$fcaPkt set pktType "PKT_FLOOR_RELEASE"
#		$fcaPkt set seqno $seqno
#		$fcaPkt set grantSeqno $requestId
	    }

	    "" {
		# this entry is obsolete
		$fcaPkt set pktType "PKT_OBSOLETE"
		$fcaPkt set seqno $seqno
	    }

	    default {
		DbgOut "FCARepairReply/Tcl/Participant::insertReply, \
			wrong type"
	    }
	}
    } else {
	$fcaPkt set pktType "PKT_FLOOR_REQUEST"
	$fcaPkt set requestId [$reply requestId]
	$fcaPkt set comment [$reply comment]
	$fcaPkt set floors [$reply floorTypes]
	$fcaPkt set numFloors [llength [$fcaPkt set floors]]
    }
    lappend pktReplies $fcaPkt
    DbgOut "FCARepairReply/Tcl/Participant, insertReply, replyobj = $self"
    foreach reply $pktReplies {
	DbgOut "pktType = [$reply set pktType] \
		requestId = [$reply set requestId] \
		comment = [$reply set comment] \
		floors = [$reply set floors] \
		numFloors = [$reply set numFloors] "
    }
}



# return 1 if canceled
FCARepairReply/Tcl/Participant instproc cancel_reply {rrpy} {
    $self instvar list numReplies pktReplies

    set canceled 0

    set myIndex 0
    foreach myRpy $pktReplies {
	DbgOut "pktReplies: '$pktReplies', numReplies: $numReplies"
	set myPktType [$myRpy set pktType]
	set newPktType [$myRpy set pktType]
	if {$myPktType == $newPktType} {
	    switch $myPktType  {
		"PKT_FLOOR_REQUEST" {
		    set newRequestId [$rrpy set requestId]
		    set myRequestId [$myRpy set requestId]
		    if {$myRequestId == $newRequestId} {
			DbgOut "Replacing $myIndex ($myRpy): REQUEST"
			set canceled 1
			set pktReplies [lreplace $pktReplies $myIndex $myIndex]
			delete $myRpy
			incr numReplies -1
			break
		    }
		}
		"PKT_FLOOR_CANCEL"  {
		    set newSeqno [$rrpy set seqno]
		    set mySeqno [$myRpy set seqno]
		    if { ($mySeqno!=0 && $mySeqno == $newSeqno) || \
			    ($mySeqno==0 && \
			    [$rrpy set requestId]==[$myRpy set requestId]) } {
			DbgOut "Replacing $myIndex ($myRpy): CANCEL"
			set canceled 1
			set pktReplies [lreplace $pktReplies $myIndex $myIndex]
			delete $myRpy
			incr numReplies -1
			break
		    }
		}
		"PKT_FLOOR_RELEASE" {
		    set newSeqno [$rrpy set seqno]
		    set mySeqno [$myRpy set seqno]
		    if {$mySeqno == $newSeqno} {
			DbgOut "Replacing $myIndex ($myRpy): RELEASE"
			set canceled 1
			set pktReplies [lreplace $pktReplies $myIndex $myIndex]
			delete $myRpy
			incr numReplies -1
			break
		    }
		}
		"PKT_OBSOLETE" {
			    set newSeqno [$rrpy set seqno]
		    set mySeqno [$myRpy set seqno]
		    if {$mySeqno == $newSeqno} {
			DbgOut "Replacing $myIndex ($myRpy): OBSOLETE"
			set canceled 1
			set pktReplies [lreplace $pktReplies $myIndex $myIndex]
			delete $myRpy
			incr numReplies -1
			break
		    }
		}
		default {
		    DbgOut "FCARepairReply/Tcl/ParticipantFCARcvr/Tcl::\
			    cancel, wrong packet type"
		}

	    }
	}
	incr myIndex 1
    }
    if { $numReplies <= 0 } {
	$self cancel
    }
    return $canceled
}


FCARepairReply/Tcl/Participant instproc numReplies {} {
    return [$self set numReplies]
}


FCARepairReply/Tcl/Participant instproc replies {} {
    return [$self set pktReplies]
}


###
Class FCARepairReply/Tcl/Moderator -superclass FCARepairReply/Tcl
FCARepairReply/Tcl/Moderator instproc init {} {
    $self next
    $self set pktType "PKT_MODERATOR_RREPLY"
    $self set pktGrantUpdate ""
    $self set pktQueueUpdate ""
    $self set state_ 0
}


FCARepairReply/Tcl/Moderator instproc state {} {
    return [$self set state_]
}


FCARepairReply/Tcl/Moderator instproc set_state {state} {
    $self set state_ $state
}


# HERE!!
#FCARcvr/Tcl instproc backoff { fcaPkt } {
#    $self instvar repairRequests_
#    set pktType [$fcaPkt set pktType]
#    if {1} {
#	set backoffed 0
#	foreach rreq $repairRequests_ {
#	    if { [rreq backoff_ $fcaPkt] } {
#		set backoffed 1
#	    }
#	}
#	return $backoffed
#    }
#}

# local receiver is participant, only have queues of
#FCAFloorDynamics instproc backoff { fcaPkt } {
#    $self instvar repairRequests_
#    set backoffed 0
#    foreach rreq $repairRequests_ {
#	if { [rreq backoff_ $fcaPkt] } {
#	    set backoffed 1
#	}
#    }
#    return $backoffed
#}
