# application-mat.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Application MatUI

Class MatApplication -superclass Application

MatApplication instproc init { argv } {
	$self next mat

	set o [$self options]
	$self init_args $o
	$self init_resources $o
	$o parse_args $argv

	$self init_ui
}

MatApplication instproc init_args o {
	$self next $o

	$o register_option -dir slideDir
	$o register_option -out slideOutputFile
	$o register_option -width slideWidth
	$o register_option -height slideHeight
	$o register_option -prefix urlPrefix
    	$o register_option -module module required
    	$o register_option -archive archive
    	$o register_option -ltsend ltsEnd
}

MatApplication instproc init_resources o {
	$self next $o

	$o add_default slideDir .
	$o add_default slideOutputFile slides.mat
	$o add_default ltsEnd 10000
    	$o add_default archive archive
	$o add_default slideWidth 640
        $o add_default slideHeight 480
        $o add_default urlPrefix file:
    	$o add_default audioSpec 224.2.3.4/9822
    	$o add_default videoSpec 224.2.3.5/9832
    	$o add_default mbSpec 224.2.3.6/9842
	$o add_default loopback 1
}

MatApplication instproc init_ui {} {
	$self instvar ui_
	set ui_ [new MatUI]
}

