# ui-timebrowser.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#   @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mb/ui-timebrowser.tcl,v 1.6 2002/02/03 04:27:17 lim Exp $

import VcrIcons

Class MBTimeBrowser -superclass MBWidget

# number of divisions in the slider
MBTimeBrowser set defaultNumSteps_ 100

# in seconds
MBTimeBrowser set defaultFrameTime_ 1

# in miliseconds
MBTimeBrowser set defaultRefreshTime_ 500

MBTimeBrowser instproc init {parent browseVarName} {
	$self instvar path_ slider_ stepSlider_ stepLabel_ timeLabel_ \
			pauseBut_ playBut_ sliderRange_ afterId_ revBut_
	$self set browseVarName_ $browseVarName
	set afterId_ 0
	set path_ [frame $parent.ts -relief raised -bd 2]

	set stepSlider_ [scale $path_.stepS -orient horizontal \
			-from 1000 -to 10 -width 10 \
			-showvalue 0 -command "$self update_steps"]
	$stepSlider_ set [MBTimeBrowser set defaultNumSteps_]

	set sliderRange_ [MBTimeBrowser set defaultNumSteps_]

	pack $stepSlider_ -side left -anchor s -pady 2
	set sliderRange_ 10000
	set slider_ [scale $path_.slider -orient horizontal -label Time \
			-from 0 -to $sliderRange_ -resolution 0.05 \
			-showvalue false -command "$self update_label"]

	#
	# We want slightly different semantics.  Instead of tracking
	# the time slider continuously, we just update it when the
	# button is released. (but we use updateTime to give feedback to the
        # user
	# E.g., it takes too long to do a fast-forward each time.
	#
        bind $slider_ <Button-1> "$self wait"
        bind $slider_ <Button-2> "$self wait"

	bind $slider_ <ButtonRelease-1> "$self move2time"
	bind $slider_ <ButtonRelease-2> "$self move2time"

        pack $slider_ -side left -fill x -expand 1

	set timeLabel_ [label $path_.timeL -relief sunken]
	set pauseBut_ [button $path_.pauseB -image VcrIcons(pause) \
			-command "$self pause"]
	set playBut_ [button $path_.playB -image VcrIcons(play) \
			-command "$self play"]
	set revBut_ [button $path_.revB -image VcrIcons(reverse) \
			-command "$self reverse"]
	set stopBut_ [button $path_.stopB -image VcrIcons(stop) \
			-command "$self stop"]
	pack $pauseBut_ $revBut_ $playBut_ $stopBut_ \
			-side left -fill x -anchor s -padx 2 -pady 4
	$self set frameTime_ [MBTimeBrowser set defaultFrameTime_]
	$self set refreshTime_ [MBTimeBrowser set defaultRefreshTime_]
	$self set running_ 0
	$self set shouldResume_ 0
}

MBTimeBrowser instproc format_time {time {prefix {}}} {
	set result [clock format [expr {int($time)}] -format "%%s %I:%M:%S.%%d %p"]
	set frac [expr {int(($time - int($time))*10)}]
	return [format $result $prefix $frac]
}

MBTimeBrowser instproc min_time {time} {
	$self set mintime_ $time
}

MBTimeBrowser instproc max_time {time} {
	$self set maxtime_ $time
}

MBTimeBrowser instproc update_callBack {cmd} {
	$self set updateCallBack_ $cmd
}

MBTimeBrowser instproc stop_callBack {cmd} {
	$self set stopCallBack_ $cmd
}

MBTimeBrowser instproc update_slider {time} {
	$self instvar mintime_ maxtime_ slider_ sliderRange_
	set x [expr {($time - $mintime_)*$sliderRange_/($maxtime_-$mintime_)}]
	$slider_ set $x
	$self update_label $x
}

MBTimeBrowser instproc update_steps {step} {
 puts "update_steps $step"
	$self instvar stepSlider_ mintime_ maxtime_ frameTime_ \
			currTime_ slider_
	set dir [expr {($frameTime_ < 0) ? -1 : 1}]
	if {[info exists mintime_] && [info exists maxtime_]} {
		set frameTime [expr {($maxtime_ - $mintime_)/$step}]
		$stepSlider_ configure -label \
				[format "Step: %.2g s" $frameTime]
		set frameTime_ [expr {($frameTime_<0) ? -1*$frameTime : $frameTime}]
		puts "frametime_ set to $frameTime_, step to $step"
	}
}

MBTimeBrowser instproc goto {time} {
	$self instvar maxtime_ mintime_
	$self instvar mintime_ maxtime_ slider_ currTime_
	$self set currTime_ $time
	$self update_slider $time
}

MBTimeBrowser instproc set_time {newtime} {
	$self instvar updateCallBack_
	$self set currTime_ $newtime
	eval $updateCallBack_ $newtime
}

MBTimeBrowser instproc update_label {x} {
	$self instvar slider_ mintime_ maxtime_ sliderRange_
	set newtime [expr {$mintime_+($x/$sliderRange_)*($maxtime_-$mintime_)}]
#	puts "newtime: $newtime min:$mintime_ max:$maxtime_ x:$x"
	$slider_ configure -label \
			[$self format_time $newtime "Displayed Time:"]
}

MBTimeBrowser instproc move2time {} {
	$self instvar slider_ mintime_ maxtime_ shouldResume_ sliderRange_
	set x [$slider_ get]
	set newtime [expr {$mintime_ + ($x/$sliderRange_)*($maxtime_-$mintime_)}]
	$self set_time $newtime
	if $shouldResume_ {
                $self nextFrame
        }
}

MBTimeBrowser instproc nextFrame {} {
	$self instvar currTime_ frameTime_ refreshTime_ running_ afterId_ \
			mintime_ maxtime_
	if {!$running_} {
		return
	}
	set newTime [expr {$currTime_ + $frameTime_}]
	if {$newTime > $maxtime_ || $newTime < $mintime_} {
 puts "stop running: min:$mintime_ max:$maxtime_ new:$newTime"
		$self set running_ 0
	}
	$self update_slider $newTime
	$self set_time $newTime
	if {$running_} {
		set afterId_ [after $refreshTime_ "$self nextFrame"]
	}
}

MBTimeBrowser instproc play {} {
	$self instvar frameTime_ currTime_ mintime_
	$self set running_ 1
	if {$frameTime_ < 0} {
		set frameTime_ [expr {$frameTime_ * -1}]
	}
	if {$currTime_ < $mintime_} {
		set currTime_ $mintime_
	}
	$self nextFrame
}

MBTimeBrowser instproc reverse {} {
	$self set running_ 1
	$self instvar frameTime_ currTime_ maxtime_
	if {$frameTime_ > 0} {
		set frameTime_ [expr {$frameTime_ * -1}]
	}
	if {$currTime_ > $maxtime_} {
		set currTime_ $maxtime_
	}
	$self nextFrame
}

MBTimeBrowser instproc pause {} {
	$self set running_ 0
}

MBTimeBrowser instproc wait {} {
	set shouldResume_ [$self set running_]
	$self set running_ 0
}

MBTimeBrowser instproc stop {} {
	$self set running_ 0
	eval [$self set stopCallBack_]
}
