# agent-megafor.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/megafor/agent-megafor.tcl,v 1.22 2002/02/03 04:27:42 lim Exp $

import AnnounceListenManager/AS MeGa AnnounceListenManager/AS/SSG SDPParser

# FIXME This file still needs restructuring
# Agent class for the megafor application, which allows clients without multicast to connect to AS1
# Author:  Elan Amir
# Status: alpha
Class MeGaForAgent

MeGaForAgent instproc init { } {
	$self next
	$self instvar gwal_ cliental_ clientnets_ conf_ sdp_
	set sdp_ [new SDPParser]

	set f  [$self get_option megaConfFile]
	set bw [$self get_option asCtrlBW]
	if { [file exists $f] } {
		$self parse_conffile $f
		set megaspec $conf_(gwctrl)
	} else {
		set megaspec [$self get_option asCtrl]
	}
	$self instvar gwal_ cliental_ altype_
	# Each type of established service has a separate control channel port.
	# Others use the generic -megactrl port.  We create these gateways so
	# that messages from established servents will be available for
	# forwarding to clients
	foreach m { generic audio video sdp mb  } {
		set spec [MeGa ctrlchan $m $megaspec]
		set al [new AnnounceListenManager/AS/SSG $self $spec $bw]
		set altype_($al) gw
		set gwal_($m) $al
		#$al start 0
	}

	if [info exists conf_(clientctrl)] {
		set clientctrl $conf_(clientctrl)
		foreach m { generic audio video sdp mb } {
			set spec [MeGa ctrlchan $m $clientctrl]
			set bw $conf_($m,bw)
			set al [new AnnounceListenManager/AS/SSG \
					$self $spec $bw]
			set altype_($al) client
			set cliental_($m) $al
			#$al start 0
		}
	} else {
		# FIXME
		set port [$self get_option defaultSSGPort]
		set al [new AnnounceListenManager/AS/SSG $self $port $bw]
		set altype_($al) client
	}

}

MeGaForAgent instproc parse_conffile { f } {
	set fd [open $f r]
	if { $fd < 0 } {
		return
	}
	$self instvar conf_ app_
	while { [gets $fd line] > 0 } {
		set kw [lindex $line 0]
		switch $kw {
		link {
			$self add_option link yes
			set conf_(gwctrl) [lindex $line 1]
			set conf_(clientctrl) [lindex $line 2]
		}
		leaf {
			set conf_(gwctrl) [lindex $line 1]
		}
		media {
			set mtype [lindex $line 1]
			set conf_($mtype,bw) [lindex $line 2]
			set conf_($mtype,ofmt) [lindex $line 3]
		}}
	}
	close $fd
}

# This method added by Angie so that we don't have to sdp parse
# messages in order to find out what media type, and therefor port
# mapping they should be on.  The whole concept of different port
# numbers for different services needs to be rethought.

MeGaForAgent private port_mapping {srv_loc} {

    # FIXME hack!  This only works if srv_loc is urn:something
    set ind [string first : $srv_loc]
    set servent [string range $srv_loc [incr ind] end]
    puts "SERVENT $servent"
    switch $servent {
	vgw {
	    return video
	}
	agw {
	    return audio
	}
	mbgw {
	    return mb
	}
	sdgw {
	    return sdp
	}
	default {
	    return generic
	}
    }
}


#
MeGaForAgent instproc recv_msg { al atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar gwal_ cliental_ clientnets_  msgq_ altype_

	set o "ASCP v[AnnounceListenManager/AS version]"
	set n $atype
	set o $o\n$n
	set n $aspec
	set o $o\n$n
	set n $srv_name
	set o $o\n$n
	set n $srv_loc
	set o $o\n$n
	set n $srv_inst
	set o $o\n$n
	set n $ssg_port
	set o $o\n$n
	set n $msg
	set o $o\n$n


	if { $altype_($al) == "client" } {
		# FIXME Forward all client-side announcements

		if ![info exists clientnets_($aspec:$srv_loc)] {
			set spec $addr/$ssg_port:0/1
			puts "^^^^^^^^^^^^^^^ creating an ALM for $spec"
			# set bw [$msg attr_value linkbw]
			# FIXME
			set bw [expr 0.05*128000]
			set cnet [new AnnounceListenManager/AS/SSG \
					$self $spec $bw $srv_inst]
			#$cnet start 0
			set clientnets_($aspec:$srv_loc) $cnet
		}
		# FIXME this only works if srv_loc is urn:something !
		set mtype [$self port_mapping $srv_loc]
		$self instvar gwal_
		$gwal_($mtype) announce $o
	} else {
		# Gateway-side announcements
		set cnets [array names clientnets_]
		foreach cspec $cnets {
			set cnet $clientnets_($cspec)
			if { $srv_inst == [$cnet set srv_inst_] } {
				# Client has expressed interest in this
				# session - queue the message text.
				$cnet enqueue $aspec:$srv_loc $o
			}
		}
	}

}

MeGaForAgent instproc unregister { aspec } {
	$self instvar clientnets_
	if [info exists clientnets_($aspec)] {
		set cnet $clientnets_($aspec)
		delete $cnet
		unset clientnets_($aspec)
	} else {
		# A gateway got unregistered -- notify all the client handlers
		set cnets [array names clientnets_]
		foreach cspec $cnets {
			set cnet $clientnets_($cspec)
			$cnet remove_agent $aspec
		}
	}
}

MeGaForAgent instproc destroy {} {
	$self instvar gwal_ cliental_ clientnets_
	foreach m { generic sdp video audio mb } {
		delete $gwal_($m)
		delete $cliental_($m)
	}
	set aspecs [array names clientnets_]
	foreach aspec $aspecs {
		delete $clientnets_($aspec)
	}

	$self next
}
