# ui-vic.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/msp/ui-vic.tcl,v 1.30 2002/02/03 04:28:01 lim Exp $


import VicUI VatUI AddressBlock VideoAgent VideoPipeline CoordinationBus Session/Scuba/Vic VideoHandler



## The video component of the user interface for the MSP (mash streaming
# player).  This should eventually go away when Cyndi's UI components
# can be used instead.
# Status: alpha
# Author: Suchitra Raman
MSP_Application instproc start_vic argv {


	#$self init_args
	#$self init_vic_fonts
	#set argv [$self parse_args $argv]
	set o [$self options]
	$self init_args $o
	$self init_vic_fonts
        set argv [$o parse_args $argv]
	$self parse_hostspec $argv
	$self init_local
	$self init_confbus
	# Backward compat. -B flag is kb/s.
	set t [$self get_option maxbw]
	if { $t > 0 } {
		$self add_option maxbw [expr 1000*$t]
	}

	if { [$self get_option audioSessionSpec] != "" } {
		option add Msp.geometry 400x620 startupFile
	}
	$self instvar vic_ handler_
	set spec [$self get_option defaultHostSpec]
	set pspec [split $spec /]
	set mspec [lindex $pspec 0]/[lindex $pspec 1]/[lindex $pspec 3]
	set aspec [$self get_option audioSessionSpec]
	$self add_option videoSessionSpec $mspec
	if { $spec != "" } {
	    set temp [new AddressBlock $spec]
	    set temp2 [$temp set maxbw_(0)]
	    #FIXME need to do this to size the bandwidth slider in the GUI
	    $self add_option maxbw $temp2
	    $self add_option audioFormat PCM2
	}
	if { [$self get_option megaVideoSession] != "" } {
	    set spec ""
	    set aspec ""
	    #$self add_option megaAudioSession [$self get_option megaVideoSession]
	}

	set handler_ [new VideoHandler $spec "$self reset_video"]
	set vic_(agent) [$handler_ agent]
	set vic_(vpipe) [$handler_ vpipe]
	set vic_(ui) [$self init_vic_ui]
	if { [$self get_option useScuba] != "" } {
		set scuba_sess_ [$handler_ set scuba_sess_]
		$vic_(ui) set scuba_sess_ $scuba_sess_
	}
	set prefix [$self get_option iconPrefix]

	$self user_hook

}

#Data address has changed, so reset vic
MSP_Application instproc reset_vic argv {
	$self instvar vic_ handler_

	$self parse_hostspec $argv
	set spec [$self get_option defaultHostSpec]
        set pspec [split $spec /]
	set mspec [lindex $pspec 0]/[lindex $pspec 1]/[lindex $pspec 3]
        $self add_option videoSessionSpec $mspec
	if { [$self get_option megaVideoSession] != "" } {
	    $vic_(agent) reset_mega
	} else {
	    $vic_(agent) reset_spec $spec
	    $handler_ reset $spec
	}
}

#
MSP_Application instproc init_vic_ui {} {
	$self instvar vic_ ui_
        $self instvar local_chan_ glob_chan_

	set vic_(ui) [new VicUI $ui_(main).av.vic $local_chan_ $glob_chan_ $vic_(agent) $vic_(vpipe) "$self exit_vic" [$self get_option defaultHostSpec]]

	return $vic_(ui)
}

#
MSP_Application instproc exit_vic {} {
	$self instvar vic_
	$vic_(agent) shutdown
	exit 0
}


# Called from RTPAgent
MSP_Application instproc reset_video { ab } {
    $self instvar handler_

    if [info exists handler_] {
        $handler_ reset $ab
    }

}

#
MSP_Application private parse_hostspec { argv } {
	$self instvar name_
	if { $argv == "" } {
		if { [$self get_option defaultHostSpec] == "" && \
		     [$self get_option megaVideoSession] == "" } {
			puts stderr "$name_: destination address required"
			exit 1
		}
	} elseif { [llength $argv] > 1 } {
		set extra [lindex $argv 0]
		puts stderr "$name_: extra arguments (starting with $extra)"
		exit 1
	} else {
		$self add_option defaultHostSpec $argv
	}
}

#
MSP_Application instproc special_parse { arg } {
	switch -- $arg {
	-A {
		$self add_option sessionType $option
		set argv [lrange $argv 1 end]
		if { $option == "nv" } {
			$self add_default videoFormat nv
		} elseif { $option == "ivs" } {
			$self add_default videoFormat h.261
		}
	}
	-H {
		$self add_option useHardwareDecode true
	}
	-P {
		$self add_option privateColormap true
	}
	}

	$self next $arg
}

# This should go away
MSP_Application instproc init_vic_fonts2 {} {
	set foundry [$self get_option foundry]

	set helv10  [$self search_font $foundry helvetica medium 10 r]
	set helv10b [$self search_font $foundry helvetica bold 10 r]
	set helv10o [$self search_font $foundry helvetica bold 10 o]
	set helv12b [$self search_font $foundry helvetica bold 12 r]
	set times14 [$self search_font $foundry times medium 14 r]

	option add *Font $helv12b startupFile
	option add Msp.medfont $helv12b startupFile
	option add Msp.smallfont $helv10b startupFile
	option add Msp.helpFont $times14 startupFile

	# FIX THIS !!
       $self add_option smallfont $helv10b
	 $self add_option medfont $helv12b
	##

	# fonts used by audio widgets
	option add Msp.audioFont $helv10 startupFile
	option add Msp.ctrlTitleFont $helv12b startupFile
	option add Msp.ctrlFont $helv10b startupFile
	option add Msp.noAudioFont $helv10o startupFile
	option add Msp.siteFont $helv12b startupFile
}

#
MSP_Application instproc init_vic_fonts {} {
	set foundry [$self get_option foundry]

	set helv10  [$self search_font $foundry helvetica medium 10 r]
	set helv10b [$self search_font $foundry helvetica bold 10 r]
	set helv10o [$self search_font $foundry helvetica bold 10 o]
	set helv12b [$self search_font $foundry helvetica bold 12 r]
	set times14 [$self search_font $foundry times medium 14 r]

	option add *Font $helv12b startupFile


	$self add_option smallfont $helv10b
	$self add_option medfont $helv12b
	$self add_option helpFont $times14
	##

	# fonts used by audio widgets
	$self add_option audioFont $helv10
	$self add_option ctrlTitleFont $helv12b
	$self add_option ctrlFont $helv10b
	$self add_option noAudioFont $helv10o
	$self add_option siteFont $helv12b

	#option add Msp.audioFont $helv10 startupFile
	#option add Msp.ctrlTitleFont $helv12b startupFile
	#option add Msp.ctrlFont $helv10b startupFile
	#option add Msp.noAudioFont $helv10o startupFile
	#option add Msp.siteFont $helv12b startupFile
}

#
MSP_Application instproc init_confbus {} {
        $self instvar local_chan_ glob_chan_
        set local_chan_ [new CoordinationBus -channel 2]

        set ttl [$self get_option defaultTTL]
        set glob_chan_ [new CoordinationBus -channel 3 -ttl $ttl]
}

#Not used
MSP_Application instproc init_scuba {} {
	$self instvar vic_ scuba_sess_ al_

	set rtpsess [$vic_(agent) set session_]
	$rtpsess rtcp-thumbnail 1

	set spec [$self resource defaultHostSpec]
	if { $spec != "" } {
		set ab [new AddressBlock $spec]
	} else {
		set ab ""
	}
	set scuba_sess_ [new Session/Scuba/Vic $rtpsess $vic_(agent) $ab]
	if { $ab != "" } {
		delete $ab
	}

	$vic_(ui) set scuba_sess_ $scuba_sess_
	$vic_(agent) attach $scuba_sess_

	set localbw [$self get_option videoSessionBW]
	if { $localbw == "" } {
		set localbw [$self get_option maxVideoSessionBW]
	}
	$scuba_sess_ sessionbw $localbw
}

#
MSP_Application instproc clean-net {} {
	# Cleaning vic
	$self instvar vic_
	if [info exists vic_(agent)] {
		set srclist [$vic_(agent) set sources_]
		foreach s $srclist {
			delete $s
		}
	}
	if [info exists vic_(ui)] {
		$vic_(ui) clean_timers
		delete $vic_(ui)
	}
	Application set colormap_ ""
#	if [info exists vic_(agent)] {
#		set rtp_session [$vic_(agent) set session_]
#		delete $rtp_session
#	}
	#
	# Cleaning vat
	#
	$self instvar vat_
	if [info exists vat_(agent)] {
		set srclist [$vat_(agent) set sources_]
		foreach s $srclist {
			delete $s
		}
	}
	if [info exists vat_(ui)] {
		$vat_(ui) clean_timers
		delete $vat_(ui)
	}
	#if [info exists vat_(agent)] {
	#	$vat_(agent) release
	#	set rtp_session [$vat_(agent) set session_]
	#	set encoder [$vat_(agent) set encoder_]
	#	set ctrller [$vat_(agent) set controller_]
	#	delete $rtp_session
	#	delete $encoder
	#	delete $ctrller
	#}
}

