# address-block.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/net/address-block.tcl,v 1.24 2002/02/03 04:28:05 lim Exp $


import Configuration
import mashutils

Class AddressBlock -configuration {
	defaultTTL 1
	maxbw -1
}

Class AddressBlock/RTP -superclass AddressBlock
Class AddressBlock/Simple -superclass AddressBlock

# addr/port[:port]/fmt/ttl/layercnt
AddressBlock instproc init spec {
	$self next
	$self set nchan_ 0
	foreach s [split $spec ,] {
		set err [$self parse $s]
		#FIXME fatal exit on error --- callee should handle
		if { $err != "" } {
			$self fatal $err
		}
	}
}

#FIXME assume RTP rules about ports
AddressBlock instproc data-port p {
	return [expr $p &~ 1]
}

AddressBlock instproc fmt {} {
	$self instvar fmt_
	if [info exists fmt_] { return $fmt_ } else { return "" }
}

AddressBlock instproc ctrl-port p {
	return [expr [$self data-port $p] + 1]
}

AddressBlock instproc addr {{k 0}} {
	return [$self set addr_($k)]
}

AddressBlock instproc sport {{k 0}} {
	return [$self set sport_($k)]
}

AddressBlock instproc rport {{k 0}} {
	return [$self set rport_($k)]
}

AddressBlock instproc ttl {{k 0}} {
	$self instvar ttl_
	if [info exists ttl_($k)] { return $ttl_($k) } else { return {} }
}

AddressBlock instproc nchan {} {
	return [$self set nchan_]
}

#
# FIXME fatal errors should be handled elsewhere
#
AddressBlock instproc parse s {
	set dst [split $s /]
	set n [llength $dst]
	if { $n < 2 } {
		return "must specify both address and port in the form addr/port ($s)"
	}
	set addr [lindex $dst 0]
	set ports [split [lindex $dst 1] :]
	set sport [lindex $ports 0]
	if { [llength $ports] == 1 } {
		set rport $sport
	} else {
		set rport [lindex $ports 1]
	}
	set firstchar [string index $addr 0]
	if [string match \[a-zA-Z\] $firstchar] {
		set s [gethostbyname $addr]
		if { $s == "" } {
			return "cannot lookup host name: $addr"
		}
		set addr $s
	}

	foreach port "$sport $rport" {
		if { ![string match \[0-9\]* $port] || $port >= 65536 } {
			$self fatal "illegal port '$port'"
		}
	}

	set ttl [$self get_option defaultTTL]

	set cnt 1
	if { $n >= 3 } {
		set fmt [lindex $dst 2]
		if { $n==3 && [regexp {^[0-9]+$} $fmt] } {
			# this is an integer field; it must be the ttl
			set ttl $fmt
			set fmt {}
		}

		if { $n >= 4 } {
			set ttl [lindex $dst 3]
			if { $n > 4 } {
				set cnt [lindex $dst 4]
				if { ![string match \[0-9\]* $cnt] ||
				     $cnt >= 20 } {
					return "$dst: bad layered addr count"
					exit 1
				}
				if { $n > 5 } {
					return "$dst: malformed address"
				}
			}
		}
	}
	if { $ttl < 0 || $ttl > 255 } {
		return "$dst: invalid ttl ($ttl)"
	}

	set oct [split $addr .]
	set base [lindex $oct 0].[lindex $oct 1].[lindex $oct 2]
	set off [lindex $oct 3]

	$self instvar addr_ sport_ rport_ ttl_ nchan_

	set i 0
	while { $i < $cnt } {
		set sp [$self data-port $sport]
		set rp [$self data-port $rport]

		set addr_($nchan_) $base.$off
		set sport_($nchan_) $sp
		set rport_($nchan_) $rp
		set ttl_($nchan_) $ttl

		if [in_multicast $addr] {
			#FIXME need to handle carry!
			incr off
		}
		incr sport 2
		incr rport 2
		incr i
		incr nchan_
	}

	#FIXME this only works right for single layer case!
	#FIXME this goes elsewhere anyway

	if { [info exists fmt] && $fmt != "" } {
		$self set fmt_ $fmt
	#	$self add_option videoFormat $fmt
	#	#FIXME compat with vat
	#	$self add_option audioFormat $fmt
	}

	####FIXME resetting the format for the whole app here seems really bad
	#### the addr block could be for mega or some other non-data addr

	###if { [info exists fmt] && $fmt != "" && $fmt != "1" } {
	###	$self add_option videoFormat $fmt
	###	#FIXME compat with vat
	###	$self add_option audioFormat $fmt
	###}

	if [info exists confid] {
		$self add_option confid $confid
	}
	if [info exists ttl] {
		$self add_option defaultTTL $ttl
	}
	#FIXME
	$self bandwidth_heuristic
}

AddressBlock instproc bandwidth_heuristic {} {
	#
	# if the max bandwidth wasn't set, pick one based on the
	# session ttls.  Then use the max bandwidth to compute the
	# fraction allocated to rtcp (control) traffic.  We have
	# to do this before creating the session manager since it
	# will use the result to compute a time to the first report.
	# bw is in kbits/sec and we want bytes/ms so we divide by 8.
	#
	$self instvar nchan_ addr_ ttl_ maxbw_
	set i 0
	while { $i < $nchan_ } {
		set maxbw [$self get_option maxbw]
		if { $maxbw <= 0 } {
			set ttl $ttl_($i)
			if { $ttl <= 16 || ![in_multicast $addr_($i)] } {
				set maxbw 10000000
			} elseif { $ttl <= 64 } {
				set maxbw 4000000
			} elseif  { $ttl <= 128 } {
				set maxbw 1000000
			} elseif { $ttl <= 192 } {
				set maxbw 128000
			} else {
				set maxbw 56000
			}
		}
		set maxbw_($i) $maxbw
		incr i
	}
}

AddressBlock/Simple instproc data-port p {
	return $p
}

AddressBlock/RTP instproc data-port p {
	return [expr $p &~ 1]
}
