# rtp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/net/rtp.tcl,v 1.19 2002/02/03 04:28:06 lim Exp $


#
# A simple OTcl class that provides helper methods for
# various RTP utility operations.
#
Class RTP

#
# A variant of the RTP helper class for video.  Because
# the payload type spaces for audio and video can overlap,
# we need to specialize this class.  (Note however that while
# no such overlap currently exists, this probably won't hold
# in the future as the static payload types get used up.)
#
Class RTP/Video -superclass RTP

#
# A variant of the RTP helper class for audio.  Because
# the payload type spaces for audio and video can overlap,
# we need to specialize this class.  (Note however that while
# no such overlap currently exists, this probably won't hold
# in the future as the static payload types get used up.)
#
Class RTP/Audio -superclass RTP

RTP private init {} {
	eval $self next
	$self instvar rtp_ptoa_
	set rtp_ptoa_(-1) ""
}

RTP/Audio set default_ptoa_(0) pcm
RTP/Audio set default_ptoa_(1) celp
RTP/Audio set default_ptoa_(2) g721
RTP/Audio set default_ptoa_(3) gsm
RTP/Audio set default_ptoa_(5) dvi
RTP/Audio set default_ptoa_(6) dvi
RTP/Audio set default_ptoa_(7) lpc
RTP/Audio set default_ptoa_(8) pcma
RTP/Audio set default_ptoa_(9) g722
RTP/Audio set default_ptoa_(10) lin16
RTP/Audio set default_ptoa_(11) lin16
RTP/Audio set default_ptoa_(14) mpa
RTP/Audio set default_ptoa_(15) g728

RTP/Video set default_ptoa_(21) pvh
RTP/Video set default_ptoa_(25) cellb
RTP/Video set default_ptoa_(26) jpeg
RTP/Video set default_ptoa_(27) cuseeme
RTP/Video set default_ptoa_(28) nv
RTP/Video set default_ptoa_(29) picw
RTP/Video set default_ptoa_(30) cpv
RTP/Video set default_ptoa_(31) h261
RTP/Video set default_ptoa_(32) mpeg
RTP/Video set default_ptoa_(33) mpegs
RTP/Video set default_ptoa_(42) h263+
RTP/Video set default_ptoa_(34) h263

RTP/Audio set default_ptoa_(126) mp3

#FIXME
RTP/Video set default_ptoa_(127) h261v1

#FIXME - The following is needed for psvp support. Should find some
#      way of doing this without coding it here.
RTP/Video set default_ptoa_(50) sc

RTP/Audio public init args {
	$self next
	#
	# Fill in the arrays that translates between RTP payload type
	# numbers and representative strings.  ``ptoa'' stands for
	# payload-type to ascii while ``atop'' stands for the converse.
	# We do this setup in th eaudio subclass rather than in the
	# RTP base class because the spec allows the audio and video
	# payload type numbers to overlap.  (Note that the current spec
	# does not include any such overlapping assignments because the
	# allocation is still sparse.)
	#
	$class instvar default_ptoa_
	$self instvar rtp_ptoa_ rtp_atop_
	foreach p [array names default_ptoa_] {
		$self add_mapping $p $default_ptoa_($p)
	}

	#FIXME this is done here rather than in the base class (RTP)
	# since we want it to happen after defaults are set
	foreach mapping [$self get_option rtpMap] {
		set l [split $mapping :]
		set pt [lindex $l 0]
		set fmt [lindex $l 1]
		$self add_mapping $pt $fmt
	}
}

RTP/Video public init args {
	$self next
	#
	# Fill in the arrays that translates between RTP payload type
	# numbers and representative strings.  ``ptoa'' stands for
	# payload-type to ascii while ``atop'' stands for the converse.
	# We do this setup in th eaudio subclass rather than in the
	# RTP base class because the spec allows the audio and video
	# payload type numbers to overlap.  (Note that the current spec
	# does not include any such overlapping assignments because the
	# allocation is still sparse.)
	#
	$class instvar default_ptoa_
	$self instvar rtp_ptoa_ rtp_atop_
        set rtp_ptoa_(-1) ""
	foreach p [array names default_ptoa_] {
		set rtp_ptoa_($p) $default_ptoa_($p)
		set rtp_atop_($default_ptoa_($p)) $p
	}

	#FIXME this is done here rather than in the base class (RTP)
	# since we want it to happen after defaults are set
	foreach mapping [$self get_option rtpMap] {
		set l [split $mapping :]
		set pt [lindex $l 0]
		set fmt [lindex $l 1]
		$self add_mapping $pt $fmt
	}

	#
	# Set up a table to map lower-case RTP format
	# names into the suffix of the class name
	# that encodes or decodes this type
	#
	$self instvar classmap_
	set classmap_(pvh) PVH
	set classmap_(h261) H261
	set classmap_(h261v1) H261v1
	set classmap_(nv) NV
	set classmap_(cellb) CellB
	set classmap_(jpeg) JPEG

        # H.263 changes
        set classmap_(h263+) H263+
        set classmap_(h263) H263

	# Experimental stuff for psvp

	set classmap_(sc) SC
}

#
# Return the suffix of the OTcl class name that
# supports the indicated RTP <i>format</i>.
# Assumes <i>format</i> is a well-known type.
#
RTP/Video public classmap type {
	$self instvar classmap_
	if [info exists classmap_($type)] {
		return $classmap_($type)
	}
	return "Null"
}

#
# Add a mapping from RTP payload type <i>pt</i> to the
# format <i>fmt</i>.  The association becomes visible in
# subsequent calls to the <i>rtp_type</i> and
# <i>rtp_fmt_number</i> methods.
#
RTP public add_mapping {pt fmt} {
	$self instvar rtp_ptoa_ rtp_atop_
	set rtp_ptoa_($pt) $fmt
	set rtp_atop_($fmt) $pt
}

#
# Return the format name that corresponds to the RTP payload
# format type number given by <i>pt</i>.
#
RTP public rtp_type pt {
	$self instvar rtp_ptoa_
	if [info exists rtp_ptoa_($pt)] {
		return $rtp_ptoa_($pt)
	} elseif { $pt < 0 }  {
		return ""
	} else {
		return fmt-$pt
	}
}

#
# Return the RTP payload type number of the RTP format name
# given by <i>fmt</i>.
#
RTP public rtp_fmt_number fmt {
	$self instvar rtp_atop_
	if [info exists rtp_atop_($fmt)] {
		return $rtp_atop_($fmt)
	} else {
		return -1
	}
}

#
# Return the RTP format name in current use by the
# RTP source object <i>src</i>.
#
RTP public rtp_format src {
	$self instvar rtp_ptoa_
	return [$self rtp_type [$src format]]
}

#
# Return true if the two strings provide more or less the
# same informational content
#
RTP instproc cname_redundant { name cname } {
	set ni [string first @ $name]
	if { $ni < 0 } {
		return 0
	}
	set ci [string first @ $cname]
	if { $ci < 0 } {
		return 0
	}
	if { [string compare \
		[string range $name 0 $ni] \
		[string range $cname 0 $ci]] == 0 } {
		return 1
	}
	return 0
}

#
# Return a good string indentifier for the RTP source
# object <i>src</i>.  Tries to use the most descriptive
# RTCP SDES information first (e.g., name before cname
# before raw ip address).
#
RTP public rtp_representation src {
	set fmt [$self rtp_format $src]
	set name [$src sdes name]
	set cname [$src sdes cname]
	set addr [$src addr]
	if { $name == "" } {
		if { $cname == "" } {
			set srcname $addr
			set srcinfo $addr/$fmt
		} else {
			set srcname $cname
			set srcinfo $addr/$fmt
		}
	} elseif [$self cname_redundant $name $cname] {
		set srcname $name
		set srcinfo $addr/$fmt
	} else {
		set srcname $name
		set srcinfo $cname/$fmt
	}

	return "{$srcname} {$srcinfo}"
}
