# agent-video-psvp.tcl --
#
#       This file contains the Video agent used by many psvp mechanisms.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import VideoAgent

Class PsvpVideoAgent -superclass VideoAgent

PsvpVideoAgent instproc init {spec} {
    eval $self next $self $spec;
    set local_src [$self local];
    if {$local_src != ""} {
	$local_src handler [new Module/VideoDecoder/Null];
    }
}

PsvpVideoAgent instproc get_source_by_id srcid {
    $self instvar sources_;

    if {$srcid == "*"} {
	foreach s $sources_ {
	    if {$s != [$self local]} {
		set d [$s handler];
		if {$d != ""} {
		    if {[$d info class] == "Module/VideoDecoder/Null"} {
			return $s;
		    }
		}
	    }
	}
    } else {
	foreach s $sources_ {
	    if {$srcid == [$s srcid]} {
		return $s;
	    }
	}
    }
    return "";
}

PsvpVideoAgent instproc delete_decoder decoder {
    $self instvar decoders_;

    set idx [lsearch $decoders_ $decoder];
    if {$idx == -1} {
	return;
    }

    set src [$decoder set src_];

    lreplace $decoders_ $idx $idx "";

    set null_decoder [$self create_decoder $src];

    $src handler $null_decoder;
    lappend decoders_ $null_decoder;
}

PsvpVideoAgent instproc set_create_decoder_callback {srcid cmd} {
    $self instvar callbacks_;

    set callbacks_($srcid) $cmd;
}

PsvpVideoAgent instproc set_src_decoder {src decoder} {
    $self instvar decoders_ sources_;

    if {[lsearch $sources_ $src] == -1} {
	return;
    }

    $decoder set agent_ $self;
    $decoder set src_ $src;

    set old_decoder [$src handler];

    if {$old_decoder != ""} {
	delete $old_decoder;
	set idx [lsearch $decoders_ $old_decoder];
	if {$idx != -1} {
	    set decoders_ [lreplace $decoders_ $idx $idx];
	}
    }

    $src handler $decoder;

    lappend decoders_ $decoder;

}

PsvpVideoAgent instproc create_decoder src {
    $self instvar callbacks_;
    set d [$src handler];
    if {$d != ""} {
	delete $d
    }

    set id [$src srcid];

    if {![info exists callbacks_($id)]} {
	if {[info exists callbacks_(*)]} {
	    set decoder [eval $callbacks_(*) $src];
	    unset callbacks_(*);
	} else {
	    set decoder [new Module/VideoDecoder/Null];
	}
    } else {
	set decoder [eval $callbacks_($id) $src];
	unset callbacks_($id);
    }

    $decoder set agent_ $self;
    $decoder set src_ $src;

    return $decoder;
}
