# sc-to-byte.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram

Class SCToByteTestSubprogram -superclass DaliSubprogram

SCToByteTestSubprogram instproc init {args} {
    eval $self next $args;

    # Set up inputs

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Semicompressed;
    set input_info_(i1,buffername) [new VidRep/Semicompressed];
    set input_info_(i1,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Uncompressed;
    set output_info_(o1,buffername) [new VidRep/Uncompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) JPEG;
    set output_info_(o1,vagent) "";

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    set parameter_id_list_ "";
}

SCToByteTestSubprogram instproc trigger {} {
    $self instvar input_info_;
    $self instvar output_info_;
    $self instvar init_done_;

    set in_frame $input_info_(i1,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	if {[$in_frame set w_] == 0} {
	    return;
	}
	$out_frame copy_geometry $in_frame;
	if {$output_info_(o1,format) == "JPEG"} {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 1;
	} else {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 2;
	}
	$out_frame allocate;
	set init_done_ 1;
    }

    set in_lum [$in_frame get_lum_name];
    set in_cr [$in_frame get_cr_name];
    set in_cb [$in_frame get_cb_name];

    set out_lum [$out_frame get_lum_name];
    set out_cr [$out_frame get_cr_name];
    set out_cb [$out_frame get_cb_name];


    sc_to_byte_with_bias $in_lum $out_lum 0;
    sc_to_byte_with_bias $in_cr $out_cr 1;
    sc_to_byte_with_bias $in_cb $out_cb 1;

    $out_frame set ts_ [$in_frame set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }
    $self send_completion_token;
}
