# fx_proc.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import GraphComm;
import RTPApplication

Class FXProcApp -superclass RTPApplication

FXProcApp instproc init args {

    $self next fx_proc;

    $self init_resources;

    [$self options] register_option -subprogram subprogram;
    [$self options] register_option -comm_id comm_id
    [$self options] register_option -cntrl_spec cntrl_spec;
    [$self options] register_option -reg_comm_spec reg_comm_spec

    eval [$self options] parse_args $args;

    set subprog_type [$self get_option subprogram];

    puts "Proc running on [exec hostname]";

    uplevel #0 import $subprog_type;

    $self instvar subprog_obj_;
    set subprog_obj_ [new $subprog_type [$self get_option comm_id] [$self get_option cntrl_spec]];

    if {[$self get_option reg_comm_spec] != ""} {
	$self instvar reg_comm_obj_;

	set reg_comm_obj_ [new GraphComm/RegComm [$self get_option comm_id] [$self get_option reg_comm_spec] [$self get_option cntrl_spec]];
    }
}

FXProcApp instproc init_resources {} {
    $self add_option network ip
    $self add_option mtu 1024
    $self add_option defaultTTL 32
    $self add_option sessionType rtpv2

    # Set up default cntrl_spec and comm_id

    set hname [exec hostname];
    set hname [split $hname .];
    set hname [string trim [lindex $hname 0]];

    $self add_option comm_id $hname;

    set hnum [string range $hname 1 end];
    $self add_option cntrl_spec 224.5.8.${hnum}/22334/16
    $self add_option maxVideoSessionBW 30000000
    $self add_option subprogram WhirlpoolSubprogram
    $self add_option reg_comm_spec "";
}

FXProcApp instproc remote_exit {} {
    exit;
}

Class GraphComm/RegComm -superclass GraphComm;

GraphComm/RegComm instproc init {id reg_spec cntrl_spec} {

    set reg_spec [split $reg_spec "/"];

    set addr [lindex $reg_spec 0];
    set port [lindex $reg_spec 1];
    set ttl [lindex $reg_spec 2];

    $self next $id $addr $port $ttl

    $self instvar sess_map_ primary_sess_;

    set sess_map_($primary_sess_,inputs) 0;
    set sess_map_($primary_sess_,outputs) 0;
    set sess_map_($primary_sess_,parameters) 0;
    set sess_map_($primary_sess_,trigger_cmds) 0;
    set sess_map_($primary_sess_,map_cmds) 0;
    set sess_map_($primary_sess_,misc) 0;

    $self send_misc [list add_subgraph $cntrl_spec];
}

set app [new FXProcApp $argv];

#if {![info exists tk_version]} {
#    vwait forever;
#}

