# avswitch-knoxRS8x8.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/serial/avswitch-knoxRS8x8.tcl,v 1.14 2002/02/03 04:29:47 lim Exp $


import SerialChannel

#
# The extension of SerialChannel specialized to the Knox RS8x8
# Audio/Video Routing Switcher.
#
# the hard-coded wait times (in "after" calls) need to be long
# "enough"; the values are based on my experience, not any spec
# or logical reason....
#
Class SerialChannel/AVSwitch-Knox-RS8x8 -superclass SerialChannel

#
# init and open switch
#
SerialChannel/AVSwitch-Knox-RS8x8 public init { args } {
    eval [list $self] next $args

    $self instvar videoSettings_ audioSettings_ parse_pending_

    set parse_pending_ -1
    $self clear_settings
    $self device "/dev/cuac04"
    $self stopBits 2
    $self parity none
    $self open
    after 3000 $self refresh_settings
}

#
# clear audio and video settings
#
SerialChannel/AVSwitch-Knox-RS8x8 private clear_settings {} {
    $self instvar videoSettings_ audioSettings_

    for {set i 1} {$i < 9} {incr i} {
	set videoSettings_($i) 0
	set audioSettings_($i) 0
    }
}

#
# parse reply and set audioSettings_ and videoSettings_ based on
# it.  If reply is incomplete (parse attempted in mid-reply), it
# will automatically be rescheduled.
#
SerialChannel/AVSwitch-Knox-RS8x8 private parse_reply {} {
    $self instvar audioSettings_ videoSettings_ parse_pending_
    puts "parsing reply..."

    set reply [$self getReply_ascii]

    set i [string first "OUTPUT  1" $reply]
    if {$i == -1} {
	puts "error parsing reply: '$reply'"
        return -1
    }
    # okay, have a bit of it, do we have the whole thing?
    set j [string first "OUTPUT  8" $reply]
    if {$j == -1} {
	#puts "only partial reply available: rescheduling parse..."
	$self schedule_parse_reply 1500
        return -1
    }
    $self clear_settings

    set canonReply [string range $reply $i [expr [string length $reply]-1]]

    set replyList [split $canonReply \n]
    foreach replyLine $replyList {
        #puts "replyLine: $replyLine"
        scan $replyLine " OUTPUT %d VIDEO %d AUDIO %d " outTmp vidTmp audTmp
        set audioSettings_($outTmp) $audTmp
        set videoSettings_($outTmp) $vidTmp
    }
    #for {set i 1} {$i < 9} {incr i} {
	#puts "v: $i: $videoSettings_($i)"
	#puts "a: $i: $audioSettings_($i)"
    #}

    $self clearReply
    set parse_pending_ -1
    return 0
}

#
# request the current settings from the switch, schedule a parse of them
#
SerialChannel/AVSwitch-Knox-RS8x8 public refresh_settings {} {
    $self instvar audioSettings_ videoSettings_

    $self clearReply
    $self send "d 0x0d"
    $self schedule_parse_reply 3000
}

#
# run the built-in "test LEDs" cycle.
#
SerialChannel/AVSwitch-Knox-RS8x8 public test_LEDs {} {

    $self send "t 0x0d"
}

#
# route both audio and video from to 'out' number from 'in' number
#
SerialChannel/AVSwitch-Knox-RS8x8 public route_both { out in } {

    $self send "b $out $in 0x0d"
    $self schedule_parse_reply 3000
}

#
# route only audio from to 'out' number from 'in' number and schedule parse
#
SerialChannel/AVSwitch-Knox-RS8x8 public route_audio { out in } {

    $self send "a $out $in 0x0d"
    $self schedule_parse_reply 3000
}

#
# route only video from to 'out' number from 'in' number, schedule parse
#
SerialChannel/AVSwitch-Knox-RS8x8 public route_video { out in } {

    $self send "v $out $in 0x0d"
    $self schedule_parse_reply 3000
}

SerialChannel/AVSwitch-Knox-RS8x8 private schedule_parse_reply { time } {
    $self instvar parse_pending_

    if {$parse_pending_ != -1} {
	#puts "rescheduling pending parse..."
	after cancel $parse_pending_
    }
    if {$time < 1000} {
	set time 1000
    }
    set parse_pending_ [after $time "$self parse_reply"]

}

#
# print matrix of audio and video settings
#
SerialChannel/AVSwitch-Knox-RS8x8 public print_status {} {
    $self instvar audioSettings_ videoSettings_

    puts ""
    puts "       Routing"
    puts "   1:2:3:4:5:6:7:8"
    for {set i 1} {$i <= 8} {incr i} {
	puts -nonewline "$i: "
	if {$audioSettings_($i) == $videoSettings_($i)} {
	    # just a "B"
	    $self put_letter "B" $audioSettings_($i)
	    puts ""
	} else {
	    # put a "V" and "A"
	    if {$audioSettings_($i) < $videoSettings_($i)} {
		$self put_letter "A" $audioSettings_($i)
		$self put_letter "V" \
			[expr $videoSettings_($i) - $audioSettings_($i)]
		puts ""
	    } else {
		$self put_letter "V" $videoSettings_($i)
		$self put_letter "A" \
			[expr $audioSettings_($i) - $videoSettings_($i)]
		puts ""
	    }
	}
    }
    puts ""
}

SerialChannel/AVSwitch-Knox-RS8x8 private put_letter {letter dist} {
    for {set j 1} {$j < $dist} {incr j} {
	puts -nonewline "  "
    }
    puts -nonewline "$letter "
}

