# ui-H261Transcoder.tcl --
#
#       Files relating to the UI for adding a bandwidth limiter transcoder.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Module/VideoEncoder/Pixel/H261 TopLevelWindow OutgoingSession

Class H261TranscoderAddrInput -superclass TopLevelWindow -configuration { }

H261TranscoderAddrInput instproc init { mainUI } {
    $self next .h261TranscoderInput
    $self instvar ui_ 
    set ui_ $mainUI
}

H261TranscoderAddrInput instproc build w {
    $self instvar ui_ 
    $self create-window $w "H261 Transcoder Info"
    wm withdraw $w

    global inputtedH261DestAddr inputtedH261MaxBW

    frame $w.top
    label $w.top.label -anchor w -text "Destination Address:"
    entry $w.top.entry -textvariable inputtedH261DestAddr -relief sunken
    grid $w.top.label $w.top.entry -stick news
    frame $w.middle
    label $w.middle.label -anchor w -text "Maximum Bandwidth(bps):"
    entry $w.middle.entry -textvariable inputtedH261MaxBW -relief sunken
    grid $w.middle.label $w.middle.entry -stick news
    frame $w.bottom
    button $w.bottom.ok -text "OK" -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self callNewH261Transcoder"
    button $w.bottom.cancel -text "Cancel" -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle"
    grid $w.bottom.ok $w.bottom.cancel -stick news
    pack $w.top $w.middle $w.bottom
}

H261TranscoderAddrInput instproc toggle { } {
    global inputtedH261DestAddr inputtedH261MaxBW
    set inputtedH261DestAddr ""
    set inputtedH261MaxBW ""
    $self next
}

H261TranscoderAddrInput instproc callNewH261Transcoder { } {
    $self instvar ui_
    global inputtedH261DestAddr inputtedH261MaxBW
    $ui_ newH261Session $inputtedH261DestAddr $inputtedH261MaxBW
    $self toggle
}

Class OutgoingH261 -superclass OutgoingSession

OutgoingH261 instproc init { osess maxBW auctionHouse addr } {
    $self instvar osess_ maxBW_ auctionHouse_ addr_
    $self setFormat "H261Transcoder"
    set osess_ $osess
    set maxBW_ $maxBW
    set auctionHouse_ $auctionHouse
    set addr_ $addr
}

OutgoingH261 instproc makeUI { w ui src rownum } {
    $self instvar transmitBoxes_ bufferPool_ osess_ auctionHouse_ addr_
    new OutgoingH261TransmitBox $w $src $addr_ $osess_ $auctionHouse_
}

Class OutgoingH261TransmitBox

OutgoingH261TransmitBox instproc init { w src addr osess auctionHouse} {
    $self instvar src_ addr_ auctionHouse_ renderer_
    global bandwidths
    set src_ $src
    set addr_ $addr
    set auctionHouse_ $auctionHouse

    set bufferPool [new BufferPool/RTP]
    $bufferPool srcid [$src srcid]

    set out_encoder [new Module/VideoEncoder/Pixel/H261]
    $out_encoder buffer-pool $bufferPool
    $out_encoder target $osess
    
    set renderer_ [new Module/Renderer/PipeRenderer]
    $renderer_ attach_encoder $out_encoder
    $renderer_ use_auction_house $auctionHouse_
    $renderer_ bandwidth_display $self
    [$src_ data-handler] attach $renderer_
    
# this makes the GUI for the H261 Transcoder

# priorities_ auction_houses_ sources_

    set f "helvetica -10 bold"

    set extra $w
    frame $extra.right
    frame $extra.right.top
    label $extra.right.top.prior -text "Priority" -width 10 -font $f
    scale $extra.right.top.priority -from 0 -to 100 -width 12 -orient horizontal -relief groove -command "$self set_priority"
    frame $extra.right.bottom
    label $extra.right.bottom.bw -text "Bandwidth" -width 10 -font $f
#    label $extra.right.bottom.currentbw -textvariable [$ui_ set bandwidths_($renderer)] -width 12 -font $f
    label $extra.right.bottom.currentbw -textvariable bandwidths($src_,$addr_) -width 3 -font $f
    label $extra.right.bottom.bwUnits -text "Kbps" -width 3 -font $f
    pack $extra.right.top.priority $extra.right.top.prior -side right
    pack $extra.right.bottom.bwUnits $extra.right.bottom.currentbw $extra.right.bottom.bw -side right
    pack $extra.right.bottom $extra.right.top -side bottom -anchor w
#    frame $extra.left
#    radiobutton $extra.left.1 -variable priorities_($src,$addr) -text "Speaker" -value 0 -command "$auction_houses_($addr) set_characteristic $src 0" -font $f -width 8
#    radiobutton $extra.left.2 -variable priorities_($src,$addr) -text "Audience" -value 1 -command "$auction_houses_($addr) set_characteristic $src 1" -font $f -width 8
#    radiobutton $extra.left.3 -variable priorities_($src,$addr) -text "Slides" -value 2 -command "$auction_houses_($addr) set_characteristic $src 2" -font $f -width 8
#    pack $extra.left.1 $extra.left.2 $extra.left.3 -side top
#    pack $extra.left $extra.right -side left
    pack $extra.right
#    pack $extra -side left
}

# this is a helper function to display the current bandwidth usage (get's called from C++)

OutgoingH261TransmitBox instproc change_bwUsage { x } {
    $self instvar src_ addr_
    global bandwidths
    set bandwidths($src_,$addr_) $x
}

# this is a helper function to set the priority (usage) of a given source (calls down to C++)
# not in use!!!
OutgoingH261TransmitBox instproc set_priority { x } {
    $self instvar auctionHouse_ renderer_
    $auctionHouse_ set_priority $renderer_ $x
}





