# application-sim.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application QMSim

Class QMSimApplication -superclass Application

QMSimApplication instproc init {argv} {
    $self next "sim"

    $self initArgs
    set options [$self options]
    # parse command line args
    $options parse_args $argv

    set spec [list]
    lappend spec [$options get_option logInDir]
    lappend spec [$options get_option historySize]
    lappend spec [$options get_option speakerThreshold]
    lappend spec [$options get_option audienceLeftThreshold]
    lappend spec [$options get_option audienceCenterThreshold]
    lappend spec [$options get_option audienceRightThreshold]
    lappend spec [$options get_option timeSlice]
    lappend spec [$options get_option switchThreshold]

    set sim_ [new QMSim $spec]
}

QMSimApplication instproc initArgs {} {
    set options [$self options]

    # register valid options
    $options register_option -lidir logInDir
    $options register_option -h historySize
    $options register_option -st speakerThreshold
    $options register_option -lt audienceLeftThreshold
    $options register_option -ct audienceCenterThreshold
    $options register_option -rt audienceRightThreshold
    $options register_option -slice timeSlice
    $options register_option -switchT switchThreshold

    # set up defaults
    $options add_default logInDir log
    $options add_default historySize 20
    $options add_default speakerThreshold 20
    $options add_default audienceLeftThreshold 20
    $options add_default audienceCenterThreshold 20
    $options add_default audienceRightThreshold 20
    $options add_default timeSlice 250
    $options add_default switchThreshold 10
}
