/*
 * getdata.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

struct FileHeader {
        char version[16];
        char protocol[8];
        char media[32];
        char cname[128];
        char name[128];

        u_int32_t start_sec;
        u_int32_t start_usec;
        u_int32_t end_sec;
        u_int32_t end_usec;

        u_int32_t privateLen;
};

struct RTPPrivateHdr {
	char email[128];
	char phone[64];
	char loc[256]; // geographical user location
	char tool[64]; // application or tool name
	u_int32_t scale;
	u_int32_t ssrc;
	u_int32_t ref_rtp;
	u_int32_t ref_tv_sec;
	u_int32_t ref_tv_usec;
};

struct RecordHdr {
	u_int len;
	u_char type;
	u_char d2;
};

struct rtphdr {
	u_int16_t rh_flags;	/* T:2 P:1 X:1 CC:4 M:1 PT:7 */
	u_int16_t rh_seqno;	/* sequence number */
	u_int32_t rh_ts;	/* media-specific time stamp */
	u_int32_t rh_ssrc;	/* synchronization src id */
	/* data sources follow per cc */
};

#define SKIP_BYTES 312
#define GETTIMEOFDAY_TO_NTP_OFFSET 2208988800UL

int main(int argc, char** argv)
{
  int x;
  int go = 0;
  int len;
  u_int16_t seqno;
  u_int16_t lastSeqno = 0;
  u_int16_t flags;
  u_int32_t ts;
  FILE* infile;
  char buf[1024];
  int start_sec;
  int start_usec;
  struct timeval val;

  struct FileHeader hdr;
  struct RTPPrivateHdr pHdr;
  struct RecordHdr rHdr;
  struct rtphdr* rtpHdrPtr;

  if(argc != 2)
  {
    printf("xxx <filename>");
    exit(1);
  }

  infile = fopen(argv[1], "r");

  fread(&hdr, sizeof(struct FileHeader), 1, infile);

  printf("name = %s\n", hdr.name);
  printf("cname = %s\n", hdr.cname);
  printf("protocol = %s\n", hdr.protocol);
  printf("version = %s\n", hdr.version);
  printf("media = %s\n", hdr.media);
  printf("start_sec = %u, start_usec = %u\n", ntohl(hdr.start_sec), ntohl(hdr.start_usec));
  printf("end_sec = %u, end_usec = %u\n", ntohl(hdr.end_sec), ntohl(hdr.end_usec));
  printf("privateLen = %u\n", ntohl(hdr.privateLen));

  if(sizeof(struct RTPPrivateHdr) != ntohl(hdr.privateLen))
  {
    fprintf(stderr, "Warning, sizeof(struct RTPPrivateHdr)=%u != privateLen=%u\n",
	    sizeof(struct RTPPrivateHdr), ntohl(hdr.privateLen));
    return(-1);
  }

  fread(&pHdr, ntohl(hdr.privateLen), 1, infile);

  // we are now at the start of the data packets
  go = 1;
  while(go)
  {
    x = fread(&rHdr, sizeof(struct RecordHdr), 1, infile);
    if(x > 0)
    {
      len = ntohl(rHdr.len);
//      printf("len = %u\ttype=0x%x\n", len, rHdr.type);
      fread(buf, len, 1, infile);
      rtpHdrPtr = (struct rtphdr*)buf;
      ts = ntohl(rtpHdrPtr->rh_ts);
      seqno = ntohs(rtpHdrPtr->rh_seqno);
      flags = ntohs(rtpHdrPtr->rh_flags);
      if(lastSeqno + 1 != seqno)
      {
//	printf("missed packet, lastSeqno=%u, seqno=%u\n", lastSeqno, seqno);
      }
      lastSeqno = seqno;

//    if(seqno == 22000)

      {
        printf("ts=%u\n", ts);
	printf("\tflags=0x%x\n", flags);
	printf("\tseqno=%u\n", seqno);
      }

    }
    else
    {
      go = 0;
    }
  }


  fclose(infile);

  return(0);
}

