# lights.tcl --
#
#       Allows you to control lights settings in 405
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

source ../lib/tcl/sleep.tcl

import Application 405Client

Class LightsApp -superclass {Application}

global g_app

LightsApp instproc init {} {
    $self instvar amx_

    set amx_ [new 405Client]

    $self initUI
}

LightsApp instproc initUI {} {
    global g_onOff
    global g_outputSource

    wm title . "405 Lights"
    wm minsize . 150 0

    frame .controls -borderwidth 3
    pack .controls -side top -fill x

    # this initializes the manual switching part
    $self initManualUI .controls

    # exit button
    button .exit -text "Exit" -command exit
    pack .exit -side bottom -pady 10
}

# send a "" if the parent is the root window
LightsApp private initManualUI { parent } {
    global g_setting

    lappend inputs [list "full" "Full On"]
    lappend inputs [list "overlay" "Overlay"]
#    lappend inputs [list "theater" "Theater"]
    lappend inputs [list "slide" "Slide"]
    lappend inputs [list "off" "Off"]

    frame $parent.manual -borderwidth 3 -relief sunken
    pack $parent.manual -side top -fill x

    frame $parent.manual.labelFrame
    pack $parent.manual.labelFrame -side top -fill x
    label $parent.manual.labelFrame.outputLabel -text "Setting"
    pack $parent.manual.labelFrame.outputLabel -side left

    foreach item $inputs {
	set name [lindex $item 0]
	set desc [lindex $item 1]
	frame $parent.manual.but$name
	pack $parent.manual.but$name -side top -fill x
	radiobutton $parent.manual.but$name.but -text "$desc" -variable g_setting -value "$name"
	pack $parent.manual.but$name.but -side left
    }

    set g_setting full

    button $parent.manual.switch -text "Set" -command "$self setLights"
    pack $parent.manual.switch -side top
}

LightsApp public setLights {} {
    global g_setting
    $self instvar amx_

    #puts stdout "g_setting is $g_setting"
    $amx_ lights_set $g_setting
}

# this is the main engine

set g_app [new LightsApp]

vwait forever
