# myamx.tcl --
#
#       A test script for testing amxd functionality
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Application DpClient

Class TesterApp -superclass {Application}

global verbose_

TesterApp instproc init {} {
    $self instvar amx_ devText_ chanText_ comText_ com_ dev_ chan_ str_ mon_

    if {[catch {new DpClient htsr.bmrc.berkeley.edu 6901} amx_]} {
	puts stderr "Fatal error:  could not connext to AMX server"
    }

#    set amx_ [new DpClient htsr.bmrc.berkeley.edu 6901]

    set com_ 0
    set dev_ 0
    set chan_ 0
    set str_ ""


    $self initUI
}

TesterApp instproc initUI {} {
    global verbose_
    $self instvar devText_ chanText_ comText_ strText_

    wm title . "myAmx"

    frame .entry
    pack .entry -side top -pady 10

    label .entry.commandLabel  -text "command"
    pack .entry.commandLabel -side left
    set comText_ [text .entry.commandText -width 4 -height 1]
    pack .entry.commandText -side left

    label .entry.deviceLabel  -text "device"
    pack .entry.deviceLabel -side left
    set devText_ [text .entry.deviceText -width 4 -height 1]
    pack .entry.deviceText -side left

    label .entry.channelLabel  -text "channel"
    pack .entry.channelLabel -side left
    set chanText_ [text .entry.channelText -width 4 -height 1]
    pack .entry.channelText -side left

    label .entry.stringLabel -text "string"
    pack .entry.stringLabel -side left
    set strText_ [text .entry.strText -width 25 -height 1]
    pack .entry.strText -side left

    frame .but
    pack .but -side top -pady 10

    button .but.send -text "send" -command "$self send_amx_simple"
    pack .but.send -side left
    button .but.send2 -text "send tagged" -command "$self send_amx_simple_tagged"
    pack .but.send2 -side left
    button .but.send3 -text "send str" -command "$self send_amx_string"
    pack .but.send3 -side left
    button .but.send4 -text "send id" -command "$self send_amx_id"
    pack .but.send4 -side left

    button .but.send5 -text "temp" -command "$self temp_func"
    pack .but.send5 -side left


    button .but.get -text "get" -command "$self print_amx"
    pack .but.get -side left

    button .but.empty -text "empty" -command "$self empty_buf"
    pack .but.empty -side left

    frame .monitor
    pack .monitor -side top -pady 10

    checkbutton .monitor.verbose -text "verbose" -variable verbose_
    set verbose_ 0
    pack .monitor.verbose -side left
    button .monitor.start -text "start monitor" -command "$self start_mon"
    pack .monitor.start -side left
    button .monitor.stop -text "stop monitor" -command "$self stop_mon"
    pack .monitor.stop -side left
    canvas .monitor.onOff -width 20 -height 20 -borderwidth 0 -highlightthickness 0
    pack .monitor.onOff
    .monitor.onOff create rect 5 5 16 16 -fill green

    # exit button
    button .exit -text "Exit" -command exit
    pack .exit -side bottom
}

# mode can be "quiet" or "verbose"
TesterApp public start_mon { {mode quiet} } {
    global verbose_
    $self instvar mon_

    if {$verbose_ == 1} {
	set mode "verbose"
    }

    $self empty_buf quiet
    set mon_ 1
    .monitor.onOff create rect 5 5 16 16 -fill red

    while {$mon_ == 1} {
	set retval [$self get_amx]
	if {[string compare $retval "{0}"] == 0} {
	    if {[string compare $mode "verbose"] == 0} {
		puts stdout "receive-AMX-command returns: $retval"
	    }
	} else {
	    puts stdout "receive-AMX-command returns: $retval"
	}
	$self sleep 500
    }
}

# this part simulates a sleep of time equal to the after parameter
TesterApp public sleep { time } {
    set x 0
    after $time {set x 1}
    vwait x
}

TesterApp public stop_mon {} {
    $self instvar mon_

    set mon_ 0
    .monitor.onOff create rect 5 5 16 16 -fill green
}

TesterApp public empty_buf { {mode quiet} } {
    global verbose_

    set retval [$self get_amx]

    if {$verbose_ == 1} {
	set mode "verbose"
    }

    while {[string compare $retval "{0}"] != 0} {
	if {[string compare $mode "verbose"] == 0} {
	    puts stdout "receive-AMX-command returns: $retval"
	}
	set retval [$self get_amx]
    }

    if {[string compare $mode "verbose"] == 0} {
	puts stdout "AMX buf empty"
    }
}

TesterApp public get_amx {} {
    $self instvar amx_

    set retval [$amx_ do receive-AMX-command]

    return $retval
}

TesterApp public print_amx {} {
    set retval [$self get_amx]
    puts stdout "receive-AMX-command returns: $retval"

    return $retval
}

TesterApp private get_values {} {
    $self instvar comText_ devText_ chanText_ strText_ com_ dev_ chan_ str_

    set comStr [$comText_ get 1.0 1.end]
    scan $comStr "%d" com_
#    puts stdout "com is $com_"

    set devStr [$devText_ get 1.0 1.end]
    scan $devStr "%d" dev_
#    puts stdout "dev is $dev_"

    set chanStr [$chanText_ get 1.0 1.end]
    scan $chanStr "%d" chan_
#    puts stdout "chan is $chan_"

    set str_ [$strText_ get 1.0 1.end]
#    puts stdout "str is $str_"
}

TesterApp public send_amx_simple {} {
    $self instvar amx_ dev_ chan_ com_

    $self get_values

    set retval [$amx_ do send-AMX-command $com_ $dev_ $chan_]

    puts stdout "send-AMX-command returns: $retval"
#    after 500
#    $self print_amx
}

TesterApp public send_amx_simple_tagged {} {
    $self instvar amx_ dev_ chan_ com_

    $self get_values

    set retval [$amx_ do send-AMX-command-tagged $com_ $dev_ $chan_ "fire32" 5 7]

    puts stdout "send-AMX-command-tagged returns: $retval"
#    after 500
#    $self print_amx
}

TesterApp public temp_func {} {
    $self instvar amx_ dev_ chan_ com_ str_

    $self get_values

    set val [binary format "acccac" "&" 4 3 1 "C" 0x76]

    puts stdout "val is $val"

    set retval [$amx_ do send-AMX-command-tagged 4 1 $val "slurp" 5 2]

#    puts stdout "send-AMX-command returns: $retval"
#    after 500
#    $self print_amx
}

TesterApp public send_amx_string {} {
    $self instvar amx_ dev_ chan_ com_ str_

    $self get_values

    set retval [$amx_ do send-AMX-command-tagged $com_ $dev_ $str_ "hello" 1 9]

    puts stdout "send-AMX-command returns: $retval"
#    after 500
#    $self print_amx
}

TesterApp public send_amx_id {} {
    $self instvar amx_ dev_ com_

    $self get_values

    set retval [$amx_ do send-AMX-command $com_ $dev_]

    puts stdout "send-AMX-command returns: $retval"
#    after 500
#    $self print_amx
}

set app [new TesterApp]

vwait forever
