# tester.tcl --
#
#       Test app to test accuracy of amxd control of cameras
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Application DpClient

Class TesterApp -superclass {Application}

TesterApp instproc init {} {
    $self instvar amx_

    set amx_ [new DpClient htsr.bmrc.berkeley.edu 6901]

    $self initUI

    puts stdout "returned from initUI"
}

TesterApp instproc initUI {} {
    $self instvar amx_

    puts stdout "in initUI"

    wm title . "tester"

    # make camera controls
    frame .top -borderwidth 3

    button .top.leftPush -text "Left - Push" -command "$amx_ do camera_startMove speaker left"
    button .top.leftRelease -text "Left - Release" -command "$amx_ do camera_stopMove speaker left"
     button .top.rightPush -text "Right - Push" -command "$amx_ do camera_startMove speaker right"
    button .top.rightRelease -text "Right - Release" -command "$amx_ do camera_stopMove speaker right"
    button .top.center -text "Center" -command "$amx_ do camera_center speaker"

    pack .top -side top

    # buttons
    pack .top.leftPush -side left
    pack .top.leftRelease -side left
    pack .top.center -side left
    pack .top.rightPush -side right
    pack .top.rightRelease -side right

    # scale entry
    $self instvar test_bar_
    button .testLeft -text "test" -command "$self do_test left"
    button .testRight -text "test" -command "$self do_test right"
    pack .testLeft -side top -side left
    pack .testRight -side top -side left
    set test_bar_ [scale .scale -from 0 -to 255 -length 256 -variable x -orient horizontal -label "Send camera command:" -showvalue true]
    pack .scale


    # exit button
    button .exit -text "Exit" -command exit
    pack .exit -side bottom

    button .get -text "Get" -command "$self print_amx"
    pack .get -side bottom
}

TesterApp public print_amx {} {
    $self instvar amx_

    set retval [$amx_ do receive-AMX-command]
    puts stdout $retval
}

TesterApp public do_test { dir } {
    $self instvar amx_ test_bar_


    set val [$test_bar_ get]
    set val [expr $val * 10]
    puts stdout "val is $val"
    $amx_ do test_func speaker $dir $val
}

set app [new TesterApp]

vwait forever
