/*
 * tgmb-app.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-app.h,v 1.6 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TGMB_APP_H
#define MASH_TGMB_APP_H


#include "tg-app.h"
#include "tgmb-defs.h"
#include "tgmb-prefs.h"
#include "tgmb-canv.h"
#include "tgmb-session.h"


#define	usrNetSelect            firstUserEvent-1
#define	usrTimeout              firstUserEvent-2
#define usrTGMBChunkReceived    firstUserEvent-3
#define usrTGMBBytesReceived    firstUserEvent-4
#define usrStartSession         firstUserEvent-5
#define usrStopSession          firstUserEvent-6
#define usrRefreshScreen        firstUserEvent-7
#define usrNewPage              firstUserEvent-8


#ifdef NDEBUG
#define assert(cond)
#else
#define assert(cond) ErrFatalDisplayIf(!(cond), "Assertion failed " __PRETTY_FUNCTION__)
#endif


class TGMB_Application : public TG_NetworkApplication {
public:
	TGMB_Application();
	~TGMB_Application();

	DWord Init();
	DWord Cleanup();
	Boolean HandleEvent(EventPtr evPtr);
	void JoinSession();

	inline TGMB_Preferences *Prefs() { return &prefs_; }
	inline TGMB_Canvas *Canvas() { return &canv_; }
	inline TGMB_Book *Book() { return &book_; }
	inline TGMB_Session *Session() { return &session_; }
	inline DmOpenRef ScratchDB() { return tmpDB_; }

	static void ErrorDialog(const CharPtr formatStr, ...)
		__attribute__ ((format (printf, 1, 2)));

        static inline TGMB_Application *Instance()
	{ return globalAppInstance_; }

private:
	void OpenTmpStorageDatabase();
	void ClearDatabase(DmOpenRef db);
	void CloseDatabases();

	TGMB_Preferences prefs_;
	TGMB_Canvas canv_;
	TGMB_Book book_;
	TGMB_Session session_;

	DmOpenRef tmpDB_;
	static TGMB_Application *globalAppInstance_;
};



class TGMB_AppHandlers {
public:
	static Boolean MainMenu_HandleEvent(Word menuitem, FormPtr frm);
	static Boolean EditMenu_HandleEvent(Word menuitem, FormPtr frm);
	static Boolean CanvasMenu_HandleEvent(Word menuitem, FormPtr frm);

	static Boolean StartupForm_HandleEvent(EventPtr evPtr);
	static Boolean PrefsForm_HandleEvent(EventPtr evPtr);
	static Boolean NewSessionForm_HandleEvent(EventPtr evPtr);
	static Boolean OptionsForm_HandleEvent(EventPtr evPtr);
	static Boolean Canvas_HandleEvent(EventPtr evPtr);
};


#endif /* #ifdef MASH_TGMB_APP_H */
