/*
 * tgmb-event.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "tgmb-app.h"
#include "tgmb-resource.h"
#include "win-2bit.h"
#include "callback.h"

typedef Boolean (*MenuEventHandlerPtr)(Word menuitem, FormPtr frm);


static struct FormHandler {
	Word id;
	FormEventHandlerPtr handler;
} frmHandlers[] = {
	{ Frm_StartupForm,    TGMB_AppHandlers::StartupForm_HandleEvent },
	{ Frm_PrefsForm,      TGMB_AppHandlers::PrefsForm_HandleEvent },
	{ Frm_NewSessionForm, TGMB_AppHandlers::NewSessionForm_HandleEvent },
	{ Frm_Canvas,         TGMB_AppHandlers::Canvas_HandleEvent },
	{ Frm_OptionsForm,    TGMB_AppHandlers::OptionsForm_HandleEvent },
};


static struct MenuHandler {
	Word id;
	MenuEventHandlerPtr handler;
} menuHandlers[] = {
	{ MainMenu,   TGMB_AppHandlers::MainMenu_HandleEvent },
	{ EditMenu,   TGMB_AppHandlers::EditMenu_HandleEvent },
	{ CanvasMenu, TGMB_AppHandlers::CanvasMenu_HandleEvent }
};


Boolean
TGMB_Application::HandleEvent(EventPtr evPtr)
{
	CALLBACK_PROLOGUE;
	FormPtr frm;
	Word    id;
	Boolean handled = false;

	switch (evPtr->eType) {
	case frmLoadEvent:
	{
		FormEventHandlerPtr handler;

		id = evPtr->data.frmLoad.formID;
		frm = FrmInitForm(id);
		FrmSetActiveForm(frm);

		handler = NULL;
		for (unsigned i=0;
		     i < sizeof(frmHandlers)/sizeof(FormHandler);
		     i++){
			if (id==frmHandlers[i].id) {
				handler = frmHandlers[i].handler;
				break;
			}
		}

		if (handler) FrmSetEventHandler(frm, handler);
		handled = true;
		break;
	}

	case menuEvent:
	{
		MenuEventHandlerPtr handler;

		frm = FrmGetActiveForm();
		id = frm->menuRscId;
		handler = NULL;
		for (unsigned i=0;
		     i < sizeof(menuHandlers)/sizeof(MenuHandler);
		     i++){
			if (id==menuHandlers[i].id) {
				handler = menuHandlers[i].handler;
				break;
			}
		}

		if (handler) {
			MenuEraseStatus(NULL);
			handled = (*handler)(evPtr->data.menu.itemID, frm);
		}

		break;
	}

	default:
		break;
	}

	if (handled==false) handled = session_.HandleEvent(evPtr);

	CALLBACK_EPILOGUE;
	return handled;
}


#if 0
void DrawStuff()
{
	WindowType *w = Win2_GetOnscreenWindow();
	/*TGMB_Application::ErrorDialog("window clip: %d %d %d %d",
				      w->clippingBounds.left,
				      w->clippingBounds.top,
				      w->clippingBounds.right,
				      w->clippingBounds.bottom);*/
	AbsRectType r = { 1, 1, 80, 80 };
	w->clippingBounds = r;
	/*WinDrawLine(0,0,150,150);
	WinDrawLine(0,60,150,60);
	WinDrawLine(0,0,80,150);*/
	Win2_Context cxt;
	cxt.window = w;
	cxt.width = 1;
	cxt.fill = 1;
	cxt.outlineClr = 0x00;
	cxt.fillClr = 0xFF;
	Win2_DrawRectangle(&cxt, 1, 1, 120, 120);
	cxt.fillClr = 0x80;
	cxt.width = 2;
	Win2_DrawLine(&cxt, 2, 20, 100, 20);
	Win2_DrawLine(&cxt, 2, 20, 100, 100);
	Win2_DrawLine(&cxt, 2, 100, 100, 20);
	Win2_DrawLine(&cxt, 50, 10, 80, 150);
	Win2_DrawLine(&cxt, 50, 150, 80, 10);

	Win2_DrawOval(&cxt, 10, 10, 130, 100);
	cxt.fillClr = 0x40;
	Win2_DrawOval(&cxt, 30, 10, 120, 150);
	cxt.fill = 0;
	cxt.width = 1;
	cxt.outlineClr = 0x80;
	Win2_DrawText(&cxt, -10, 10, "This is a much much much longer string");
	//Win2_DrawRectangle(&cxt, 10, 10, 130, 100);
}
#endif


Boolean
TGMB_AppHandlers::StartupForm_HandleEvent(EventPtr evPtr)
{
	CALLBACK_PROLOGUE;
	Boolean handled = false;
	FormPtr frm;

	switch (evPtr->eType) {
	case frmOpenEvent:
		frm = FrmGetActiveForm();
		FrmDrawForm(frm);
		handled = true;

		// we are opening up the startup form; check if the user name's
		// been set
		if (*TGMB_Application::Instance()->Prefs()->userName_=='\0') {
			TGMB_Application::ErrorDialog("You need to enter a "
						      "user name as part of "
						      "your preferences");
			FrmPopupForm(Frm_PrefsForm);
		}

		//DrawStuff();
		break;

	case ctlSelectEvent:
		switch(evPtr->data.ctlSelect.controlID) {
		case SF_JoinSessionBtn:
		{
			TGMB_Application::Instance()->JoinSession();
			handled = true;
			break;
		}
		default:
			break;
		}
		break;

	default:
		break;
	}
	CALLBACK_EPILOGUE;
	return handled;
}


Boolean
TGMB_AppHandlers::PrefsForm_HandleEvent(EventPtr evPtr)
{
	CALLBACK_PROLOGUE;
	FormPtr frm;
	Boolean handled = false;
	TGMB_Preferences *prefs = TGMB_Application::Instance()->Prefs();

	switch (evPtr->eType) {
	case frmOpenEvent:
		frm = FrmGetActiveForm();
		prefs->ToForm(frm);
		FrmDrawForm(frm);
		handled = true;
		break;

	case ctlSelectEvent:
		frm = FrmGetActiveForm();

		switch(evPtr->data.ctlSelect.controlID) {
		case PF_OkBtn:
			prefs->FromForm(frm);

			/* check if the username field is valid */
			if (*prefs->userName_=='\0') {
				TGMB_Application::
					ErrorDialog("You must specify "
						    "the user name");
				handled = true;
				break;
			}

			prefs->ToSystem();
			/* fall through */

		case PF_CancelBtn:
			FrmReturnToForm(0);
			handled = true;
			break;

		default:
			break;
		}
		break;

	default:
		break;
	}
	CALLBACK_EPILOGUE;
	return false;
}


Boolean
TGMB_AppHandlers::NewSessionForm_HandleEvent(EventPtr evPtr)
{
	CALLBACK_PROLOGUE;
	FormPtr frm;
	Boolean handled = false;

	switch (evPtr->eType) {
	case frmOpenEvent:
		frm = FrmGetActiveForm();
		TGMB_Application::Instance()->Session()->ToForm(frm);
		FrmDrawForm(frm);
		handled = true;
		break;

	case ctlSelectEvent:
		frm = FrmGetActiveForm();

		switch(evPtr->data.ctlSelect.controlID) {
		case NSF_StartBtn:
			TGMB_Application::Instance()->Session()->FromForm(frm);
			FrmReturnToForm(0);
			FrmGotoForm(Frm_Canvas);
			TG_AddUsrEventToQueue(usrStartSession, NULL, 0);

			handled = true;
			break;

		case NSF_CancelBtn:
			FrmReturnToForm(0);
			handled = true;
			break;

		default:
			break;
		}
		break;

	default:
		break;
	}

	CALLBACK_EPILOGUE;
	return handled;
}


Boolean
TGMB_AppHandlers::OptionsForm_HandleEvent(EventPtr evPtr)
{
	CALLBACK_PROLOGUE;
	FormPtr frm;
	Boolean handled = false;
	Word listId = 0;

	switch (evPtr->eType) {
	case frmOpenEvent:
		frm = FrmGetActiveForm();
		TGMB_Application::Instance()->Book()->Command()->ToForm(frm);
		FrmDrawForm(frm);
		handled = true;
		break;

	case ctlSelectEvent:
		switch(evPtr->data.ctlSelect.controlID) {
		case OF_OkBtn:
			frm = FrmGetActiveForm();
			TGMB_Application::Instance()->Book()->Command()->
				FromForm(frm);
			// fall thru

		case OF_CancelBtn:
			FrmReturnToForm(0);
			handled = true;
			break;

		case OF_NewPageBtn:
			FrmReturnToForm(0);
			TG_AddUsrEventToQueue(usrNewPage, NULL, 0);
			handled = true;
			break;

		case OF_WidthPopup: listId = OF_WidthList; break;
		case OF_ArrowPopup: listId = OF_ArrowList; break;
		case OF_OutlinePopup: listId = OF_OutlineList; break;
		case OF_FillPopup: listId = OF_FillList; break;

		default:
			break;
		}
		break;

	default:
		break;
	}

	if (listId!=0) {
		frm = FrmGetActiveForm();
		ListPtr list = (ListPtr) FrmGetObjectPtr(
			frm,FrmGetObjectIndex(frm, listId));
		ControlPtr popup = (ControlPtr)	FrmGetObjectPtr(
			frm, FrmGetObjectIndex(frm,evPtr->data.ctlSelect.
					       controlID));
		short selected = LstPopupList(list);
		if (selected != -1) {
			CharPtr selectedText =
				LstGetSelectionText(list,selected);
			CtlSetLabel(popup, selectedText);
			CtlDrawControl(popup);
		}
		handled = true;
	}

	CALLBACK_EPILOGUE;
	return handled;
}


Boolean
TGMB_AppHandlers::Canvas_HandleEvent(EventPtr evPtr)
{
	CALLBACK_PROLOGUE;
	FormPtr frm;
	Boolean handled=false;

	switch (evPtr->eType) {
	case frmOpenEvent:
		TGMB_Application::Instance()->Canvas()->
			Init(WinGetActiveWindow());
		frm = FrmGetActiveForm();
		FrmDrawForm(frm);
		break;

	case ctlSelectEvent:
		frm = FrmGetActiveForm();

		switch(evPtr->data.ctlSelect.controlID) {
		case CF_ToolPopup:
		{
			ListPtr toolList = (ListPtr)
				FrmGetObjectPtr(
					frm,FrmGetObjectIndex(frm,
							      CF_ToolList));
			ControlPtr toolPopup = (ControlPtr)
				FrmGetObjectPtr(
					frm, FrmGetObjectIndex(frm,
							       CF_ToolPopup));
			short selected = LstPopupList(toolList);
			if (selected != -1) {
				CharPtr selectedText =
					LstGetSelectionText(toolList,selected);
				CtlSetLabel(toolPopup, selectedText);
				CtlDrawControl(toolPopup);
				CanvObjType type = CanvObjType_Deleted;
				if (StrCompare(selectedText,"Draw")==0)
					type = CanvObjType_Line;
				else if (StrCompare(selectedText,"Arrow")==0)
					type = CanvObjType_Arrow;
				else if (StrCompare(selectedText,"Rect")==0)
					type = CanvObjType_Rect;
				else if (StrCompare(selectedText,"Oval")==0)
					type = CanvObjType_Oval;
				else if (StrCompare(selectedText,"Text")==0)
					type = CanvObjType_Text;
				if (type!=CanvObjType_Deleted) {
					TGMB_Application::Instance()->Book()->
						Command()->SwitchType(type);
				}
			}
			handled = true;
			break;
		}

		case CF_ZoomPopup:
		{
			ListPtr zoomList = (ListPtr)
				FrmGetObjectPtr(
					frm,FrmGetObjectIndex(frm,
							      CF_ZoomList));
			ControlPtr zoomPopup = (ControlPtr)
				FrmGetObjectPtr(
					frm, FrmGetObjectIndex(frm,
							       CF_ZoomPopup));
			short selected = LstPopupList(zoomList);
			if (selected != -1) {
				CharPtr selectedText =
					LstGetSelectionText(zoomList,selected);
				CtlSetLabel(zoomPopup, selectedText);
				CtlDrawControl(zoomPopup);

				char zoom[25];
				StrCopy(zoom, selectedText);
				zoom[StrLen(zoom)-1] = '\0';
				Long z = StrAToI(zoom);
				if (z > 0) {
					// since this was selected thru
					// a popup menu, the canvas is
					// going to refresh anyway, so don't
					// bother to refresh here
					TGMB_Application::Instance()->
						Session()->SwitchZoom(z, 0);
				}
			}
			handled = true;
			break;
		}

		case CF_Options:
		{
			FrmPopupForm(Frm_OptionsForm);
			handled = true;
			break;
		}

		case CF_PrevPage:
		{
			TGMB_Application::Instance()->Session()->
				SwitchPage(-1);
			handled = true;
			break;
		}

		case CF_NextPage:
		{
			TGMB_Application::Instance()->Session()->SwitchPage(1);
			handled = true;
			break;
		}

		default:
			break;
		}
		break;

	default:
		break;
	}

	if (handled==false)
		handled = TGMB_Application::Instance()->Canvas()->
			HandleEvent(evPtr);
	CALLBACK_EPILOGUE;
	return handled;
}


Boolean
TGMB_AppHandlers::MainMenu_HandleEvent(Word itemID, FormPtr /*frm*/)
{
    CALLBACK_PROLOGUE;
    Boolean handled = false;

    switch(itemID) {
    case MainMenu_NewSession:
	    TGMB_Application::Instance()->JoinSession();
	    handled = true;
	    break;

    case MainMenu_Prefs:
	    FrmPopupForm(Frm_PrefsForm);
	    handled = true;
	    break;

    case MainMenu_About:
	    handled = true;
	    break;
    }

    CALLBACK_EPILOGUE;
    return handled;
}


Boolean
TGMB_AppHandlers::EditMenu_HandleEvent(Word itemID, FormPtr frm)
{
	CALLBACK_PROLOGUE;
	Boolean handled = false;
	FieldPtr fld;

	switch(itemID) {
	case EditMenu_Undo:
		fld = TG_FrmGetFocusObjectPtr(frm);
		if (fld) {
			FldUndo(fld);
		}
		handled = true;
		break;

	case EditMenu_Cut:
		fld = TG_FrmGetFocusObjectPtr(frm);
		if (fld) {
			FieldAttrType fa;

			FldGetAttributes(fld, &fa);
			if (fa.editable) {
				FldCut(fld);
			} else {
				FldCopy(fld);
			}
		}
		handled = true;
		break;

	case EditMenu_Copy:
		fld = TG_FrmGetFocusObjectPtr(frm);
		if (fld) {
			FldCopy(fld);
		}
		handled = true;
		break;

	case EditMenu_Paste:
		fld = TG_FrmGetFocusObjectPtr(frm);
		if (fld) {
			FldPaste(fld);
		}
		handled = true;
		break;

	case EditMenu_SelectAll:
		fld = TG_FrmGetFocusObjectPtr(frm);
		if (fld) {
			FldSetSelection(fld, 0, FldGetTextLength(fld));
		}
		handled = true;
		break;

	case EditMenu_Keyboard:
		SysKeyboardDialog(kbdDefault);
		handled = true;
		break;

	case EditMenu_Graffiti:
		SysGraffitiReferenceDialog(referenceDefault);
		handled = true;
		break;
	}

	CALLBACK_EPILOGUE;
	return handled;
}


Boolean
TGMB_AppHandlers::CanvasMenu_HandleEvent(Word itemID, FormPtr /*frm*/)
{
	CALLBACK_PROLOGUE;
	Boolean handled=false;

	switch(itemID) {
	case CanvasMenu_QuitSession:
		TG_AddUsrEventToQueue(usrStopSession, NULL, 0);
		handled = true;
		break;

	case CanvasMenu_Reconnect:
		TGMB_Application::Instance()->Session()->Stop();
		TGMB_Application::Instance()->Session()->Start();
		handled = true;
		break;

	case CanvasMenu_Refresh:
		TG_AddUsrEventToQueue(usrRefreshScreen,NULL,0);
		handled = true;
		break;
	}

	CALLBACK_EPILOGUE;
	return false;
}
