/*
 * tgmb-sndr.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "tgmb-conn.h"
#include "tgmb-chunk.h"
#include "tgmb-mgr.h"
#include "tgmb-canv.h"


static void
get_coords(Point &p, void *&pCoords_void)
{
	u_char *pCoords = (u_char*)pCoords_void;
	u_int16_t tmp;

	memcpy(&tmp, pCoords, 2);
	tmp = ntohs(tmp);
	p.x = tmp;
	pCoords += 2;

	memcpy(&tmp, pCoords, 2);
	tmp = ntohs(tmp);
	p.y = tmp;
	pCoords += 2;

	pCoords_void = (void*) pCoords;
}


void
TCP_MediaPad::recv_data(u_int32_t requestId, u_char *data, u_int32_t len)
{
	ChunkFrag::Header hdrNet;
	ChunkFrag frag(NULL);
	PageId pgId, pgIdNet;

	memcpy(&pgIdNet, data, sizeof(PageId));
	net2host(pgIdNet, pgId);
	data += sizeof(PageId);
	len  -= sizeof(PageId);

	memcpy(&hdrNet, data, sizeof(ChunkFrag::Header));
	net2host(hdrNet, frag.hdr_);
	data += sizeof(ChunkFrag::Header);
	len  -= sizeof(ChunkFrag::Header);

	Page *pPage = (Page*) pRcvr_->DefinePage(pgId);
	if (!pPage) return;

	frag.data_ = data;

	/*TGMB_Manager::instance()->Invoke("get_canvas", PgId2Str(pgId), NULL);
	TGMB_Canvas *pCanv = (TGMB_Canvas*) tcl.lookup(tcl.result());*/
	TGMB_Canvas *pCanv = (TGMB_Canvas*) pPage->getCanvas();
	if (!pCanv) {
		// unknown page!
		return;
	}

	// set the request id for this request
	currRequestId_ = requestId;
	// defer all canvas notifications until we are done updating
	// the canvas
	pCanv->DeferUpdateNotification(TRUE);

	switch (frag.hdr_.cmd_) {
	case cmdCanvasCreate:
		create_item(&frag, pPage);
		break;
	}

	// "un-defer" canvas notifications; so all clients may be notified
	pCanv->DeferUpdateNotification(FALSE);
	currRequestId_ = 0;
	frag.data_ = NULL;
}


void
TCP_MediaPad::create_item(ChunkFrag *frag, Page *pPage)
{
	u_int16_t itemType, coordLen;
	u_int32_t timestamp;
	void *pCoords;
	if (frag->get(descrItemType, itemType)==FALSE) {
		// don't know the item type; ignore this packet
		return;
	}

	if (frag->get_any(descrCoords, pCoords, coordLen)==FALSE) {
		// can't locate coordinates for this item
		return;
	}

	if (frag->get(descrTimestamp, timestamp)==FALSE) {
		// can't locate timestamp for this item; create a local ts
		timestamp = TGMB_Manager::instance()->CurrTime();
	}

	switch (itemType) {
	case PgItemLine:
		create_line(frag, pPage, pCoords, coordLen/2, timestamp);
		break;

	case PgItemText:
		create_text(frag, pPage, pCoords, coordLen/2, timestamp);
		break;

	case PgItemRect:
	case PgItemOval:
		create_poly(frag, pPage, pCoords, coordLen/2, timestamp,
			    itemType);
		break;

	case PgItemImage:
	case PgItemPS:
	case PgItemMLine:
		break;

	default:
		break;
	}
}


void
TCP_MediaPad::create_line(ChunkFrag *frag, Page *pPage,
			  void *pCoords, u_int16_t numCoords,
			  u_int32_t timestamp)
{
	u_int16_t i;
	Point tmp;
	PageItem *pItem;
	u_int32_t snStart=0, snEnd=0;

	get_coords(tmp, pCoords);

	for (i=2; i<numCoords; i+=2) {
		// for each pair of coords, create a line segment
		pItem = PageItem::createItem(PgItemLine);
		frag->get_props(pItem);
		Point* aPoints=new Point[2];
		aPoints[0] = tmp;

		get_coords(tmp, pCoords);
		aPoints[1] = tmp;

		pItem->setPoints(aPoints, 2);
		snEnd = create_item(pPage, pItem, timestamp);
		if (snStart==0)
			snStart = snEnd;
	}

	if (snStart!=0 && snStart!=snEnd)
		create_group(pPage, PgItemMLine, snStart, snEnd, timestamp);
}


#ifdef NDEBUG
void
TCP_MediaPad::create_text(ChunkFrag *frag, Page *pPage,
			  void *pCoords, u_int16_t /* numCoords */,
			  u_int32_t timestamp)
#else
void
TCP_MediaPad::create_text(ChunkFrag *frag, Page *pPage,
			  void *pCoords, u_int16_t numCoords,
			  u_int32_t timestamp)
#endif
{
	TextItem *pItem;
	char *text, *ptr;
	u_int32_t snStart, snEnd;

	assert(numCoords==2);

	Point *aPoints = new Point[1];
	get_coords(aPoints[0], pCoords);

	pItem = new TextItem;
	frag->get_props(pItem);
	pItem->setPoints(aPoints, 1);

	text = pItem->szText_;
	::AllocNCopy(&pItem->szText_, "");
	snStart = snEnd = create_item(pPage, pItem, timestamp);

	for (ptr=text; *ptr!='\0'; ptr++) {
		snEnd = create_char_cmd(pPage, *ptr, snStart, ptr-text,
					timestamp);
	}

	create_group(pPage, PgItemText, snStart, snEnd, timestamp);
	delete [] text;
}


#ifdef NDEBUG
void
TCP_MediaPad::create_poly(ChunkFrag *frag, Page *pPage,
			  void *pCoords, u_int16_t /* numCoords */,
			  u_int32_t timestamp, u_int16_t itemType)
#else
void
TCP_MediaPad::create_poly(ChunkFrag *frag, Page *pPage,
			  void *pCoords, u_int16_t numCoords,
			  u_int32_t timestamp, u_int16_t itemType)
#endif
{
	PageItem *pItem;

	assert(numCoords==4);

	Point *aPoints = new Point[2];
	get_coords(aPoints[0], pCoords);
	get_coords(aPoints[1], pCoords);

	pItem = PageItem::createItem((PageItemType)itemType);
	frag->get_props(pItem);
	pItem->setPoints(aPoints, 2);

	create_item(pPage, pItem, timestamp);
}


u_int32_t
TCP_MediaPad::create_item(Page *pPage, PageItem *pItem,
			  u_int32_t timestamp)
{
	MBCmd* pCmd = new MBCmdCreate(timestamp, pItem);
	assert(pCmd);

	if (pRcvr_->Dispatch(pCmd, pPage)==MB_EXE_OK) {
		return (pCmd->getSeqno());
	}
	return 0;
}


u_int32_t
TCP_MediaPad::create_char_cmd(Page *pPage, char ch, u_int32_t cmdId,
			      u_int16_t index, u_int32_t timestamp)
{
	MBCmd* pCmd = new MBCmdChar(timestamp, cmdId, index, ch);

	if (!pCmd) {
		SignalError(("Out of memory"));
		return 0;
	}
	if (pRcvr_->Dispatch(pCmd, pPage)==MB_EXE_OK)
		return (pCmd->getSeqno());
	else return 0;
}


u_int32_t
TCP_MediaPad::create_group(Page* pPage, PageItemType type,
			   u_long snStart, u_long snEnd,
			   u_int32_t timestamp)
{
	MBCmd* pCmd = MBCmdGroup::Create(timestamp, type,
					 snStart, snEnd, NULL);
	if (!pCmd) {
		SignalError(("Out of memory"));
		return 0;
	}
	if (pRcvr_->Dispatch(pCmd, pPage)==MB_EXE_OK)
		return (pCmd->getSeqno());
	else return 0;
}



void
TCP_MediaPad::create_page(const PageId &pgId)
{
	Page *pPage = (Page*) pRcvr_->DefinePage(pgId);
	if (!pPage) return;

	// FIXME: shouldn't use CurrTime(), the client should tell me what
	// time it created the item
	MBCmd* pCmd = new MBCmdPgName(TGMB_Manager::instance()->CurrTime(),"");
        if (!pCmd) {
		SignalError(("Out of memory"));
		return;
	}

        pRcvr_->Dispatch(pCmd, pPage);
}


Bool
TGMB_LocalRcvr::Dispatch(MBCmd *pCmd, Page *pPage)
{
	Bool retCode;

	// commands with null sn are local commands about to be executed
	// so we let them thru
	if (pCmd->getSeqno() && pPage->HasCmd(pCmd->getSeqno())) {
		char *szStr = ::PgId2Str(pPage->getId());
		MTrace(trcTGMB|trcExcessive,
		       ("Received duplicate pkt #%lu for page %s",
			pCmd->getSeqno(), szStr));
		delete[] szStr;
		return TRUE;            // treat as okay
	}

	MBBaseMgr *pMgr = TGMB_Manager::instance();
	retCode = executeCmd(pCmd, pPage, cMBTimeNegInf, cMBTimeAny);
	if (retCode==MB_EXE_OK) {
		pPage->AddCmd(pCmd);
		pMgr->activity(pPage, pCmd);
		//pMgr->Rearrange(pPage, pCmd);

		// - The execution of command is successful, therefore
		//   we have at least one packet to sent out.
		// - Ask the page if we need to ask the network to start
		//   pulling packets.
		// - NOTE:for now we don't send packets out of order
		//   which means pPage->RequestSendAmount is 0
		//   if we have more
		//   than one packet. (See Page::RequestSendAmount)
		if (pPage->isVisible()) {
			int nextAmt = pPage->RequestSendAmount();
			MTrace(trcTGMB|trcVerbose, ("nextAmt = %d\n",nextAmt));
			if (nextAmt)
				pMgr->RequestSend(nextAmt +
						  sizeof(Pkt_DataHdr));
		}
	}
	return retCode;
}
