/*
 * BidderHouse.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "BidderHouse.h"
#include "pipe_rend.h"

static class BidderHouseClass : public TclClass {
public:
  BidderHouseClass() : TclClass ("BidderHouse") {}
  TclObject* create(int argc, const char*const* argv) {
    BidderHouse* house;
    if (argc == 5)
      house = new BidderHouse(atoi(argv[4]));
    else
      house = new BidderHouse(128000);
    //    ASSERT(house != NULL);
    return house;
  }
private:
} BidderHouseClass;

int
BidderHouse::command(int argc, const char*const* argv) {
  Tcl& tcl = Tcl::instance();
  if (argc == 2) {
    if (strcmp(argv[1], "hold_bid") == 0) {
      // this is called once at the start and it keeps calling itself after that.
      tcl.evalf("after %d %s hold_bid", BID_INTERVAL, name());
      sellBandwidth();
      return (TCL_OK);
    } else if (strcmp(argv[1], "update_bw") == 0) {
      // called once at start and calls itself after that. Update the bandwidth display.
      tcl.evalf("after %d %s update_bw", UPDATE_INTERVAL, name());
      getBandwidthUsage();
      return (TCL_OK);
    }
  } else if (argc == 4) {
    if (strcmp(argv[1], "set_priority") == 0) {
      // sets the wage, is called when the slider is moved...
      PipeRenderer* src = (PipeRenderer*)TclObject::lookup(argv[2]);
      setPriority(src, atoi(argv[3]));
      return (TCL_OK);
    } 
  } 
  return (TCL_ERROR);
}

// add a new source into the auction.
void
BidderHouse::addSource(PipeRenderer* msource) {
  Bidder* source = new Bidder(0,0,0,0,0,msource);
  sources.push_back(source);
}

// called by the source to tell the auction house how much bandwidth this
// particular source wants.
void
BidderHouse::setDiffCount(PipeRenderer* msource,
			 int diffCount, int meanDiffSize)
{
  Bidder* source = lookupSource(msource);
  source->diffsWant = diffCount;
  source->diffSize = meanDiffSize;
  //  printf("setting Diff count for %d to %d\n",source, diffCount);
}

Bidder*
BidderHouse::lookupSource(PipeRenderer* msource)
{
  for (vector<Bidder*>::iterator e = sources.begin();
       e != sources.end(); e++) {
    if ((*e)->msource == msource)
      return *e;
  }

  //  assert(0);
  return NULL;
}

// called after the auction. tells the source to send its data and
// then updates all relevant fields.
void
BidderHouse::giveBWtoSource(Bidder* source, int price) {
  if ((source->diffsWant == 0) || (source->money == 0) || (source->wage == 0))
    return;

  int temp = source->diffsWant * source->diffSize;
  bytesToSend -= temp;
  source->bandwidth += temp*8;
  source->money -= price*temp;
  source->msource->giveToEncoder(source->diffsWant);
  source->diffsWant = 0;
  //printf("sold bw to %d, money taken is %d, price is %d\n\n",source, price*temp,price);
}

// sorts the bidders to find the highest price.
void
BidderHouse::lotterySort(int num_of_sources) {
  // simple order n squared sort of the arrays by price
  int temp, temp2, u_holder, p_holder;
  Bidder* s_holder;
  for (temp = 0; temp < (num_of_sources-1); temp++) {
    for (temp2 = 0; temp2 < (num_of_sources-1); temp2++) {
      if (lottery_price[temp2] < lottery_price[temp2+1]) {
	s_holder = lottery_source[temp2];
	lottery_source[temp2] = lottery_source[temp2+1];
	lottery_source[temp2+1] = s_holder;
	u_holder = lottery_units[temp2];
	lottery_units[temp2] = lottery_units[temp2+1];
	lottery_units[temp2+1] = u_holder;
	p_holder = lottery_price[temp2];
	lottery_price[temp2] = lottery_price[temp2+1];
	lottery_price[temp2+1] = p_holder;
      }
    }
  }
}

// called regularly based on BID_INTERVAL and does the actual auction.
void
BidderHouse::sellBandwidth()
{
  int totalDemand = 0;
  int temp,x;
  vector<Bidder*>::iterator e;
  Bidder* source;

  // increment the bandwidth pool only if it doesn't allready have too much saved up.
  if (bytesToSend < (MAX_BW_SECONDS*bps)/8) 
    //increment the amount of bandwidth we have available
    bytesToSend += (bps * BID_INTERVAL) / (1000 * 8);
  
  // update the money for each bidder.
  for (e = sources.begin(); e != sources.end(); e++) {
    source = *e;
    // insure that no one has too much money saved
    if (source->money < MAX_SAVED_MONEY)
      // pay everyone
      source->money += (source->wage*WAGE_FACTOR);
    //    printf("source %d has %d money\n",(int)source, source->money);
    // find how many total bytes we want to send
    totalDemand += source->diffsWant * source->diffSize;
  }
  
  if ((totalDemand == 0) || (bytesToSend == 0)) {
    //    printf("not sending anything because no demand or no bw left\n");
    return;
  } else if (totalDemand > bytesToSend) {
    // setup the arrays for doing the market
    int num_of_sources = 0;
    for (e = sources.begin(); e != sources.end(); e++,num_of_sources++) {
      source = *e;
      lottery_source[num_of_sources] = source;
      lottery_units[num_of_sources] = source->diffsWant * source->diffSize;
      if (lottery_units[num_of_sources] == 0)
	lottery_price[num_of_sources] = 0;
      else
	lottery_price[num_of_sources] = source->money/lottery_units[num_of_sources];
      //printf("source %d has %d money, %d units, %d diffs, and can pay %d\n",lottery_source[num_of_sources],source->money,lottery_units[num_of_sources],source->diffsWant,lottery_price[num_of_sources]);
    }

    // sort the array
    lotterySort(num_of_sources);

    // go up the array till you find the point at which you go over units
    temp = 0;
    for (x = 0; x < num_of_sources; x++) {
      temp += lottery_units[x];
      if (temp > bytesToSend)
	break;
    }

    // pick the price right below that point.
    if (x > 0) {
      for (temp=0; temp<x; temp++) {
	giveBWtoSource(lottery_source[temp], lottery_price[x-1]);
      }
    } else {
      //printf("not enough bw. wants %d, but has %d\n\n", lottery_units[0],bytesToSend);
    }
  } else {
    // give everyone what they want...
    for (e = sources.begin(); e != sources.end(); e++) {
      giveBWtoSource(*e, 1);
    }
  }
}

// forwards the bandwidth usage data to the GUI to be displayed.
void
BidderHouse::getBandwidthUsage()
{
  for (vector<Bidder*>::iterator e = sources.begin();
       e != sources.end(); e++) {
    Bidder* source = *e;
    int calculated_bps = (source->bandwidth * 1000)/UPDATE_INTERVAL;
    source->bandwidth = 0;
    source->msource->bandwidthUsage(calculated_bps/1000);
    //    Tcl::instance().evalf("puts \"set bandwidth to %d\"", source->bandwidth/1000);
  }
}

// called from the UI to set a source's wage.
void
BidderHouse::setPriority(PipeRenderer* msource, int percentage)
{
  lookupSource(msource)->wage = percentage;
}

